// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Return the data for a query with the Network Flow Monitor query interface.
// Specify the query that you want to return results for by providing a query ID
// and a scope ID.
//
// This query returns the data for top contributors for workload insights for a
// specific scope. Workload insights provide a high level view of network flow
// performance data collected by agents for a scope. To return just the top
// contributors, see GetQueryResultsWorkloadInsightsTopContributors .
//
// Create a query ID for this call by calling the corresponding API call to start
// the query, StartQueryWorkloadInsightsTopContributorsData . Use the scope ID that
// was returned for your account by CreateScope .
//
// Top contributors in Network Flow Monitor are network flows with the highest
// values for a specific metric type. Top contributors can be across all workload
// insights, for a given scope, or for a specific monitor. Use the applicable call
// for the top contributors that you want to be returned.
//
// The top contributor network flows overall are for a specific metric type, for
// example, the number of retransmissions.
func (c *Client) GetQueryResultsWorkloadInsightsTopContributorsData(ctx context.Context, params *GetQueryResultsWorkloadInsightsTopContributorsDataInput, optFns ...func(*Options)) (*GetQueryResultsWorkloadInsightsTopContributorsDataOutput, error) {
	if params == nil {
		params = &GetQueryResultsWorkloadInsightsTopContributorsDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetQueryResultsWorkloadInsightsTopContributorsData", params, optFns, c.addOperationGetQueryResultsWorkloadInsightsTopContributorsDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetQueryResultsWorkloadInsightsTopContributorsDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetQueryResultsWorkloadInsightsTopContributorsDataInput struct {

	// The identifier for the query. A query ID is an internally-generated identifier
	// for a specific query returned from an API call to create a query.
	//
	// This member is required.
	QueryId *string

	// The identifier for the scope that includes the resources you want to get data
	// results for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account.
	//
	// This member is required.
	ScopeId *string

	// The number of query results that you want to return with this call.
	MaxResults *int32

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string

	noSmithyDocumentSerde
}

type GetQueryResultsWorkloadInsightsTopContributorsDataOutput struct {

	// The datapoints returned by the query.
	//
	// This member is required.
	Datapoints []types.WorkloadInsightsTopContributorsDataPoint

	// The units for a metric returned by the query.
	//
	// This member is required.
	Unit types.MetricUnit

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetQueryResultsWorkloadInsightsTopContributorsDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetQueryResultsWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetQueryResultsWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetQueryResultsWorkloadInsightsTopContributorsData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetQueryResultsWorkloadInsightsTopContributorsDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetQueryResultsWorkloadInsightsTopContributorsData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetQueryResultsWorkloadInsightsTopContributorsDataPaginatorOptions is the
// paginator options for GetQueryResultsWorkloadInsightsTopContributorsData
type GetQueryResultsWorkloadInsightsTopContributorsDataPaginatorOptions struct {
	// The number of query results that you want to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetQueryResultsWorkloadInsightsTopContributorsDataPaginator is a paginator for
// GetQueryResultsWorkloadInsightsTopContributorsData
type GetQueryResultsWorkloadInsightsTopContributorsDataPaginator struct {
	options   GetQueryResultsWorkloadInsightsTopContributorsDataPaginatorOptions
	client    GetQueryResultsWorkloadInsightsTopContributorsDataAPIClient
	params    *GetQueryResultsWorkloadInsightsTopContributorsDataInput
	nextToken *string
	firstPage bool
}

// NewGetQueryResultsWorkloadInsightsTopContributorsDataPaginator returns a new
// GetQueryResultsWorkloadInsightsTopContributorsDataPaginator
func NewGetQueryResultsWorkloadInsightsTopContributorsDataPaginator(client GetQueryResultsWorkloadInsightsTopContributorsDataAPIClient, params *GetQueryResultsWorkloadInsightsTopContributorsDataInput, optFns ...func(*GetQueryResultsWorkloadInsightsTopContributorsDataPaginatorOptions)) *GetQueryResultsWorkloadInsightsTopContributorsDataPaginator {
	if params == nil {
		params = &GetQueryResultsWorkloadInsightsTopContributorsDataInput{}
	}

	options := GetQueryResultsWorkloadInsightsTopContributorsDataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetQueryResultsWorkloadInsightsTopContributorsDataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetQueryResultsWorkloadInsightsTopContributorsDataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetQueryResultsWorkloadInsightsTopContributorsData
// page.
func (p *GetQueryResultsWorkloadInsightsTopContributorsDataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetQueryResultsWorkloadInsightsTopContributorsDataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetQueryResultsWorkloadInsightsTopContributorsData(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetQueryResultsWorkloadInsightsTopContributorsDataAPIClient is a client that
// implements the GetQueryResultsWorkloadInsightsTopContributorsData operation.
type GetQueryResultsWorkloadInsightsTopContributorsDataAPIClient interface {
	GetQueryResultsWorkloadInsightsTopContributorsData(context.Context, *GetQueryResultsWorkloadInsightsTopContributorsDataInput, ...func(*Options)) (*GetQueryResultsWorkloadInsightsTopContributorsDataOutput, error)
}

var _ GetQueryResultsWorkloadInsightsTopContributorsDataAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetQueryResultsWorkloadInsightsTopContributorsData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetQueryResultsWorkloadInsightsTopContributorsData",
	}
}
