// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Begins capturing the flows in a firewall, according to the filters you define.
// Captures are similar, but not identical to snapshots. Capture operations provide
// visibility into flows that are not closed and are tracked by a firewall's flow
// table. Unlike snapshots, captures are a time-boxed view.
//
// A flow is network traffic that is monitored by a firewall, either by stateful
// or stateless rules. For traffic to be considered part of a flow, it must share
// Destination, DestinationPort, Direction, Protocol, Source, and SourcePort.
//
// To avoid encountering operation limits, you should avoid starting captures with
// broad filters, like wide IP ranges. Instead, we recommend you define more
// specific criteria with FlowFilters , like narrow IP ranges, ports, or protocols.
func (c *Client) StartFlowCapture(ctx context.Context, params *StartFlowCaptureInput, optFns ...func(*Options)) (*StartFlowCaptureOutput, error) {
	if params == nil {
		params = &StartFlowCaptureInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartFlowCapture", params, optFns, c.addOperationStartFlowCaptureMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartFlowCaptureOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartFlowCaptureInput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// This member is required.
	FirewallArn *string

	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	//
	// This member is required.
	FlowFilters []types.FlowFilter

	// The ID of the Availability Zone where the firewall is located. For example,
	// us-east-2a .
	//
	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	AvailabilityZone *string

	// The reqested FlowOperation ignores flows with an age (in seconds) lower than
	// MinimumFlowAgeInSeconds . You provide this for start commands.
	//
	// We recommend setting this value to at least 1 minute (60 seconds) to reduce
	// chance of capturing flows that are not yet established.
	MinimumFlowAgeInSeconds *int32

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	VpcEndpointAssociationArn *string

	// A unique identifier for the primary endpoint associated with a firewall.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

type StartFlowCaptureOutput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	FlowOperationId *string

	// Returns the status of the flow operation. This string is returned in the
	// responses to start, list, and describe commands.
	//
	// If the status is COMPLETED_WITH_ERRORS , results may be returned with any number
	// of Flows missing from the response. If the status is FAILED , Flows returned
	// will be empty.
	FlowOperationStatus types.FlowOperationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartFlowCaptureMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartFlowCapture{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartFlowCapture{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartFlowCapture"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartFlowCaptureValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartFlowCapture(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartFlowCapture(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartFlowCapture",
	}
}
