// Code generated by smithy-go-codegen DO NOT EDIT.

package mpa

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mpa/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelSession struct {
}

func (*validateOpCancelSession) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelSessionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateApprovalTeam struct {
}

func (*validateOpCreateApprovalTeam) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApprovalTeam) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApprovalTeamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApprovalTeamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateIdentitySource struct {
}

func (*validateOpCreateIdentitySource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateIdentitySource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateIdentitySourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateIdentitySourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteIdentitySource struct {
}

func (*validateOpDeleteIdentitySource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteIdentitySource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteIdentitySourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteIdentitySourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInactiveApprovalTeamVersion struct {
}

func (*validateOpDeleteInactiveApprovalTeamVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInactiveApprovalTeamVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInactiveApprovalTeamVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInactiveApprovalTeamVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetApprovalTeam struct {
}

func (*validateOpGetApprovalTeam) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetApprovalTeam) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetApprovalTeamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetApprovalTeamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetIdentitySource struct {
}

func (*validateOpGetIdentitySource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetIdentitySource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetIdentitySourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetIdentitySourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPolicyVersion struct {
}

func (*validateOpGetPolicyVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPolicyVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPolicyVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPolicyVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResourcePolicy struct {
}

func (*validateOpGetResourcePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResourcePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResourcePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResourcePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetSession struct {
}

func (*validateOpGetSession) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetSessionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPolicyVersions struct {
}

func (*validateOpListPolicyVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPolicyVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPolicyVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPolicyVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListResourcePolicies struct {
}

func (*validateOpListResourcePolicies) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListResourcePolicies) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListResourcePoliciesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListResourcePoliciesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListSessions struct {
}

func (*validateOpListSessions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListSessions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListSessionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListSessionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartActiveApprovalTeamDeletion struct {
}

func (*validateOpStartActiveApprovalTeamDeletion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartActiveApprovalTeamDeletion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartActiveApprovalTeamDeletionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartActiveApprovalTeamDeletionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateApprovalTeam struct {
}

func (*validateOpUpdateApprovalTeam) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateApprovalTeam) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateApprovalTeamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateApprovalTeamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelSessionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelSession{}, middleware.After)
}

func addOpCreateApprovalTeamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApprovalTeam{}, middleware.After)
}

func addOpCreateIdentitySourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateIdentitySource{}, middleware.After)
}

func addOpDeleteIdentitySourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteIdentitySource{}, middleware.After)
}

func addOpDeleteInactiveApprovalTeamVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInactiveApprovalTeamVersion{}, middleware.After)
}

func addOpGetApprovalTeamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetApprovalTeam{}, middleware.After)
}

func addOpGetIdentitySourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetIdentitySource{}, middleware.After)
}

func addOpGetPolicyVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPolicyVersion{}, middleware.After)
}

func addOpGetResourcePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResourcePolicy{}, middleware.After)
}

func addOpGetSessionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetSession{}, middleware.After)
}

func addOpListPolicyVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPolicyVersions{}, middleware.After)
}

func addOpListResourcePoliciesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListResourcePolicies{}, middleware.After)
}

func addOpListSessionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListSessions{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartActiveApprovalTeamDeletionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartActiveApprovalTeamDeletion{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateApprovalTeamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateApprovalTeam{}, middleware.After)
}

func validateApprovalStrategy(v types.ApprovalStrategy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApprovalStrategy"}
	switch uv := v.(type) {
	case *types.ApprovalStrategyMemberMofN:
		if err := validateMofNApprovalStrategy(&uv.Value); err != nil {
			invalidParams.AddNested("[MofN]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateApprovalTeamRequestApprover(v *types.ApprovalTeamRequestApprover) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApprovalTeamRequestApprover"}
	if v.PrimaryIdentityId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryIdentityId"))
	}
	if v.PrimaryIdentitySourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryIdentitySourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateApprovalTeamRequestApprovers(v []types.ApprovalTeamRequestApprover) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApprovalTeamRequestApprovers"}
	for i := range v {
		if err := validateApprovalTeamRequestApprover(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIamIdentityCenter(v *types.IamIdentityCenter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IamIdentityCenter"}
	if v.InstanceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceArn"))
	}
	if v.Region == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Region"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIdentitySourceParameters(v *types.IdentitySourceParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IdentitySourceParameters"}
	if v.IamIdentityCenter != nil {
		if err := validateIamIdentityCenter(v.IamIdentityCenter); err != nil {
			invalidParams.AddNested("IamIdentityCenter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMofNApprovalStrategy(v *types.MofNApprovalStrategy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MofNApprovalStrategy"}
	if v.MinApprovalsRequired == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinApprovalsRequired"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePoliciesReferences(v []types.PolicyReference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PoliciesReferences"}
	for i := range v {
		if err := validatePolicyReference(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePolicyReference(v *types.PolicyReference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PolicyReference"}
	if v.PolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelSessionInput(v *CancelSessionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelSessionInput"}
	if v.SessionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApprovalTeamInput(v *CreateApprovalTeamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApprovalTeamInput"}
	if v.ApprovalStrategy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApprovalStrategy"))
	} else if v.ApprovalStrategy != nil {
		if err := validateApprovalStrategy(v.ApprovalStrategy); err != nil {
			invalidParams.AddNested("ApprovalStrategy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Approvers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Approvers"))
	} else if v.Approvers != nil {
		if err := validateApprovalTeamRequestApprovers(v.Approvers); err != nil {
			invalidParams.AddNested("Approvers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.Policies == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Policies"))
	} else if v.Policies != nil {
		if err := validatePoliciesReferences(v.Policies); err != nil {
			invalidParams.AddNested("Policies", err.(smithy.InvalidParamsError))
		}
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateIdentitySourceInput(v *CreateIdentitySourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateIdentitySourceInput"}
	if v.IdentitySourceParameters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IdentitySourceParameters"))
	} else if v.IdentitySourceParameters != nil {
		if err := validateIdentitySourceParameters(v.IdentitySourceParameters); err != nil {
			invalidParams.AddNested("IdentitySourceParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteIdentitySourceInput(v *DeleteIdentitySourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteIdentitySourceInput"}
	if v.IdentitySourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IdentitySourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInactiveApprovalTeamVersionInput(v *DeleteInactiveApprovalTeamVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInactiveApprovalTeamVersionInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.VersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VersionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetApprovalTeamInput(v *GetApprovalTeamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetApprovalTeamInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetIdentitySourceInput(v *GetIdentitySourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetIdentitySourceInput"}
	if v.IdentitySourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IdentitySourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPolicyVersionInput(v *GetPolicyVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPolicyVersionInput"}
	if v.PolicyVersionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyVersionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResourcePolicyInput(v *GetResourcePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResourcePolicyInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.PolicyName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyName"))
	}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetSessionInput(v *GetSessionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetSessionInput"}
	if v.SessionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPolicyVersionsInput(v *ListPolicyVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPolicyVersionsInput"}
	if v.PolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListResourcePoliciesInput(v *ListResourcePoliciesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListResourcePoliciesInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListSessionsInput(v *ListSessionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListSessionsInput"}
	if v.ApprovalTeamArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApprovalTeamArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartActiveApprovalTeamDeletionInput(v *StartActiveApprovalTeamDeletionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartActiveApprovalTeamDeletionInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateApprovalTeamInput(v *UpdateApprovalTeamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateApprovalTeamInput"}
	if v.ApprovalStrategy != nil {
		if err := validateApprovalStrategy(v.ApprovalStrategy); err != nil {
			invalidParams.AddNested("ApprovalStrategy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Approvers != nil {
		if err := validateApprovalTeamRequestApprovers(v.Approvers); err != nil {
			invalidParams.AddNested("Approvers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
