// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The settings to enable CDN authorization headers in MediaPackage.
type CdnAuthConfiguration struct {

	// The ARN for the secret in Secrets Manager that your CDN uses for authorization
	// to access the endpoint.
	//
	// This member is required.
	CdnIdentifierSecretArns []string

	// The ARN for the IAM role that gives MediaPackage read access to Secrets Manager
	// and KMS for CDN authorization.
	//
	// This member is required.
	SecretsRoleArn *string

	noSmithyDocumentSerde
}

// The configuration of the channel group.
type ChannelGroupListConfiguration struct {

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// This member is required.
	Arn *string

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// This member is required.
	ChannelGroupName *string

	// The date and time the channel group was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time the channel group was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// Any descriptive information that you want to add to the channel group for
	// future identification purposes.
	Description *string

	noSmithyDocumentSerde
}

// The configuration of the channel.
type ChannelListConfiguration struct {

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// This member is required.
	Arn *string

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// This member is required.
	ChannelGroupName *string

	// The name that describes the channel. The name is the primary identifier for the
	// channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// This member is required.
	ChannelName *string

	// The date and time the channel was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time the channel was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// Any descriptive information that you want to add to the channel for future
	// identification purposes.
	Description *string

	// The input type will be an immutable field which will be used to define whether
	// the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default
	// to HLS to preserve current behavior.
	//
	// The allowed values are:
	//
	//   - HLS - The HLS streaming specification (which defines M3U8 manifests and TS
	//   segments).
	//
	//   - CMAF - The DASH-IF CMAF Ingest specification (which defines CMAF segments
	//   with optional DASH manifests).
	InputType InputType

	noSmithyDocumentSerde
}

// Create a DASH manifest configuration.
type CreateDashManifestConfiguration struct {

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint.
	//
	// This member is required.
	ManifestName *string

	// The base URLs to use for retrieving segments.
	BaseUrls []DashBaseUrl

	// The layout of the DASH manifest that MediaPackage produces. STANDARD indicates
	// a default manifest, which is compacted. NONE indicates a full manifest.
	//
	// For information about compactness, see [DASH manifest compactness] in the Elemental MediaPackage v2 User
	// Guide.
	//
	// [DASH manifest compactness]: https://docs.aws.amazon.com/mediapackage/latest/userguide/compacted.html
	Compactness DashCompactness

	// Determines how the DASH manifest signals the DRM content.
	DrmSignaling DashDrmSignaling

	// For endpoints that use the DVB-DASH profile only. The font download and error
	// reporting information that you want MediaPackage to pass through to the
	// manifest.
	DvbSettings *DashDvbSettings

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Minimum amount of content (in seconds) that a player must keep available in the
	// buffer.
	MinBufferTimeSeconds *int32

	// Minimum amount of time (in seconds) that the player should wait before
	// requesting updates to the manifest.
	MinUpdatePeriodSeconds *int32

	// A list of triggers that controls when AWS Elemental MediaPackage separates the
	// MPEG-DASH manifest into multiple periods. Type ADS to indicate that AWS
	// Elemental MediaPackage must create periods in the output manifest that
	// correspond to SCTE-35 ad markers in the input source. Leave this value empty to
	// indicate that the manifest is contained all in one period. For more information
	// about periods in the DASH manifest, see [Multi-period DASH in AWS Elemental MediaPackage].
	//
	// [Multi-period DASH in AWS Elemental MediaPackage]: https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html
	PeriodTriggers []DashPeriodTrigger

	// The profile that the output is compliant with.
	Profiles []DashProfile

	// Details about the content that you want MediaPackage to pass through in the
	// manifest to the playback device.
	ProgramInformation *DashProgramInformation

	// The SCTE configuration.
	ScteDash *ScteDash

	// Determines the type of variable used in the media URL of the SegmentTemplate
	// tag in the manifest. Also specifies if segment timeline information is included
	// in SegmentTimeline or SegmentTemplate .
	//
	// Value description:
	//
	//   - NUMBER_WITH_TIMELINE - The $Number$ variable is used in the media URL. The
	//   value of this variable is the sequential number of the segment. A full
	//   SegmentTimeline object is presented in each SegmentTemplate .
	SegmentTemplateFormat DashSegmentTemplateFormat

	// The configuration for DASH subtitles.
	SubtitleConfiguration *DashSubtitleConfiguration

	// The amount of time (in seconds) that the player should be from the end of the
	// manifest.
	SuggestedPresentationDelaySeconds *int32

	// Determines the type of UTC timing included in the DASH Media Presentation
	// Description (MPD).
	UtcTiming *DashUtcTiming

	noSmithyDocumentSerde
}

// Create an HTTP live streaming (HLS) manifest configuration.
type CreateHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index, with an added suffix to distinguish it
	// from the manifest name. The manifestName on the HLSManifest object overrides the
	// manifestName you provided on the originEndpoint object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	// To insert an EXT-X-START tag in your HLS playlist, specify a StartTag
	// configuration object with a valid TimeOffset. When you do, you can also
	// optionally specify whether to include a PRECISE value in the EXT-X-START tag.
	StartTag *StartTag

	// When enabled, MediaPackage URL-encodes the query string for API requests for
	// HLS child manifests to comply with Amazon Web Services Signature Version 4
	// (SigV4) signature signing protocol. For more information, see [Amazon Web Services Signature Version 4 for API requests]in Identity and
	// Access Management User Guide.
	//
	// [Amazon Web Services Signature Version 4 for API requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html
	UrlEncodeChildManifest *bool

	noSmithyDocumentSerde
}

// Create a low-latency HTTP live streaming (HLS) manifest configuration.
type CreateLowLatencyHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index, with an added suffix to distinguish it
	// from the manifest name. The manifestName on the HLSManifest object overrides the
	// manifestName you provided on the originEndpoint object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	// To insert an EXT-X-START tag in your HLS playlist, specify a StartTag
	// configuration object with a valid TimeOffset. When you do, you can also
	// optionally specify whether to include a PRECISE value in the EXT-X-START tag.
	StartTag *StartTag

	// When enabled, MediaPackage URL-encodes the query string for API requests for
	// LL-HLS child manifests to comply with Amazon Web Services Signature Version 4
	// (SigV4) signature signing protocol. For more information, see [Amazon Web Services Signature Version 4 for API requests]in Identity and
	// Access Management User Guide.
	//
	// [Amazon Web Services Signature Version 4 for API requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html
	UrlEncodeChildManifest *bool

	noSmithyDocumentSerde
}

// Configuration parameters for creating a Microsoft Smooth Streaming (MSS)
// manifest. MSS is a streaming media format developed by Microsoft that delivers
// adaptive bitrate streaming content to compatible players and devices.
type CreateMssManifestConfiguration struct {

	// A short string that's appended to the endpoint URL to create a unique path to
	// this MSS manifest. The manifest name must be unique within the origin endpoint
	// and can contain letters, numbers, hyphens, and underscores.
	//
	// This member is required.
	ManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// Determines the layout format of the MSS manifest. This controls how the
	// manifest is structured and presented to client players, affecting compatibility
	// with different MSS-compatible devices and applications.
	ManifestLayout MssManifestLayout

	// The total duration (in seconds) of the manifest window. This determines how
	// much content is available in the manifest at any given time. The manifest window
	// slides forward as new segments become available, maintaining a consistent
	// duration of content. The minimum value is 30 seconds.
	ManifestWindowSeconds *int32

	noSmithyDocumentSerde
}

// The base URLs to use for retrieving segments. You can specify multiple
// locations and indicate the priority and weight for when each should be used, for
// use in mutli-CDN workflows.
type DashBaseUrl struct {

	// A source location for segments.
	//
	// This member is required.
	Url *string

	// For use with DVB-DASH profiles only. The priority of this location for servings
	// segments. The lower the number, the higher the priority.
	DvbPriority *int32

	// For use with DVB-DASH profiles only. The weighting for source locations that
	// have the same priority.
	DvbWeight *int32

	// The name of the source location.
	ServiceLocation *string

	noSmithyDocumentSerde
}

// For use with DVB-DASH profiles only. The settings for font downloads that you
// want Elemental MediaPackage to pass through to the manifest.
type DashDvbFontDownload struct {

	// The fontFamily name for subtitles, as described in [EBU-TT-D Subtitling Distribution Format].
	//
	// [EBU-TT-D Subtitling Distribution Format]: https://tech.ebu.ch/publications/tech3380
	FontFamily *string

	// The mimeType of the resource that's at the font download URL.
	//
	// For information about font MIME types, see the [MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks] document.
	//
	// [MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks]: https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf
	MimeType *string

	// The URL for downloading fonts for subtitles.
	Url *string

	noSmithyDocumentSerde
}

// For use with DVB-DASH profiles only. The settings for error reporting from the
// playback device that you want Elemental MediaPackage to pass through to the
// manifest.
type DashDvbMetricsReporting struct {

	// The URL where playback devices send error reports.
	//
	// This member is required.
	ReportingUrl *string

	// The number of playback devices per 1000 that will send error reports to the
	// reporting URL. This represents the probability that a playback device will be a
	// reporting player for this session.
	Probability *int32

	noSmithyDocumentSerde
}

// For endpoints that use the DVB-DASH profile only. The font download and error
// reporting information that you want MediaPackage to pass through to the
// manifest.
type DashDvbSettings struct {

	// Playback device error reporting settings.
	ErrorMetrics []DashDvbMetricsReporting

	// Subtitle font settings.
	FontDownload *DashDvbFontDownload

	noSmithyDocumentSerde
}

// Details about the content that you want MediaPackage to pass through in the
// manifest to the playback device.
type DashProgramInformation struct {

	// A copyright statement about the content.
	Copyright *string

	// The language code for this manifest.
	LanguageCode *string

	// An absolute URL that contains more information about this content.
	MoreInformationUrl *string

	// Information about the content provider.
	Source *string

	// The title for the manifest.
	Title *string

	noSmithyDocumentSerde
}

// The configuration for DASH subtitles.
type DashSubtitleConfiguration struct {

	// Settings for TTML subtitles.
	TtmlConfiguration *DashTtmlConfiguration

	noSmithyDocumentSerde
}

// The settings for TTML subtitles.
type DashTtmlConfiguration struct {

	// The profile that MediaPackage uses when signaling subtitles in the manifest.
	// IMSC is the default profile. EBU-TT-D produces subtitles that are compliant
	// with the EBU-TT-D TTML profile. MediaPackage passes through subtitle styles to
	// the manifest. For more information about EBU-TT-D subtitles, see [EBU-TT-D Subtitling Distribution Format].
	//
	// [EBU-TT-D Subtitling Distribution Format]: https://tech.ebu.ch/publications/tech3380
	//
	// This member is required.
	TtmlProfile DashTtmlProfile

	noSmithyDocumentSerde
}

// Determines the type of UTC timing included in the DASH Media Presentation
// Description (MPD).
type DashUtcTiming struct {

	// The UTC timing mode.
	TimingMode DashUtcTimingMode

	// The the method that the player uses to synchronize to coordinated universal
	// time (UTC) wall clock time.
	TimingSource *string

	noSmithyDocumentSerde
}

// The configuration for the destination where the harvested content will be
// exported.
type Destination struct {

	// The configuration for exporting harvested content to an S3 bucket. This
	// includes details such as the bucket name and destination path within the bucket.
	//
	// This member is required.
	S3Destination *S3DestinationConfig

	noSmithyDocumentSerde
}

// The parameters for encrypting content.
type Encryption struct {

	// The encryption method to use.
	//
	// This member is required.
	EncryptionMethod *EncryptionMethod

	// The parameters for the SPEKE key provider.
	//
	// This member is required.
	SpekeKeyProvider *SpekeKeyProvider

	// Excludes SEIG and SGPD boxes from segment metadata in CMAF containers.
	//
	// When set to true , MediaPackage omits these DRM metadata boxes from CMAF
	// segments, which can improve compatibility with certain devices and players that
	// don't support these boxes.
	//
	// Important considerations:
	//
	//   - This setting only affects CMAF container formats
	//
	//   - Key rotation can still be handled through media playlist signaling
	//
	//   - PSSH and TENC boxes remain unaffected
	//
	//   - Default behavior is preserved when this setting is disabled
	//
	// Valid values: true | false
	//
	// Default: false
	CmafExcludeSegmentDrmMetadata *bool

	// A 128-bit, 16-byte hex value represented by a 32-character string, used in
	// conjunction with the key for encrypting content. If you don't specify a value,
	// then MediaPackage creates the constant initialization vector (IV).
	ConstantInitializationVector *string

	// The frequency (in seconds) of key changes for live workflows, in which content
	// is streamed real time. The service retrieves content keys before the live
	// content begins streaming, and then retrieves them as needed over the lifetime of
	// the workflow. By default, key rotation is set to 300 seconds (5 minutes), the
	// minimum rotation interval, which is equivalent to setting it to 300. If you
	// don't enter an interval, content keys aren't rotated.
	//
	// The following example setting causes the service to rotate keys every thirty
	// minutes: 1800
	KeyRotationIntervalSeconds *int32

	noSmithyDocumentSerde
}

// Configure one or more content encryption keys for your endpoints that use SPEKE
// Version 2.0. The encryption contract defines which content keys are used to
// encrypt the audio and video tracks in your stream. To configure the encryption
// contract, specify which audio and video encryption presets to use.
type EncryptionContractConfiguration struct {

	// A collection of audio encryption presets.
	//
	// Value description:
	//
	//   - PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in
	//   your stream.
	//
	//   - PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio
	//   tracks and one content key to encrypt all of the multichannel audio tracks.
	//
	//   - PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio
	//   tracks, one content key to encrypt all of the multichannel audio tracks with 3
	//   to 6 channels, and one content key to encrypt all of the multichannel audio
	//   tracks with more than 6 channels.
	//
	//   - SHARED - Use the same content key for all of the audio and video tracks in
	//   your stream.
	//
	//   - UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
	//
	// This member is required.
	PresetSpeke20Audio PresetSpeke20Audio

	// A collection of video encryption presets.
	//
	// Value description:
	//
	//   - PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in
	//   your stream.
	//
	//   - PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks
	//   and one content key for all HD and higher resolutions video tracks.
	//
	//   - PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD video tracks and one content key for all UHD video
	//   tracks.
	//
	//   - PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD video tracks, one content key for all UHD1 video tracks
	//   and one content key for all UHD2 video tracks.
	//
	//   - PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD1 video tracks, one content key for HD2 video tracks, one
	//   content key for all UHD1 video tracks and one content key for all UHD2 video
	//   tracks.
	//
	//   - PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD1 video tracks, one content key for HD2 video tracks and
	//   one content key for all UHD video tracks.
	//
	//   - PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video
	//   tracks, one content key for HD2 video tracks and one content key for all UHD
	//   video tracks.
	//
	//   - PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video
	//   tracks, one content key for HD2 video tracks, one content key for all UHD1 video
	//   tracks and one content key for all UHD2 video tracks.
	//
	//   - SHARED - Use the same content key for all of the video and audio tracks in
	//   your stream.
	//
	//   - UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
	//
	// This member is required.
	PresetSpeke20Video PresetSpeke20Video

	noSmithyDocumentSerde
}

// The encryption type.
type EncryptionMethod struct {

	// The encryption method to use.
	CmafEncryptionMethod CmafEncryptionMethod

	// The encryption method used for Microsoft Smooth Streaming (MSS) content. This
	// specifies how the MSS segments are encrypted to protect the content during
	// delivery to client players.
	IsmEncryptionMethod IsmEncryptionMethod

	// The encryption method to use.
	TsEncryptionMethod TsEncryptionMethod

	noSmithyDocumentSerde
}

// Filter configuration includes settings for manifest filtering, start and end
// times, and time delay that apply to all of your egress requests for this
// manifest.
type FilterConfiguration struct {

	// Optionally specify the clip start time for all of your manifest egress
	// requests. When you include clip start time, note that you cannot use clip start
	// time query parameters for this manifest's endpoint URL.
	ClipStartTime *time.Time

	// Optionally specify the end time for all of your manifest egress requests. When
	// you include end time, note that you cannot use end time query parameters for
	// this manifest's endpoint URL.
	End *time.Time

	// Optionally specify one or more manifest filters for all of your manifest egress
	// requests. When you include a manifest filter, note that you cannot use an
	// identical manifest filter query parameter for this manifest's endpoint URL.
	ManifestFilter *string

	// Optionally specify the start time for all of your manifest egress requests.
	// When you include start time, note that you cannot use start time query
	// parameters for this manifest's endpoint URL.
	Start *time.Time

	// Optionally specify the time delay for all of your manifest egress requests.
	// Enter a value that is smaller than your endpoint's startover window. When you
	// include time delay, note that you cannot use time delay query parameters for
	// this manifest's endpoint URL.
	TimeDelaySeconds *int32

	noSmithyDocumentSerde
}

// The failover settings for the endpoint.
type ForceEndpointErrorConfiguration struct {

	// The failover conditions for the endpoint. The options are:
	//
	//   - STALE_MANIFEST - The manifest stalled and there are no new segments or parts.
	//
	//   - INCOMPLETE_MANIFEST - There is a gap in the manifest.
	//
	//   - MISSING_DRM_KEY - Key rotation is enabled but we're unable to fetch the key
	//   for the current key period.
	//
	//   - SLATE_INPUT - The segments which contain slate content are considered to be
	//   missing content.
	EndpointErrorConditions []EndpointErrorCondition

	noSmithyDocumentSerde
}

// Retrieve the DASH manifest configuration.
type GetDashManifestConfiguration struct {

	// A short string that's appended to the endpoint URL. The manifest name creates a
	// unique path to this endpoint. If you don't enter a value, MediaPackage uses the
	// default manifest name, index.
	//
	// This member is required.
	ManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// This member is required.
	Url *string

	// The base URL to use for retrieving segments.
	BaseUrls []DashBaseUrl

	// The layout of the DASH manifest that MediaPackage produces. STANDARD indicates
	// a default manifest, which is compacted. NONE indicates a full manifest.
	Compactness DashCompactness

	// Determines how the DASH manifest signals the DRM content.
	DrmSignaling DashDrmSignaling

	// For endpoints that use the DVB-DASH profile only. The font download and error
	// reporting information that you want MediaPackage to pass through to the
	// manifest.
	DvbSettings *DashDvbSettings

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Minimum amount of content (in seconds) that a player must keep available in the
	// buffer.
	MinBufferTimeSeconds *int32

	// Minimum amount of time (in seconds) that the player should wait before
	// requesting updates to the manifest.
	MinUpdatePeriodSeconds *int32

	// A list of triggers that controls when AWS Elemental MediaPackage separates the
	// MPEG-DASH manifest into multiple periods. Leave this value empty to indicate
	// that the manifest is contained all in one period. For more information about
	// periods in the DASH manifest, see [Multi-period DASH in AWS Elemental MediaPackage].
	//
	// [Multi-period DASH in AWS Elemental MediaPackage]: https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html
	PeriodTriggers []DashPeriodTrigger

	// The profile that the output is compliant with.
	Profiles []DashProfile

	// Details about the content that you want MediaPackage to pass through in the
	// manifest to the playback device.
	ProgramInformation *DashProgramInformation

	// The SCTE configuration.
	ScteDash *ScteDash

	// Determines the type of variable used in the media URL of the SegmentTemplate
	// tag in the manifest. Also specifies if segment timeline information is included
	// in SegmentTimeline or SegmentTemplate .
	//
	// Value description:
	//
	//   - NUMBER_WITH_TIMELINE - The $Number$ variable is used in the media URL. The
	//   value of this variable is the sequential number of the segment. A full
	//   SegmentTimeline object is presented in each SegmentTemplate .
	SegmentTemplateFormat DashSegmentTemplateFormat

	// The configuration for DASH subtitles.
	SubtitleConfiguration *DashSubtitleConfiguration

	// The amount of time (in seconds) that the player should be from the end of the
	// manifest.
	SuggestedPresentationDelaySeconds *int32

	// Determines the type of UTC timing included in the DASH Media Presentation
	// Description (MPD).
	UtcTiming *DashUtcTiming

	noSmithyDocumentSerde
}

// Retrieve the HTTP live streaming (HLS) manifest configuration.
type GetHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// This member is required.
	Url *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	// To insert an EXT-X-START tag in your HLS playlist, specify a StartTag
	// configuration object with a valid TimeOffset. When you do, you can also
	// optionally specify whether to include a PRECISE value in the EXT-X-START tag.
	StartTag *StartTag

	// When enabled, MediaPackage URL-encodes the query string for API requests for
	// HLS child manifests to comply with Amazon Web Services Signature Version 4
	// (SigV4) signature signing protocol. For more information, see [Amazon Web Services Signature Version 4 for API requests]in Identity and
	// Access Management User Guide.
	//
	// [Amazon Web Services Signature Version 4 for API requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html
	UrlEncodeChildManifest *bool

	noSmithyDocumentSerde
}

// Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.
type GetLowLatencyHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// This member is required.
	Url *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	// To insert an EXT-X-START tag in your HLS playlist, specify a StartTag
	// configuration object with a valid TimeOffset. When you do, you can also
	// optionally specify whether to include a PRECISE value in the EXT-X-START tag.
	StartTag *StartTag

	// When enabled, MediaPackage URL-encodes the query string for API requests for
	// LL-HLS child manifests to comply with Amazon Web Services Signature Version 4
	// (SigV4) signature signing protocol. For more information, see [Amazon Web Services Signature Version 4 for API requests]in Identity and
	// Access Management User Guide.
	//
	// [Amazon Web Services Signature Version 4 for API requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html
	UrlEncodeChildManifest *bool

	noSmithyDocumentSerde
}

// Configuration details for a Microsoft Smooth Streaming (MSS) manifest
// associated with an origin endpoint. This includes all the settings and
// properties that define how the MSS content is packaged and delivered.
type GetMssManifestConfiguration struct {

	// The name of the MSS manifest. This name is appended to the origin endpoint URL
	// to create the unique path for accessing this specific MSS manifest.
	//
	// This member is required.
	ManifestName *string

	// The complete URL for accessing the MSS manifest. Client players use this URL to
	// retrieve the manifest and begin streaming the Microsoft Smooth Streaming
	// content.
	//
	// This member is required.
	Url *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The layout format of the MSS manifest, which determines how the manifest is
	// structured for client compatibility.
	ManifestLayout MssManifestLayout

	// The duration (in seconds) of the manifest window. This represents the total
	// amount of content available in the manifest at any given time.
	ManifestWindowSeconds *int32

	noSmithyDocumentSerde
}

// Information about a harvested DASH manifest.
type HarvestedDashManifest struct {

	// The name of the harvested DASH manifest.
	//
	// This member is required.
	ManifestName *string

	noSmithyDocumentSerde
}

// Information about a harvested HLS manifest.
type HarvestedHlsManifest struct {

	// The name of the harvested HLS manifest.
	//
	// This member is required.
	ManifestName *string

	noSmithyDocumentSerde
}

// Information about a harvested Low-Latency HLS manifest.
type HarvestedLowLatencyHlsManifest struct {

	// The name of the harvested Low-Latency HLS manifest.
	//
	// This member is required.
	ManifestName *string

	noSmithyDocumentSerde
}

// A collection of harvested manifests of different types.
type HarvestedManifests struct {

	// A list of harvested DASH manifests.
	DashManifests []HarvestedDashManifest

	// A list of harvested HLS manifests.
	HlsManifests []HarvestedHlsManifest

	// A list of harvested Low-Latency HLS manifests.
	LowLatencyHlsManifests []HarvestedLowLatencyHlsManifest

	noSmithyDocumentSerde
}

// Defines the schedule configuration for a harvest job.
type HarvesterScheduleConfiguration struct {

	// The end time for the harvest job.
	//
	// This member is required.
	EndTime *time.Time

	// The start time for the harvest job.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Represents a harvest job resource in MediaPackage v2, which is used to export
// content from an origin endpoint to an S3 bucket.
type HarvestJob struct {

	// The Amazon Resource Name (ARN) of the harvest job.
	//
	// This member is required.
	Arn *string

	// The name of the channel group containing the channel associated with this
	// harvest job.
	//
	// This member is required.
	ChannelGroupName *string

	// The name of the channel associated with this harvest job.
	//
	// This member is required.
	ChannelName *string

	// The date and time when the harvest job was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The S3 destination where the harvested content will be placed.
	//
	// This member is required.
	Destination *Destination

	// The name of the harvest job.
	//
	// This member is required.
	HarvestJobName *string

	// A list of manifests that are being or have been harvested.
	//
	// This member is required.
	HarvestedManifests *HarvestedManifests

	// The date and time when the harvest job was last modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the origin endpoint associated with this harvest job.
	//
	// This member is required.
	OriginEndpointName *string

	// The configuration for when the harvest job is scheduled to run.
	//
	// This member is required.
	ScheduleConfiguration *HarvesterScheduleConfiguration

	// The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED,
	// COMPLETED, FAILED).
	//
	// This member is required.
	Status HarvestJobStatus

	// An optional description of the harvest job.
	Description *string

	// The current version of the harvest job. Used for concurrency control.
	ETag *string

	// An error message if the harvest job encountered any issues.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The ingest domain URL where the source stream should be sent.
type IngestEndpoint struct {

	// The system-generated unique identifier for the IngestEndpoint.
	Id *string

	// The ingest domain URL where the source stream should be sent.
	Url *string

	noSmithyDocumentSerde
}

// The configuration for input switching based on the media quality confidence
// score (MQCS) as provided from AWS Elemental MediaLive.
type InputSwitchConfiguration struct {

	// When true, AWS Elemental MediaPackage performs input switching based on the
	// MQCS. Default is true. This setting is valid only when InputType is CMAF .
	MQCSInputSwitching *bool

	// For CMAF inputs, indicates which input MediaPackage should prefer when both
	// inputs have equal MQCS scores. Select 1 to prefer the first ingest endpoint, or
	// 2 to prefer the second ingest endpoint. If you don't specify a preferred input,
	// MediaPackage uses its default switching behavior when MQCS scores are equal.
	PreferredInput *int32

	noSmithyDocumentSerde
}

// List the DASH manifest configuration.
type ListDashManifestConfiguration struct {

	// A short string that's appended to the endpoint URL. The manifest name creates a
	// unique path to this endpoint. If you don't enter a value, MediaPackage uses the
	// default manifest name, index.
	//
	// This member is required.
	ManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string

	noSmithyDocumentSerde
}

// List the HTTP live streaming (HLS) manifest configuration.
type ListHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string

	noSmithyDocumentSerde
}

// List the low-latency HTTP live streaming (HLS) manifest configuration.
type ListLowLatencyHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string

	noSmithyDocumentSerde
}

// Summary information about a Microsoft Smooth Streaming (MSS) manifest
// configuration. This provides key details about the MSS manifest without
// including all configuration parameters.
type ListMssManifestConfiguration struct {

	// The name of the MSS manifest configuration.
	//
	// This member is required.
	ManifestName *string

	// The URL for accessing the MSS manifest.
	Url *string

	noSmithyDocumentSerde
}

// The configuration of the origin endpoint.
type OriginEndpointListConfiguration struct {

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// This member is required.
	Arn *string

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// This member is required.
	ChannelGroupName *string

	// The name that describes the channel. The name is the primary identifier for the
	// channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// This member is required.
	ChannelName *string

	// The type of container attached to this origin endpoint. A container type is a
	// file format that encapsulates one or more media streams, such as audio and
	// video, into a single file.
	//
	// This member is required.
	ContainerType ContainerType

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// This member is required.
	OriginEndpointName *string

	// The date and time the origin endpoint was created.
	CreatedAt *time.Time

	// A DASH manifest configuration.
	DashManifests []ListDashManifestConfiguration

	// Any descriptive information that you want to add to the origin endpoint for
	// future identification purposes.
	Description *string

	// The failover settings for the endpoint.
	ForceEndpointErrorConfiguration *ForceEndpointErrorConfiguration

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []ListHlsManifestConfiguration

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []ListLowLatencyHlsManifestConfiguration

	// The date and time the origin endpoint was modified.
	ModifiedAt *time.Time

	// A list of Microsoft Smooth Streaming (MSS) manifest configurations associated
	// with the origin endpoint. Each configuration represents a different MSS
	// streaming option available from this endpoint.
	MssManifests []ListMssManifestConfiguration

	noSmithyDocumentSerde
}

// The settings for what common media server data (CMSD) headers AWS Elemental
// MediaPackage includes in responses to the CDN.
type OutputHeaderConfiguration struct {

	// When true, AWS Elemental MediaPackage includes the MQCS in responses to the
	// CDN. This setting is valid only when InputType is CMAF .
	PublishMQCS *bool

	noSmithyDocumentSerde
}

// Configuration parameters for where in an S3 bucket to place the harvested
// content.
type S3DestinationConfig struct {

	// The name of an S3 bucket within which harvested content will be exported.
	//
	// This member is required.
	BucketName *string

	// The path within the specified S3 bucket where the harvested content will be
	// placed.
	//
	// This member is required.
	DestinationPath *string

	noSmithyDocumentSerde
}

// The SCTE configuration.
type Scte struct {

	// The SCTE-35 message types that you want to be treated as ad markers in the
	// output.
	ScteFilter []ScteFilter

	noSmithyDocumentSerde
}

// The SCTE configuration.
type ScteDash struct {

	// Choose how ad markers are included in the packaged content. If you include ad
	// markers in the content stream in your upstream encoders, then you need to inform
	// MediaPackage what to do with the ad markers in the output.
	//
	// Value description:
	//
	//   - Binary - The SCTE-35 marker is expressed as a hex-string (Base64 string)
	//   rather than full XML.
	//
	//   - XML - The SCTE marker is expressed fully in XML.
	AdMarkerDash AdMarkerDash

	noSmithyDocumentSerde
}

// The SCTE configuration.
type ScteHls struct {

	// Ad markers indicate when ads should be inserted during playback. If you include
	// ad markers in the content stream in your upstream encoders, then you need to
	// inform MediaPackage what to do with the ad markers in the output. Choose what
	// you want MediaPackage to do with the ad markers.
	//
	// Value description:
	//
	//   - DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition
	//   events in TS and CMAF manifests. If you use DATERANGE, you must set a
	//   programDateTimeIntervalSeconds value of 1 or higher. To learn more about
	//   DATERANGE, see [SCTE-35 Ad Marker EXT-X-DATERANGE].
	//
	// [SCTE-35 Ad Marker EXT-X-DATERANGE]: http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html
	AdMarkerHls AdMarkerHls

	noSmithyDocumentSerde
}

// The segment configuration, including the segment name, duration, and other
// configuration values.
type Segment struct {

	// The parameters for encrypting content.
	Encryption *Encryption

	// When selected, the stream set includes an additional I-frame only stream, along
	// with the other tracks. If false, this extra stream is not included. MediaPackage
	// generates an I-frame only stream from the first rendition in the manifest. The
	// service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then
	// generates and includes an I-frames only playlist in the stream. This playlist
	// permits player functionality like fast forward and rewind.
	IncludeIframeOnlyStreams *bool

	// The SCTE configuration options in the segment settings.
	Scte *Scte

	// The duration (in seconds) of each segment. Enter a value equal to, or a
	// multiple of, the input segment duration. If the value that you enter is
	// different from the input segment duration, MediaPackage rounds segments to the
	// nearest multiple of the input segment duration.
	SegmentDurationSeconds *int32

	// The name that describes the segment. The name is the base name of the segment
	// used in all content manifests inside of the endpoint. You can't use spaces in
	// the name.
	SegmentName *string

	// By default, MediaPackage excludes all digital video broadcasting (DVB)
	// subtitles from the output. When selected, MediaPackage passes through DVB
	// subtitles into the output.
	TsIncludeDvbSubtitles *bool

	// When selected, MediaPackage bundles all audio tracks in a rendition group. All
	// other tracks in the stream can be used with any audio rendition from the group.
	TsUseAudioRenditionGroup *bool

	noSmithyDocumentSerde
}

// The parameters for the SPEKE key provider.
type SpekeKeyProvider struct {

	// The DRM solution provider you're using to protect your content during
	// distribution.
	//
	// This member is required.
	DrmSystems []DrmSystem

	// Configure one or more content encryption keys for your endpoints that use SPEKE
	// Version 2.0. The encryption contract defines which content keys are used to
	// encrypt the audio and video tracks in your stream. To configure the encryption
	// contract, specify which audio and video encryption presets to use.
	//
	// This member is required.
	EncryptionContractConfiguration *EncryptionContractConfiguration

	// The unique identifier for the content. The service sends this to the key server
	// to identify the current endpoint. How unique you make this depends on how
	// fine-grained you want access controls to be. The service does not permit you to
	// use the same ID for two simultaneous encryption processes. The resource ID is
	// also known as the content ID.
	//
	// The following example shows a resource ID: MovieNight20171126093045
	//
	// This member is required.
	ResourceId *string

	// The ARN for the IAM role granted by the key provider that provides access to
	// the key provider API. This role must have a trust policy that allows
	// MediaPackage to assume the role, and it must have a sufficient permissions
	// policy to allow access to the specific key retrieval URL. Get this from your DRM
	// solution provider.
	//
	// Valid format: arn:aws:iam::{accountID}:role/{name} . The following example shows
	// a role ARN: arn:aws:iam::444455556666:role/SpekeAccess
	//
	// This member is required.
	RoleArn *string

	// The URL of the API Gateway proxy that you set up to talk to your key server.
	// The API Gateway proxy must reside in the same AWS Region as MediaPackage and
	// must start with https://.
	//
	// The following example shows a URL:
	// https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection
	//
	// This member is required.
	Url *string

	noSmithyDocumentSerde
}

// To insert an EXT-X-START tag in your HLS playlist, specify a StartTag
// configuration object with a valid TimeOffset. When you do, you can also
// optionally specify whether to include a PRECISE value in the EXT-X-START tag.
type StartTag struct {

	// Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed
	// floating point value which, if positive, must be less than the configured
	// manifest duration minus three times the configured segment target duration. If
	// negative, the absolute value must be larger than three times the configured
	// segment target duration, and the absolute value must be smaller than the
	// configured manifest duration.
	//
	// This member is required.
	TimeOffset *float32

	// Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or
	// choose false, to use the default value NO. Choose yes to use the value YES.
	Precise *bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
