// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The action to list the replicated bots created from the source bot alias.
func (c *Client) ListBotAliasReplicas(ctx context.Context, params *ListBotAliasReplicasInput, optFns ...func(*Options)) (*ListBotAliasReplicasOutput, error) {
	if params == nil {
		params = &ListBotAliasReplicasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBotAliasReplicas", params, optFns, c.addOperationListBotAliasReplicasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBotAliasReplicasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBotAliasReplicasInput struct {

	// The request for the unique bot ID of the replicated bot created from the source
	// bot alias.
	//
	// This member is required.
	BotId *string

	// The request for the secondary region of the replicated bot created from the
	// source bot alias.
	//
	// This member is required.
	ReplicaRegion *string

	// The request for maximum results to list the replicated bots created from the
	// source bot alias.
	MaxResults *int32

	// The request for the next token for the replicated bot created from the source
	// bot alias.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBotAliasReplicasOutput struct {

	// The summary information of the replicated bot created from the source bot alias.
	BotAliasReplicaSummaries []types.BotAliasReplicaSummary

	// The unique bot ID of the replicated bot created from the source bot alias.
	BotId *string

	// The next token for the replicated bots created from the source bot alias.
	NextToken *string

	// The secondary region of the replicated bot created from the source bot alias.
	ReplicaRegion *string

	// The source region of the replicated bot created from the source bot alias.
	SourceRegion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBotAliasReplicasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListBotAliasReplicas{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListBotAliasReplicas{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBotAliasReplicas"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBotAliasReplicasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBotAliasReplicas(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListBotAliasReplicasPaginatorOptions is the paginator options for
// ListBotAliasReplicas
type ListBotAliasReplicasPaginatorOptions struct {
	// The request for maximum results to list the replicated bots created from the
	// source bot alias.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBotAliasReplicasPaginator is a paginator for ListBotAliasReplicas
type ListBotAliasReplicasPaginator struct {
	options   ListBotAliasReplicasPaginatorOptions
	client    ListBotAliasReplicasAPIClient
	params    *ListBotAliasReplicasInput
	nextToken *string
	firstPage bool
}

// NewListBotAliasReplicasPaginator returns a new ListBotAliasReplicasPaginator
func NewListBotAliasReplicasPaginator(client ListBotAliasReplicasAPIClient, params *ListBotAliasReplicasInput, optFns ...func(*ListBotAliasReplicasPaginatorOptions)) *ListBotAliasReplicasPaginator {
	if params == nil {
		params = &ListBotAliasReplicasInput{}
	}

	options := ListBotAliasReplicasPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBotAliasReplicasPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBotAliasReplicasPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBotAliasReplicas page.
func (p *ListBotAliasReplicasPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBotAliasReplicasOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBotAliasReplicas(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBotAliasReplicasAPIClient is a client that implements the
// ListBotAliasReplicas operation.
type ListBotAliasReplicasAPIClient interface {
	ListBotAliasReplicas(context.Context, *ListBotAliasReplicasInput, ...func(*Options)) (*ListBotAliasReplicasOutput, error)
}

var _ ListBotAliasReplicasAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBotAliasReplicas(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBotAliasReplicas",
	}
}
