// Code generated by smithy-go-codegen DO NOT EDIT.

package keyspacesstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/keyspacesstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns detailed information about a specific data capture stream for an Amazon
// Keyspaces table. The information includes the stream's Amazon Resource Name
// (ARN), creation time, current status, retention period, shard composition, and
// associated table details. This operation helps you monitor and manage the
// configuration of your Amazon Keyspaces data streams.
func (c *Client) GetStream(ctx context.Context, params *GetStreamInput, optFns ...func(*Options)) (*GetStreamOutput, error) {
	if params == nil {
		params = &GetStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStream", params, optFns, c.addOperationGetStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStreamInput struct {

	//  The Amazon Resource Name (ARN) of the stream for which detailed information is
	// requested. This uniquely identifies the specific stream you want to get
	// information about.
	//
	// This member is required.
	StreamArn *string

	//  The maximum number of shard objects to return in a single GetStream request.
	// Default value is 100. The minimum value is 1 and the maximum value is 100.
	MaxResults *int32

	//  An optional pagination token provided by a previous GetStream operation. If
	// this parameter is specified, the response includes only records beyond the
	// token, up to the value specified by maxResults .
	NextToken *string

	//  Optional filter criteria to apply when retrieving shards. You can filter
	// shards based on their state or other attributes to narrow down the results
	// returned by the GetStream operation.
	ShardFilter *types.ShardFilter

	noSmithyDocumentSerde
}

type GetStreamOutput struct {

	//  The date and time when the request to create this stream was issued. The value
	// is represented in ISO 8601 format.
	//
	// This member is required.
	CreationRequestDateTime *time.Time

	//  The name of the keyspace containing the table associated with this stream. The
	// keyspace name is part of the table's hierarchical identifier in Amazon
	// Keyspaces.
	//
	// This member is required.
	KeyspaceName *string

	//  The Amazon Resource Name (ARN) that uniquely identifies the stream within
	// Amazon Keyspaces. This ARN can be used in other API operations to reference this
	// specific stream.
	//
	// This member is required.
	StreamArn *string

	//  A timestamp that serves as a unique identifier for this stream, used for
	// debugging and monitoring purposes. The stream label represents the point in time
	// when the stream was created.
	//
	// This member is required.
	StreamLabel *string

	//  The current status of the stream. Values can be ENABLING , ENABLED , DISABLING
	// , or DISABLED . Operations on the stream depend on its current status.
	//
	// This member is required.
	StreamStatus types.StreamStatus

	//  The format of the data records in this stream. Currently, this can be one of
	// the following options:
	//
	//   - NEW_AND_OLD_IMAGES - both versions of the row, before and after the change.
	//   This is the default.
	//
	//   - NEW_IMAGE - the version of the row after the change.
	//
	//   - OLD_IMAGE - the version of the row before the change.
	//
	//   - KEYS_ONLY - the partition and clustering keys of the row that was changed.
	//
	// This member is required.
	StreamViewType types.StreamViewType

	//  The name of the table associated with this stream. The stream captures changes
	// to rows in this Amazon Keyspaces table.
	//
	// This member is required.
	TableName *string

	//  A pagination token that can be used in a subsequent GetStream request. This
	// token is returned if the response contains more shards than can be returned in a
	// single response.
	NextToken *string

	//  An array of shard objects associated with this stream. Each shard contains a
	// subset of the stream's data records and has its own unique identifier. The
	// collection of shards represents the complete stream data.
	Shards []types.Shard

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStream"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetStreamPaginatorOptions is the paginator options for GetStream
type GetStreamPaginatorOptions struct {
	//  The maximum number of shard objects to return in a single GetStream request.
	// Default value is 100. The minimum value is 1 and the maximum value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetStreamPaginator is a paginator for GetStream
type GetStreamPaginator struct {
	options   GetStreamPaginatorOptions
	client    GetStreamAPIClient
	params    *GetStreamInput
	nextToken *string
	firstPage bool
}

// NewGetStreamPaginator returns a new GetStreamPaginator
func NewGetStreamPaginator(client GetStreamAPIClient, params *GetStreamInput, optFns ...func(*GetStreamPaginatorOptions)) *GetStreamPaginator {
	if params == nil {
		params = &GetStreamInput{}
	}

	options := GetStreamPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetStreamPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetStreamPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetStream page.
func (p *GetStreamPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetStreamOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetStream(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetStreamAPIClient is a client that implements the GetStream operation.
type GetStreamAPIClient interface {
	GetStream(context.Context, *GetStreamInput, ...func(*Options)) (*GetStreamOutput, error)
}

var _ GetStreamAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStream",
	}
}
