// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about the specific command execution on a single device.
func (c *Client) GetCommandExecution(ctx context.Context, params *GetCommandExecutionInput, optFns ...func(*Options)) (*GetCommandExecutionOutput, error) {
	if params == nil {
		params = &GetCommandExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCommandExecution", params, optFns, c.addOperationGetCommandExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCommandExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCommandExecutionInput struct {

	// The unique identifier for the command execution. This information is returned
	// as a response of the StartCommandExecution API request.
	//
	// This member is required.
	ExecutionId *string

	// The Amazon Resource Number (ARN) of the device on which the command execution
	// is being performed.
	//
	// This member is required.
	TargetArn *string

	// Can be used to specify whether to include the result of the command execution
	// in the GetCommandExecution API response. Your device can use this field to
	// provide additional information about the command execution. You only need to
	// specify this field when using the AWS-IoT namespace.
	IncludeResult *bool

	noSmithyDocumentSerde
}

type GetCommandExecutionOutput struct {

	// The Amazon Resource Number (ARN) of the command. For example,
	// arn:aws:iot:::command/
	CommandArn *string

	// The timestamp, when the command execution was completed.
	CompletedAt *time.Time

	// The timestamp, when the command execution was created.
	CreatedAt *time.Time

	// The unique identifier of the command execution.
	ExecutionId *string

	// Specifies the amount of time in seconds that the device can take to finish a
	// command execution. A timer starts when the command execution is created. If the
	// command execution status is not set to another terminal state before the timer
	// expires, it will automatically update to TIMED_OUT .
	ExecutionTimeoutSeconds *int64

	// The timestamp, when the command execution was last updated.
	LastUpdatedAt *time.Time

	// The list of parameters that the StartCommandExecution API used when performing
	// the command on the device.
	Parameters map[string]types.CommandParameterValue

	// The result value for the current state of the command execution. The status
	// provides information about the progress of the command execution. The device can
	// use the result field to share additional details about the execution such as a
	// return value of a remote function call.
	//
	// If you use the AWS-IoT-FleetWise namespace, then this field is not applicable
	// in the API response.
	Result map[string]types.CommandExecutionResult

	// The timestamp, when the command execution was started.
	StartedAt *time.Time

	// The status of the command execution. After your devices receive the command and
	// start performing the operations specified in the command, it can use the
	// UpdateCommandExecution MQTT API to update the status information.
	Status types.CommandExecutionStatus

	// Your devices can use this parameter to provide additional context about the
	// status of a command execution using a reason code and description.
	StatusReason *types.StatusReason

	// The Amazon Resource Number (ARN) of the device on which the command execution
	// is being performed.
	TargetArn *string

	// The time to live (TTL) parameter that indicates the duration for which
	// executions will be retained in your account. The default value is six months.
	TimeToLive *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCommandExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCommandExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCommandExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCommandExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCommandExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCommandExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCommandExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCommandExecution",
	}
}
