// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The DescribeConnectionType API provides full details of the supported options
// for a given connection type in Glue.
func (c *Client) DescribeConnectionType(ctx context.Context, params *DescribeConnectionTypeInput, optFns ...func(*Options)) (*DescribeConnectionTypeOutput, error) {
	if params == nil {
		params = &DescribeConnectionTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeConnectionType", params, optFns, c.addOperationDescribeConnectionTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeConnectionTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeConnectionTypeInput struct {

	// The name of the connection type to be described.
	//
	// This member is required.
	ConnectionType *string

	noSmithyDocumentSerde
}

type DescribeConnectionTypeOutput struct {

	// Connection properties specific to the Athena compute environment.
	AthenaConnectionProperties map[string]types.Property

	// The type of authentication used for the connection.
	AuthenticationConfiguration *types.AuthConfiguration

	// The supported authentication types, data interface types (compute
	// environments), and data operations of the connector.
	Capabilities *types.Capabilities

	// The compute environments that are supported by the connection.
	ComputeEnvironmentConfigurations map[string]types.ComputeEnvironmentConfiguration

	// Returns properties that can be set when creating a connection in the
	// ConnectionInput.ConnectionProperties . ConnectionOptions defines parameters
	// that can be set in a Spark ETL script in the connection options map passed to a
	// dataframe.
	ConnectionOptions map[string]types.Property

	// Connection properties which are common across compute environments.
	ConnectionProperties map[string]types.Property

	// The name of the connection type.
	ConnectionType *string

	// A description of the connection type.
	Description *string

	// Physical requirements for a connection, such as VPC, Subnet and Security Group
	// specifications.
	PhysicalConnectionRequirements map[string]types.Property

	// Connection properties specific to the Python compute environment.
	PythonConnectionProperties map[string]types.Property

	// Connection properties specific to the Spark compute environment.
	SparkConnectionProperties map[string]types.Property

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeConnectionTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeConnectionType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeConnectionType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeConnectionType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeConnectionTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeConnectionType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeConnectionType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeConnectionType",
	}
}
