// Code generated by smithy-go-codegen DO NOT EDIT.

package glacier

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/glacier/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAbortMultipartUpload struct {
}

func (*awsRestjson1_serializeOpAbortMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAbortMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AbortMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAbortMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAbortMultipartUploadInput(v *AbortMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.UploadId == nil || len(*v.UploadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member uploadId must not be empty")}
	}
	if v.UploadId != nil {
		if err := encoder.SetURI("uploadId").String(*v.UploadId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAbortVaultLock struct {
}

func (*awsRestjson1_serializeOpAbortVaultLock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAbortVaultLock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AbortVaultLockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/lock-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAbortVaultLockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAbortVaultLockInput(v *AbortVaultLockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddTagsToVault struct {
}

func (*awsRestjson1_serializeOpAddTagsToVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddTagsToVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddTagsToVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/tags?operation=add")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddTagsToVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddTagsToVaultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddTagsToVaultInput(v *AddTagsToVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddTagsToVaultInput(v *AddTagsToVaultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCompleteMultipartUpload struct {
}

func (*awsRestjson1_serializeOpCompleteMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCompleteMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CompleteMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCompleteMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCompleteMultipartUploadInput(v *CompleteMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.ArchiveSize != nil {
		locationName := "X-Amz-Archive-Size"
		encoder.SetHeader(locationName).String(*v.ArchiveSize)
	}

	if v.Checksum != nil {
		locationName := "X-Amz-Sha256-Tree-Hash"
		encoder.SetHeader(locationName).String(*v.Checksum)
	}

	if v.UploadId == nil || len(*v.UploadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member uploadId must not be empty")}
	}
	if v.UploadId != nil {
		if err := encoder.SetURI("uploadId").String(*v.UploadId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCompleteVaultLock struct {
}

func (*awsRestjson1_serializeOpCompleteVaultLock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCompleteVaultLock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CompleteVaultLockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/lock-policy/{lockId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCompleteVaultLockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCompleteVaultLockInput(v *CompleteVaultLockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.LockId == nil || len(*v.LockId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member lockId must not be empty")}
	}
	if v.LockId != nil {
		if err := encoder.SetURI("lockId").String(*v.LockId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateVault struct {
}

func (*awsRestjson1_serializeOpCreateVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVaultInput(v *CreateVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteArchive struct {
}

func (*awsRestjson1_serializeOpDeleteArchive) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteArchive) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteArchiveInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/archives/{archiveId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteArchiveInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteArchiveInput(v *DeleteArchiveInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.ArchiveId == nil || len(*v.ArchiveId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member archiveId must not be empty")}
	}
	if v.ArchiveId != nil {
		if err := encoder.SetURI("archiveId").String(*v.ArchiveId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVault struct {
}

func (*awsRestjson1_serializeOpDeleteVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVaultInput(v *DeleteVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVaultAccessPolicy struct {
}

func (*awsRestjson1_serializeOpDeleteVaultAccessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVaultAccessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVaultAccessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/access-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVaultAccessPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVaultAccessPolicyInput(v *DeleteVaultAccessPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVaultNotifications struct {
}

func (*awsRestjson1_serializeOpDeleteVaultNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVaultNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVaultNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/notification-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVaultNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVaultNotificationsInput(v *DeleteVaultNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJob struct {
}

func (*awsRestjson1_serializeOpDescribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobInput(v *DescribeJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVault struct {
}

func (*awsRestjson1_serializeOpDescribeVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVaultInput(v *DescribeVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDataRetrievalPolicy struct {
}

func (*awsRestjson1_serializeOpGetDataRetrievalPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataRetrievalPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataRetrievalPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/policies/data-retrieval")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataRetrievalPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataRetrievalPolicyInput(v *GetDataRetrievalPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetJobOutput struct {
}

func (*awsRestjson1_serializeOpGetJobOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJobOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/jobs/{jobId}/output")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJobOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJobOutputInput(v *GetJobOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.Range != nil {
		locationName := "Range"
		encoder.SetHeader(locationName).String(*v.Range)
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVaultAccessPolicy struct {
}

func (*awsRestjson1_serializeOpGetVaultAccessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVaultAccessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVaultAccessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/access-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVaultAccessPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVaultAccessPolicyInput(v *GetVaultAccessPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVaultLock struct {
}

func (*awsRestjson1_serializeOpGetVaultLock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVaultLock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVaultLockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/lock-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVaultLockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVaultLockInput(v *GetVaultLockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVaultNotifications struct {
}

func (*awsRestjson1_serializeOpGetVaultNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVaultNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVaultNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/notification-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVaultNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVaultNotificationsInput(v *GetVaultNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpInitiateJob struct {
}

func (*awsRestjson1_serializeOpInitiateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInitiateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InitiateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInitiateJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.JobParameters != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentJobParameters(input.JobParameters, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInitiateJobInput(v *InitiateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpInitiateMultipartUpload struct {
}

func (*awsRestjson1_serializeOpInitiateMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInitiateMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InitiateMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/multipart-uploads")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInitiateMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInitiateMultipartUploadInput(v *InitiateMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.ArchiveDescription != nil {
		locationName := "X-Amz-Archive-Description"
		encoder.SetHeader(locationName).String(*v.ArchiveDescription)
	}

	if v.PartSize != nil {
		locationName := "X-Amz-Part-Size"
		encoder.SetHeader(locationName).String(*v.PartSize)
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpInitiateVaultLock struct {
}

func (*awsRestjson1_serializeOpInitiateVaultLock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInitiateVaultLock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InitiateVaultLockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/lock-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInitiateVaultLockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.Policy != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentVaultLockPolicy(input.Policy, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInitiateVaultLockInput(v *InitiateVaultLockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobs struct {
}

func (*awsRestjson1_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsInput(v *ListJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.Completed != nil {
		encoder.SetQuery("completed").String(*v.Completed)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.Statuscode != nil {
		encoder.SetQuery("statuscode").String(*v.Statuscode)
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListMultipartUploads struct {
}

func (*awsRestjson1_serializeOpListMultipartUploads) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMultipartUploads) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMultipartUploadsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/multipart-uploads")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMultipartUploadsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMultipartUploadsInput(v *ListMultipartUploadsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListParts struct {
}

func (*awsRestjson1_serializeOpListParts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListParts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPartsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPartsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPartsInput(v *ListPartsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.UploadId == nil || len(*v.UploadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member uploadId must not be empty")}
	}
	if v.UploadId != nil {
		if err := encoder.SetURI("uploadId").String(*v.UploadId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListProvisionedCapacity struct {
}

func (*awsRestjson1_serializeOpListProvisionedCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProvisionedCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProvisionedCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/provisioned-capacity")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProvisionedCapacityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProvisionedCapacityInput(v *ListProvisionedCapacityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForVault struct {
}

func (*awsRestjson1_serializeOpListTagsForVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForVaultInput(v *ListTagsForVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListVaults struct {
}

func (*awsRestjson1_serializeOpListVaults) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVaults) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVaultsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVaultsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVaultsInput(v *ListVaultsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	return nil
}

type awsRestjson1_serializeOpPurchaseProvisionedCapacity struct {
}

func (*awsRestjson1_serializeOpPurchaseProvisionedCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPurchaseProvisionedCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseProvisionedCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/provisioned-capacity")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPurchaseProvisionedCapacityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPurchaseProvisionedCapacityInput(v *PurchaseProvisionedCapacityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveTagsFromVault struct {
}

func (*awsRestjson1_serializeOpRemoveTagsFromVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveTagsFromVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveTagsFromVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/tags?operation=remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveTagsFromVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRemoveTagsFromVaultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveTagsFromVaultInput(v *RemoveTagsFromVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRemoveTagsFromVaultInput(v *RemoveTagsFromVaultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSetDataRetrievalPolicy struct {
}

func (*awsRestjson1_serializeOpSetDataRetrievalPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetDataRetrievalPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetDataRetrievalPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/policies/data-retrieval")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetDataRetrievalPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetDataRetrievalPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetDataRetrievalPolicyInput(v *SetDataRetrievalPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetDataRetrievalPolicyInput(v *SetDataRetrievalPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		if err := awsRestjson1_serializeDocumentDataRetrievalPolicy(v.Policy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSetVaultAccessPolicy struct {
}

func (*awsRestjson1_serializeOpSetVaultAccessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetVaultAccessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetVaultAccessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/access-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetVaultAccessPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.Policy != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentVaultAccessPolicy(input.Policy, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetVaultAccessPolicyInput(v *SetVaultAccessPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSetVaultNotifications struct {
}

func (*awsRestjson1_serializeOpSetVaultNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetVaultNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetVaultNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/notification-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetVaultNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.VaultNotificationConfig != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentVaultNotificationConfig(input.VaultNotificationConfig, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetVaultNotificationsInput(v *SetVaultNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUploadArchive struct {
}

func (*awsRestjson1_serializeOpUploadArchive) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUploadArchive) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadArchiveInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/archives")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUploadArchiveInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := input.Body
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUploadArchiveInput(v *UploadArchiveInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.ArchiveDescription != nil {
		locationName := "X-Amz-Archive-Description"
		encoder.SetHeader(locationName).String(*v.ArchiveDescription)
	}

	if v.Checksum != nil {
		locationName := "X-Amz-Sha256-Tree-Hash"
		encoder.SetHeader(locationName).String(*v.Checksum)
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUploadMultipartPart struct {
}

func (*awsRestjson1_serializeOpUploadMultipartPart) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUploadMultipartPart) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadMultipartPartInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUploadMultipartPartInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := input.Body
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUploadMultipartPartInput(v *UploadMultipartPartInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId == nil || len(*v.AccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member accountId must not be empty")}
	}
	if v.AccountId != nil {
		if err := encoder.SetURI("accountId").String(*v.AccountId); err != nil {
			return err
		}
	}

	if v.Checksum != nil {
		locationName := "X-Amz-Sha256-Tree-Hash"
		encoder.SetHeader(locationName).String(*v.Checksum)
	}

	if v.Range != nil {
		locationName := "Content-Range"
		encoder.SetHeader(locationName).String(*v.Range)
	}

	if v.UploadId == nil || len(*v.UploadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member uploadId must not be empty")}
	}
	if v.UploadId != nil {
		if err := encoder.SetURI("uploadId").String(*v.UploadId); err != nil {
			return err
		}
	}

	if v.VaultName == nil || len(*v.VaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member vaultName must not be empty")}
	}
	if v.VaultName != nil {
		if err := encoder.SetURI("vaultName").String(*v.VaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessControlPolicyList(v []types.Grant, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGrant(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCSVInput(v *types.CSVInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comments != nil {
		ok := object.Key("Comments")
		ok.String(*v.Comments)
	}

	if v.FieldDelimiter != nil {
		ok := object.Key("FieldDelimiter")
		ok.String(*v.FieldDelimiter)
	}

	if len(v.FileHeaderInfo) > 0 {
		ok := object.Key("FileHeaderInfo")
		ok.String(string(v.FileHeaderInfo))
	}

	if v.QuoteCharacter != nil {
		ok := object.Key("QuoteCharacter")
		ok.String(*v.QuoteCharacter)
	}

	if v.QuoteEscapeCharacter != nil {
		ok := object.Key("QuoteEscapeCharacter")
		ok.String(*v.QuoteEscapeCharacter)
	}

	if v.RecordDelimiter != nil {
		ok := object.Key("RecordDelimiter")
		ok.String(*v.RecordDelimiter)
	}

	return nil
}

func awsRestjson1_serializeDocumentCSVOutput(v *types.CSVOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldDelimiter != nil {
		ok := object.Key("FieldDelimiter")
		ok.String(*v.FieldDelimiter)
	}

	if v.QuoteCharacter != nil {
		ok := object.Key("QuoteCharacter")
		ok.String(*v.QuoteCharacter)
	}

	if v.QuoteEscapeCharacter != nil {
		ok := object.Key("QuoteEscapeCharacter")
		ok.String(*v.QuoteEscapeCharacter)
	}

	if len(v.QuoteFields) > 0 {
		ok := object.Key("QuoteFields")
		ok.String(string(v.QuoteFields))
	}

	if v.RecordDelimiter != nil {
		ok := object.Key("RecordDelimiter")
		ok.String(*v.RecordDelimiter)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataRetrievalPolicy(v *types.DataRetrievalPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentDataRetrievalRulesList(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataRetrievalRule(v *types.DataRetrievalRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BytesPerHour != nil {
		ok := object.Key("BytesPerHour")
		ok.Long(*v.BytesPerHour)
	}

	if v.Strategy != nil {
		ok := object.Key("Strategy")
		ok.String(*v.Strategy)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataRetrievalRulesList(v []types.DataRetrievalRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataRetrievalRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEncryption(v *types.Encryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncryptionType) > 0 {
		ok := object.Key("EncryptionType")
		ok.String(string(v.EncryptionType))
	}

	if v.KMSContext != nil {
		ok := object.Key("KMSContext")
		ok.String(*v.KMSContext)
	}

	if v.KMSKeyId != nil {
		ok := object.Key("KMSKeyId")
		ok.String(*v.KMSKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrant(v *types.Grant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Grantee != nil {
		ok := object.Key("Grantee")
		if err := awsRestjson1_serializeDocumentGrantee(v.Grantee, ok); err != nil {
			return err
		}
	}

	if len(v.Permission) > 0 {
		ok := object.Key("Permission")
		ok.String(string(v.Permission))
	}

	return nil
}

func awsRestjson1_serializeDocumentGrantee(v *types.Grantee, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("DisplayName")
		ok.String(*v.DisplayName)
	}

	if v.EmailAddress != nil {
		ok := object.Key("EmailAddress")
		ok.String(*v.EmailAddress)
	}

	if v.ID != nil {
		ok := object.Key("ID")
		ok.String(*v.ID)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.URI != nil {
		ok := object.Key("URI")
		ok.String(*v.URI)
	}

	return nil
}

func awsRestjson1_serializeDocumentHashmap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentInputSerialization(v *types.InputSerialization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Csv != nil {
		ok := object.Key("csv")
		if err := awsRestjson1_serializeDocumentCSVInput(v.Csv, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInventoryRetrievalJobInput(v *types.InventoryRetrievalJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndDate != nil {
		ok := object.Key("EndDate")
		ok.String(*v.EndDate)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.String(*v.Limit)
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	if v.StartDate != nil {
		ok := object.Key("StartDate")
		ok.String(*v.StartDate)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobParameters(v *types.JobParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArchiveId != nil {
		ok := object.Key("ArchiveId")
		ok.String(*v.ArchiveId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if v.InventoryRetrievalParameters != nil {
		ok := object.Key("InventoryRetrievalParameters")
		if err := awsRestjson1_serializeDocumentInventoryRetrievalJobInput(v.InventoryRetrievalParameters, ok); err != nil {
			return err
		}
	}

	if v.OutputLocation != nil {
		ok := object.Key("OutputLocation")
		if err := awsRestjson1_serializeDocumentOutputLocation(v.OutputLocation, ok); err != nil {
			return err
		}
	}

	if v.RetrievalByteRange != nil {
		ok := object.Key("RetrievalByteRange")
		ok.String(*v.RetrievalByteRange)
	}

	if v.SelectParameters != nil {
		ok := object.Key("SelectParameters")
		if err := awsRestjson1_serializeDocumentSelectParameters(v.SelectParameters, ok); err != nil {
			return err
		}
	}

	if v.SNSTopic != nil {
		ok := object.Key("SNSTopic")
		ok.String(*v.SNSTopic)
	}

	if v.Tier != nil {
		ok := object.Key("Tier")
		ok.String(*v.Tier)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentNotificationEventList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOutputLocation(v *types.OutputLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsRestjson1_serializeDocumentS3Location(v.S3, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputSerialization(v *types.OutputSerialization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Csv != nil {
		ok := object.Key("csv")
		if err := awsRestjson1_serializeDocumentCSVOutput(v.Csv, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Location(v *types.S3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessControlList != nil {
		ok := object.Key("AccessControlList")
		if err := awsRestjson1_serializeDocumentAccessControlPolicyList(v.AccessControlList, ok); err != nil {
			return err
		}
	}

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if len(v.CannedACL) > 0 {
		ok := object.Key("CannedACL")
		ok.String(string(v.CannedACL))
	}

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if len(v.StorageClass) > 0 {
		ok := object.Key("StorageClass")
		ok.String(string(v.StorageClass))
	}

	if v.Tagging != nil {
		ok := object.Key("Tagging")
		if err := awsRestjson1_serializeDocumentHashmap(v.Tagging, ok); err != nil {
			return err
		}
	}

	if v.UserMetadata != nil {
		ok := object.Key("UserMetadata")
		if err := awsRestjson1_serializeDocumentHashmap(v.UserMetadata, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSelectParameters(v *types.SelectParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if len(v.ExpressionType) > 0 {
		ok := object.Key("ExpressionType")
		ok.String(string(v.ExpressionType))
	}

	if v.InputSerialization != nil {
		ok := object.Key("InputSerialization")
		if err := awsRestjson1_serializeDocumentInputSerialization(v.InputSerialization, ok); err != nil {
			return err
		}
	}

	if v.OutputSerialization != nil {
		ok := object.Key("OutputSerialization")
		if err := awsRestjson1_serializeDocumentOutputSerialization(v.OutputSerialization, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentVaultAccessPolicy(v *types.VaultAccessPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	return nil
}

func awsRestjson1_serializeDocumentVaultLockPolicy(v *types.VaultLockPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	return nil
}

func awsRestjson1_serializeDocumentVaultNotificationConfig(v *types.VaultNotificationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("Events")
		if err := awsRestjson1_serializeDocumentNotificationEventList(v.Events, ok); err != nil {
			return err
		}
	}

	if v.SNSTopic != nil {
		ok := object.Key("SNSTopic")
		ok.String(*v.SNSTopic)
	}

	return nil
}
