// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCalculateIsolines struct {
}

func (*awsRestjson1_serializeOpCalculateIsolines) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCalculateIsolines) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CalculateIsolinesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/isolines")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCalculateIsolinesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCalculateIsolinesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCalculateIsolinesInput(v *CalculateIsolinesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCalculateIsolinesInput(v *CalculateIsolinesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Allow != nil {
		ok := object.Key("Allow")
		if err := awsRestjson1_serializeDocumentIsolineAllowOptions(v.Allow, ok); err != nil {
			return err
		}
	}

	if v.ArrivalTime != nil {
		ok := object.Key("ArrivalTime")
		ok.String(*v.ArrivalTime)
	}

	if v.Avoid != nil {
		ok := object.Key("Avoid")
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceOptions(v.Avoid, ok); err != nil {
			return err
		}
	}

	if v.DepartNow != nil {
		ok := object.Key("DepartNow")
		ok.Boolean(*v.DepartNow)
	}

	if v.DepartureTime != nil {
		ok := object.Key("DepartureTime")
		ok.String(*v.DepartureTime)
	}

	if v.Destination != nil {
		ok := object.Key("Destination")
		if err := awsRestjson1_serializeDocumentPosition(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.DestinationOptions != nil {
		ok := object.Key("DestinationOptions")
		if err := awsRestjson1_serializeDocumentIsolineDestinationOptions(v.DestinationOptions, ok); err != nil {
			return err
		}
	}

	if len(v.IsolineGeometryFormat) > 0 {
		ok := object.Key("IsolineGeometryFormat")
		ok.String(string(v.IsolineGeometryFormat))
	}

	if v.IsolineGranularity != nil {
		ok := object.Key("IsolineGranularity")
		if err := awsRestjson1_serializeDocumentIsolineGranularityOptions(v.IsolineGranularity, ok); err != nil {
			return err
		}
	}

	if len(v.OptimizeIsolineFor) > 0 {
		ok := object.Key("OptimizeIsolineFor")
		ok.String(string(v.OptimizeIsolineFor))
	}

	if len(v.OptimizeRoutingFor) > 0 {
		ok := object.Key("OptimizeRoutingFor")
		ok.String(string(v.OptimizeRoutingFor))
	}

	if v.Origin != nil {
		ok := object.Key("Origin")
		if err := awsRestjson1_serializeDocumentPosition(v.Origin, ok); err != nil {
			return err
		}
	}

	if v.OriginOptions != nil {
		ok := object.Key("OriginOptions")
		if err := awsRestjson1_serializeDocumentIsolineOriginOptions(v.OriginOptions, ok); err != nil {
			return err
		}
	}

	if v.Thresholds != nil {
		ok := object.Key("Thresholds")
		if err := awsRestjson1_serializeDocumentIsolineThresholds(v.Thresholds, ok); err != nil {
			return err
		}
	}

	if v.Traffic != nil {
		ok := object.Key("Traffic")
		if err := awsRestjson1_serializeDocumentIsolineTrafficOptions(v.Traffic, ok); err != nil {
			return err
		}
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TravelModeOptions != nil {
		ok := object.Key("TravelModeOptions")
		if err := awsRestjson1_serializeDocumentIsolineTravelModeOptions(v.TravelModeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCalculateRouteMatrix struct {
}

func (*awsRestjson1_serializeOpCalculateRouteMatrix) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCalculateRouteMatrix) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CalculateRouteMatrixInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/route-matrix")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCalculateRouteMatrixInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCalculateRouteMatrixInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCalculateRouteMatrixInput(v *CalculateRouteMatrixInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCalculateRouteMatrixInput(v *CalculateRouteMatrixInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Allow != nil {
		ok := object.Key("Allow")
		if err := awsRestjson1_serializeDocumentRouteMatrixAllowOptions(v.Allow, ok); err != nil {
			return err
		}
	}

	if v.Avoid != nil {
		ok := object.Key("Avoid")
		if err := awsRestjson1_serializeDocumentRouteMatrixAvoidanceOptions(v.Avoid, ok); err != nil {
			return err
		}
	}

	if v.DepartNow != nil {
		ok := object.Key("DepartNow")
		ok.Boolean(*v.DepartNow)
	}

	if v.DepartureTime != nil {
		ok := object.Key("DepartureTime")
		ok.String(*v.DepartureTime)
	}

	if v.Destinations != nil {
		ok := object.Key("Destinations")
		if err := awsRestjson1_serializeDocumentRouteMatrixDestinationList(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.Exclude != nil {
		ok := object.Key("Exclude")
		if err := awsRestjson1_serializeDocumentRouteMatrixExclusionOptions(v.Exclude, ok); err != nil {
			return err
		}
	}

	if len(v.OptimizeRoutingFor) > 0 {
		ok := object.Key("OptimizeRoutingFor")
		ok.String(string(v.OptimizeRoutingFor))
	}

	if v.Origins != nil {
		ok := object.Key("Origins")
		if err := awsRestjson1_serializeDocumentRouteMatrixOriginList(v.Origins, ok); err != nil {
			return err
		}
	}

	if v.RoutingBoundary != nil {
		ok := object.Key("RoutingBoundary")
		if err := awsRestjson1_serializeDocumentRouteMatrixBoundary(v.RoutingBoundary, ok); err != nil {
			return err
		}
	}

	if v.Traffic != nil {
		ok := object.Key("Traffic")
		if err := awsRestjson1_serializeDocumentRouteMatrixTrafficOptions(v.Traffic, ok); err != nil {
			return err
		}
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TravelModeOptions != nil {
		ok := object.Key("TravelModeOptions")
		if err := awsRestjson1_serializeDocumentRouteMatrixTravelModeOptions(v.TravelModeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCalculateRoutes struct {
}

func (*awsRestjson1_serializeOpCalculateRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCalculateRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CalculateRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCalculateRoutesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCalculateRoutesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCalculateRoutesInput(v *CalculateRoutesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCalculateRoutesInput(v *CalculateRoutesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Allow != nil {
		ok := object.Key("Allow")
		if err := awsRestjson1_serializeDocumentRouteAllowOptions(v.Allow, ok); err != nil {
			return err
		}
	}

	if v.ArrivalTime != nil {
		ok := object.Key("ArrivalTime")
		ok.String(*v.ArrivalTime)
	}

	if v.Avoid != nil {
		ok := object.Key("Avoid")
		if err := awsRestjson1_serializeDocumentRouteAvoidanceOptions(v.Avoid, ok); err != nil {
			return err
		}
	}

	if v.DepartNow != nil {
		ok := object.Key("DepartNow")
		ok.Boolean(*v.DepartNow)
	}

	if v.DepartureTime != nil {
		ok := object.Key("DepartureTime")
		ok.String(*v.DepartureTime)
	}

	if v.Destination != nil {
		ok := object.Key("Destination")
		if err := awsRestjson1_serializeDocumentPosition(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.DestinationOptions != nil {
		ok := object.Key("DestinationOptions")
		if err := awsRestjson1_serializeDocumentRouteDestinationOptions(v.DestinationOptions, ok); err != nil {
			return err
		}
	}

	if v.Driver != nil {
		ok := object.Key("Driver")
		if err := awsRestjson1_serializeDocumentRouteDriverOptions(v.Driver, ok); err != nil {
			return err
		}
	}

	if v.Exclude != nil {
		ok := object.Key("Exclude")
		if err := awsRestjson1_serializeDocumentRouteExclusionOptions(v.Exclude, ok); err != nil {
			return err
		}
	}

	if len(v.InstructionsMeasurementSystem) > 0 {
		ok := object.Key("InstructionsMeasurementSystem")
		ok.String(string(v.InstructionsMeasurementSystem))
	}

	if v.Languages != nil {
		ok := object.Key("Languages")
		if err := awsRestjson1_serializeDocumentLanguageTagList(v.Languages, ok); err != nil {
			return err
		}
	}

	if v.LegAdditionalFeatures != nil {
		ok := object.Key("LegAdditionalFeatures")
		if err := awsRestjson1_serializeDocumentRouteLegAdditionalFeatureList(v.LegAdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if len(v.LegGeometryFormat) > 0 {
		ok := object.Key("LegGeometryFormat")
		ok.String(string(v.LegGeometryFormat))
	}

	if v.MaxAlternatives != nil {
		ok := object.Key("MaxAlternatives")
		ok.Integer(*v.MaxAlternatives)
	}

	if len(v.OptimizeRoutingFor) > 0 {
		ok := object.Key("OptimizeRoutingFor")
		ok.String(string(v.OptimizeRoutingFor))
	}

	if v.Origin != nil {
		ok := object.Key("Origin")
		if err := awsRestjson1_serializeDocumentPosition(v.Origin, ok); err != nil {
			return err
		}
	}

	if v.OriginOptions != nil {
		ok := object.Key("OriginOptions")
		if err := awsRestjson1_serializeDocumentRouteOriginOptions(v.OriginOptions, ok); err != nil {
			return err
		}
	}

	if v.SpanAdditionalFeatures != nil {
		ok := object.Key("SpanAdditionalFeatures")
		if err := awsRestjson1_serializeDocumentRouteSpanAdditionalFeatureList(v.SpanAdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.Tolls != nil {
		ok := object.Key("Tolls")
		if err := awsRestjson1_serializeDocumentRouteTollOptions(v.Tolls, ok); err != nil {
			return err
		}
	}

	if v.Traffic != nil {
		ok := object.Key("Traffic")
		if err := awsRestjson1_serializeDocumentRouteTrafficOptions(v.Traffic, ok); err != nil {
			return err
		}
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TravelModeOptions != nil {
		ok := object.Key("TravelModeOptions")
		if err := awsRestjson1_serializeDocumentRouteTravelModeOptions(v.TravelModeOptions, ok); err != nil {
			return err
		}
	}

	if len(v.TravelStepType) > 0 {
		ok := object.Key("TravelStepType")
		ok.String(string(v.TravelStepType))
	}

	if v.Waypoints != nil {
		ok := object.Key("Waypoints")
		if err := awsRestjson1_serializeDocumentRouteWaypointList(v.Waypoints, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpOptimizeWaypoints struct {
}

func (*awsRestjson1_serializeOpOptimizeWaypoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpOptimizeWaypoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*OptimizeWaypointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/optimize-waypoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsOptimizeWaypointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentOptimizeWaypointsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsOptimizeWaypointsInput(v *OptimizeWaypointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentOptimizeWaypointsInput(v *OptimizeWaypointsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Avoid != nil {
		ok := object.Key("Avoid")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceOptions(v.Avoid, ok); err != nil {
			return err
		}
	}

	if v.Clustering != nil {
		ok := object.Key("Clustering")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationClusteringOptions(v.Clustering, ok); err != nil {
			return err
		}
	}

	if v.DepartureTime != nil {
		ok := object.Key("DepartureTime")
		ok.String(*v.DepartureTime)
	}

	if v.Destination != nil {
		ok := object.Key("Destination")
		if err := awsRestjson1_serializeDocumentPosition(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.DestinationOptions != nil {
		ok := object.Key("DestinationOptions")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationDestinationOptions(v.DestinationOptions, ok); err != nil {
			return err
		}
	}

	if v.Driver != nil {
		ok := object.Key("Driver")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationDriverOptions(v.Driver, ok); err != nil {
			return err
		}
	}

	if v.Exclude != nil {
		ok := object.Key("Exclude")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationExclusionOptions(v.Exclude, ok); err != nil {
			return err
		}
	}

	if len(v.OptimizeSequencingFor) > 0 {
		ok := object.Key("OptimizeSequencingFor")
		ok.String(string(v.OptimizeSequencingFor))
	}

	if v.Origin != nil {
		ok := object.Key("Origin")
		if err := awsRestjson1_serializeDocumentPosition(v.Origin, ok); err != nil {
			return err
		}
	}

	if v.OriginOptions != nil {
		ok := object.Key("OriginOptions")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationOriginOptions(v.OriginOptions, ok); err != nil {
			return err
		}
	}

	if v.Traffic != nil {
		ok := object.Key("Traffic")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationTrafficOptions(v.Traffic, ok); err != nil {
			return err
		}
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TravelModeOptions != nil {
		ok := object.Key("TravelModeOptions")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationTravelModeOptions(v.TravelModeOptions, ok); err != nil {
			return err
		}
	}

	if v.Waypoints != nil {
		ok := object.Key("Waypoints")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationWaypointList(v.Waypoints, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSnapToRoads struct {
}

func (*awsRestjson1_serializeOpSnapToRoads) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSnapToRoads) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SnapToRoadsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/snap-to-roads")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSnapToRoadsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSnapToRoadsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSnapToRoadsInput(v *SnapToRoadsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSnapToRoadsInput(v *SnapToRoadsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SnappedGeometryFormat) > 0 {
		ok := object.Key("SnappedGeometryFormat")
		ok.String(string(v.SnappedGeometryFormat))
	}

	if v.SnapRadius != 0 {
		ok := object.Key("SnapRadius")
		ok.Long(v.SnapRadius)
	}

	if v.TracePoints != nil {
		ok := object.Key("TracePoints")
		if err := awsRestjson1_serializeDocumentRoadSnapTracePointList(v.TracePoints, ok); err != nil {
			return err
		}
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TravelModeOptions != nil {
		ok := object.Key("TravelModeOptions")
		if err := awsRestjson1_serializeDocumentRoadSnapTravelModeOptions(v.TravelModeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBeforeWaypointsList(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentBoundingBox(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCircle(v *types.Circle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Center != nil {
		ok := object.Key("Center")
		if err := awsRestjson1_serializeDocumentPosition(v.Center, ok); err != nil {
			return err
		}
	}

	if v.Radius != nil {
		ok := object.Key("Radius")
		switch {
		case math.IsNaN(*v.Radius):
			ok.String("NaN")

		case math.IsInf(*v.Radius, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Radius, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Radius)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCorridor(v *types.Corridor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LineString != nil {
		ok := object.Key("LineString")
		if err := awsRestjson1_serializeDocumentLineString(v.LineString, ok); err != nil {
			return err
		}
	}

	if v.Radius != nil {
		ok := object.Key("Radius")
		ok.Integer(*v.Radius)
	}

	return nil
}

func awsRestjson1_serializeDocumentCountryCodeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDistanceThresholdList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIsolineAllowOptions(v *types.IsolineAllowOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hot != nil {
		ok := object.Key("Hot")
		ok.Boolean(*v.Hot)
	}

	if v.Hov != nil {
		ok := object.Key("Hov")
		ok.Boolean(*v.Hov)
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceArea(v *types.IsolineAvoidanceArea, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Except != nil {
		ok := object.Key("Except")
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceAreaGeometryList(v.Except, ok); err != nil {
			return err
		}
	}

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceAreaGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceAreaGeometry(v *types.IsolineAvoidanceAreaGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Corridor != nil {
		ok := object.Key("Corridor")
		if err := awsRestjson1_serializeDocumentCorridor(v.Corridor, ok); err != nil {
			return err
		}
	}

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Polygon, ok); err != nil {
			return err
		}
	}

	if v.PolylineCorridor != nil {
		ok := object.Key("PolylineCorridor")
		if err := awsRestjson1_serializeDocumentPolylineCorridor(v.PolylineCorridor, ok); err != nil {
			return err
		}
	}

	if v.PolylinePolygon != nil {
		ok := object.Key("PolylinePolygon")
		if err := awsRestjson1_serializeDocumentPolylineRingList(v.PolylinePolygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceAreaGeometryList(v []types.IsolineAvoidanceAreaGeometry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceAreaGeometry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceAreaList(v []types.IsolineAvoidanceArea, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceArea(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceOptions(v *types.IsolineAvoidanceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Areas != nil {
		ok := object.Key("Areas")
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceAreaList(v.Areas, ok); err != nil {
			return err
		}
	}

	if v.CarShuttleTrains != nil {
		ok := object.Key("CarShuttleTrains")
		ok.Boolean(*v.CarShuttleTrains)
	}

	if v.ControlledAccessHighways != nil {
		ok := object.Key("ControlledAccessHighways")
		ok.Boolean(*v.ControlledAccessHighways)
	}

	if v.DirtRoads != nil {
		ok := object.Key("DirtRoads")
		ok.Boolean(*v.DirtRoads)
	}

	if v.Ferries != nil {
		ok := object.Key("Ferries")
		ok.Boolean(*v.Ferries)
	}

	if v.SeasonalClosure != nil {
		ok := object.Key("SeasonalClosure")
		ok.Boolean(*v.SeasonalClosure)
	}

	if v.TollRoads != nil {
		ok := object.Key("TollRoads")
		ok.Boolean(*v.TollRoads)
	}

	if v.TollTransponders != nil {
		ok := object.Key("TollTransponders")
		ok.Boolean(*v.TollTransponders)
	}

	if v.TruckRoadTypes != nil {
		ok := object.Key("TruckRoadTypes")
		if err := awsRestjson1_serializeDocumentTruckRoadTypeList(v.TruckRoadTypes, ok); err != nil {
			return err
		}
	}

	if v.Tunnels != nil {
		ok := object.Key("Tunnels")
		ok.Boolean(*v.Tunnels)
	}

	if v.UTurns != nil {
		ok := object.Key("UTurns")
		ok.Boolean(*v.UTurns)
	}

	if v.ZoneCategories != nil {
		ok := object.Key("ZoneCategories")
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceZoneCategoryList(v.ZoneCategories, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceZoneCategory(v *types.IsolineAvoidanceZoneCategory, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("Category")
		ok.String(string(v.Category))
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineAvoidanceZoneCategoryList(v []types.IsolineAvoidanceZoneCategory, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIsolineAvoidanceZoneCategory(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIsolineCarOptions(v *types.IsolineCarOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EngineType) > 0 {
		ok := object.Key("EngineType")
		ok.String(string(v.EngineType))
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentIsolineVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineDestinationOptions(v *types.IsolineDestinationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentIsolineMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentIsolineSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineGranularityOptions(v *types.IsolineGranularityOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxPoints != nil {
		ok := object.Key("MaxPoints")
		ok.Integer(*v.MaxPoints)
	}

	if v.MaxResolution != 0 {
		ok := object.Key("MaxResolution")
		ok.Long(v.MaxResolution)
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineHazardousCargoTypeList(v []types.IsolineHazardousCargoType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentIsolineMatchingOptions(v *types.IsolineMatchingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NameHint != nil {
		ok := object.Key("NameHint")
		ok.String(*v.NameHint)
	}

	if v.OnRoadThreshold != 0 {
		ok := object.Key("OnRoadThreshold")
		ok.Long(v.OnRoadThreshold)
	}

	if v.Radius != 0 {
		ok := object.Key("Radius")
		ok.Long(v.Radius)
	}

	if len(v.Strategy) > 0 {
		ok := object.Key("Strategy")
		ok.String(string(v.Strategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineOriginOptions(v *types.IsolineOriginOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentIsolineMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentIsolineSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineScooterOptions(v *types.IsolineScooterOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EngineType) > 0 {
		ok := object.Key("EngineType")
		ok.String(string(v.EngineType))
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentIsolineVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineSideOfStreetOptions(v *types.IsolineSideOfStreetOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if len(v.UseWith) > 0 {
		ok := object.Key("UseWith")
		ok.String(string(v.UseWith))
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineThresholds(v *types.IsolineThresholds, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Distance != nil {
		ok := object.Key("Distance")
		if err := awsRestjson1_serializeDocumentDistanceThresholdList(v.Distance, ok); err != nil {
			return err
		}
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentTimeThresholdList(v.Time, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineTrafficOptions(v *types.IsolineTrafficOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowEventThresholdOverride != 0 {
		ok := object.Key("FlowEventThresholdOverride")
		ok.Long(v.FlowEventThresholdOverride)
	}

	if len(v.Usage) > 0 {
		ok := object.Key("Usage")
		ok.String(string(v.Usage))
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineTrailerOptions(v *types.IsolineTrailerOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxleCount != nil {
		ok := object.Key("AxleCount")
		ok.Integer(*v.AxleCount)
	}

	if v.TrailerCount != nil {
		ok := object.Key("TrailerCount")
		ok.Integer(*v.TrailerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineTravelModeOptions(v *types.IsolineTravelModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Car != nil {
		ok := object.Key("Car")
		if err := awsRestjson1_serializeDocumentIsolineCarOptions(v.Car, ok); err != nil {
			return err
		}
	}

	if v.Scooter != nil {
		ok := object.Key("Scooter")
		if err := awsRestjson1_serializeDocumentIsolineScooterOptions(v.Scooter, ok); err != nil {
			return err
		}
	}

	if v.Truck != nil {
		ok := object.Key("Truck")
		if err := awsRestjson1_serializeDocumentIsolineTruckOptions(v.Truck, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineTruckOptions(v *types.IsolineTruckOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxleCount != nil {
		ok := object.Key("AxleCount")
		ok.Integer(*v.AxleCount)
	}

	if len(v.EngineType) > 0 {
		ok := object.Key("EngineType")
		ok.String(string(v.EngineType))
	}

	if v.GrossWeight != 0 {
		ok := object.Key("GrossWeight")
		ok.Long(v.GrossWeight)
	}

	if v.HazardousCargos != nil {
		ok := object.Key("HazardousCargos")
		if err := awsRestjson1_serializeDocumentIsolineHazardousCargoTypeList(v.HazardousCargos, ok); err != nil {
			return err
		}
	}

	if v.Height != 0 {
		ok := object.Key("Height")
		ok.Long(v.Height)
	}

	if v.HeightAboveFirstAxle != 0 {
		ok := object.Key("HeightAboveFirstAxle")
		ok.Long(v.HeightAboveFirstAxle)
	}

	if v.KpraLength != 0 {
		ok := object.Key("KpraLength")
		ok.Long(v.KpraLength)
	}

	if v.Length != 0 {
		ok := object.Key("Length")
		ok.Long(v.Length)
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentIsolineVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	if v.PayloadCapacity != 0 {
		ok := object.Key("PayloadCapacity")
		ok.Long(v.PayloadCapacity)
	}

	if v.TireCount != nil {
		ok := object.Key("TireCount")
		ok.Integer(*v.TireCount)
	}

	if v.Trailer != nil {
		ok := object.Key("Trailer")
		if err := awsRestjson1_serializeDocumentIsolineTrailerOptions(v.Trailer, ok); err != nil {
			return err
		}
	}

	if len(v.TruckType) > 0 {
		ok := object.Key("TruckType")
		ok.String(string(v.TruckType))
	}

	if v.TunnelRestrictionCode != nil {
		ok := object.Key("TunnelRestrictionCode")
		ok.String(*v.TunnelRestrictionCode)
	}

	if v.WeightPerAxle != 0 {
		ok := object.Key("WeightPerAxle")
		ok.Long(v.WeightPerAxle)
	}

	if v.WeightPerAxleGroup != nil {
		ok := object.Key("WeightPerAxleGroup")
		if err := awsRestjson1_serializeDocumentWeightPerAxleGroup(v.WeightPerAxleGroup, ok); err != nil {
			return err
		}
	}

	if v.Width != 0 {
		ok := object.Key("Width")
		ok.Long(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentIsolineVehicleLicensePlate(v *types.IsolineVehicleLicensePlate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LastCharacter != nil {
		ok := object.Key("LastCharacter")
		ok.String(*v.LastCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentLanguageTagList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLinearRing(v [][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPosition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLinearRings(v [][][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentLinearRing(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLineString(v [][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPosition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPolylineCorridor(v *types.PolylineCorridor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Polyline != nil {
		ok := object.Key("Polyline")
		ok.String(*v.Polyline)
	}

	if v.Radius != nil {
		ok := object.Key("Radius")
		ok.Integer(*v.Radius)
	}

	return nil
}

func awsRestjson1_serializeDocumentPolylineRingList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPosition(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRoadSnapHazardousCargoTypeList(v []types.RoadSnapHazardousCargoType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRoadSnapTracePoint(v *types.RoadSnapTracePoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.Speed != 0 {
		ok := object.Key("Speed")
		switch {
		case math.IsNaN(v.Speed):
			ok.String("NaN")

		case math.IsInf(v.Speed, 1):
			ok.String("Infinity")

		case math.IsInf(v.Speed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Speed)

		}
	}

	if v.Timestamp != nil {
		ok := object.Key("Timestamp")
		ok.String(*v.Timestamp)
	}

	return nil
}

func awsRestjson1_serializeDocumentRoadSnapTracePointList(v []types.RoadSnapTracePoint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRoadSnapTracePoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRoadSnapTrailerOptions(v *types.RoadSnapTrailerOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TrailerCount != nil {
		ok := object.Key("TrailerCount")
		ok.Integer(*v.TrailerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentRoadSnapTravelModeOptions(v *types.RoadSnapTravelModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Truck != nil {
		ok := object.Key("Truck")
		if err := awsRestjson1_serializeDocumentRoadSnapTruckOptions(v.Truck, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRoadSnapTruckOptions(v *types.RoadSnapTruckOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrossWeight != 0 {
		ok := object.Key("GrossWeight")
		ok.Long(v.GrossWeight)
	}

	if v.HazardousCargos != nil {
		ok := object.Key("HazardousCargos")
		if err := awsRestjson1_serializeDocumentRoadSnapHazardousCargoTypeList(v.HazardousCargos, ok); err != nil {
			return err
		}
	}

	if v.Height != 0 {
		ok := object.Key("Height")
		ok.Long(v.Height)
	}

	if v.Length != 0 {
		ok := object.Key("Length")
		ok.Long(v.Length)
	}

	if v.Trailer != nil {
		ok := object.Key("Trailer")
		if err := awsRestjson1_serializeDocumentRoadSnapTrailerOptions(v.Trailer, ok); err != nil {
			return err
		}
	}

	if v.TunnelRestrictionCode != nil {
		ok := object.Key("TunnelRestrictionCode")
		ok.String(*v.TunnelRestrictionCode)
	}

	if v.Width != 0 {
		ok := object.Key("Width")
		ok.Long(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteAllowOptions(v *types.RouteAllowOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hot != nil {
		ok := object.Key("Hot")
		ok.Boolean(*v.Hot)
	}

	if v.Hov != nil {
		ok := object.Key("Hov")
		ok.Boolean(*v.Hov)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceArea(v *types.RouteAvoidanceArea, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Except != nil {
		ok := object.Key("Except")
		if err := awsRestjson1_serializeDocumentRouteAvoidanceAreaGeometryList(v.Except, ok); err != nil {
			return err
		}
	}

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentRouteAvoidanceAreaGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceAreaGeometry(v *types.RouteAvoidanceAreaGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Corridor != nil {
		ok := object.Key("Corridor")
		if err := awsRestjson1_serializeDocumentCorridor(v.Corridor, ok); err != nil {
			return err
		}
	}

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Polygon, ok); err != nil {
			return err
		}
	}

	if v.PolylineCorridor != nil {
		ok := object.Key("PolylineCorridor")
		if err := awsRestjson1_serializeDocumentPolylineCorridor(v.PolylineCorridor, ok); err != nil {
			return err
		}
	}

	if v.PolylinePolygon != nil {
		ok := object.Key("PolylinePolygon")
		if err := awsRestjson1_serializeDocumentPolylineRingList(v.PolylinePolygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceAreaGeometryList(v []types.RouteAvoidanceAreaGeometry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteAvoidanceAreaGeometry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceAreaList(v []types.RouteAvoidanceArea, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteAvoidanceArea(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceOptions(v *types.RouteAvoidanceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Areas != nil {
		ok := object.Key("Areas")
		if err := awsRestjson1_serializeDocumentRouteAvoidanceAreaList(v.Areas, ok); err != nil {
			return err
		}
	}

	if v.CarShuttleTrains != nil {
		ok := object.Key("CarShuttleTrains")
		ok.Boolean(*v.CarShuttleTrains)
	}

	if v.ControlledAccessHighways != nil {
		ok := object.Key("ControlledAccessHighways")
		ok.Boolean(*v.ControlledAccessHighways)
	}

	if v.DirtRoads != nil {
		ok := object.Key("DirtRoads")
		ok.Boolean(*v.DirtRoads)
	}

	if v.Ferries != nil {
		ok := object.Key("Ferries")
		ok.Boolean(*v.Ferries)
	}

	if v.SeasonalClosure != nil {
		ok := object.Key("SeasonalClosure")
		ok.Boolean(*v.SeasonalClosure)
	}

	if v.TollRoads != nil {
		ok := object.Key("TollRoads")
		ok.Boolean(*v.TollRoads)
	}

	if v.TollTransponders != nil {
		ok := object.Key("TollTransponders")
		ok.Boolean(*v.TollTransponders)
	}

	if v.TruckRoadTypes != nil {
		ok := object.Key("TruckRoadTypes")
		if err := awsRestjson1_serializeDocumentTruckRoadTypeList(v.TruckRoadTypes, ok); err != nil {
			return err
		}
	}

	if v.Tunnels != nil {
		ok := object.Key("Tunnels")
		ok.Boolean(*v.Tunnels)
	}

	if v.UTurns != nil {
		ok := object.Key("UTurns")
		ok.Boolean(*v.UTurns)
	}

	if v.ZoneCategories != nil {
		ok := object.Key("ZoneCategories")
		if err := awsRestjson1_serializeDocumentRouteAvoidanceZoneCategoryList(v.ZoneCategories, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceZoneCategory(v *types.RouteAvoidanceZoneCategory, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("Category")
		ok.String(string(v.Category))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteAvoidanceZoneCategoryList(v []types.RouteAvoidanceZoneCategory, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteAvoidanceZoneCategory(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteCarOptions(v *types.RouteCarOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EngineType) > 0 {
		ok := object.Key("EngineType")
		ok.String(string(v.EngineType))
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentRouteVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteDestinationOptions(v *types.RouteDestinationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.AvoidUTurns != nil {
		ok := object.Key("AvoidUTurns")
		ok.Boolean(*v.AvoidUTurns)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentRouteMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentRouteSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	if v.StopDuration != 0 {
		ok := object.Key("StopDuration")
		ok.Long(v.StopDuration)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteDriverOptions(v *types.RouteDriverOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		if err := awsRestjson1_serializeDocumentRouteDriverScheduleIntervalList(v.Schedule, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteDriverScheduleInterval(v *types.RouteDriverScheduleInterval, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("DriveDuration")
		ok.Long(v.DriveDuration)
	}

	{
		ok := object.Key("RestDuration")
		ok.Long(v.RestDuration)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteDriverScheduleIntervalList(v []types.RouteDriverScheduleInterval, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteDriverScheduleInterval(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteEmissionType(v *types.RouteEmissionType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Co2EmissionClass != nil {
		ok := object.Key("Co2EmissionClass")
		ok.String(*v.Co2EmissionClass)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteExclusionOptions(v *types.RouteExclusionOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Countries != nil {
		ok := object.Key("Countries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.Countries, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteHazardousCargoTypeList(v []types.RouteHazardousCargoType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteLegAdditionalFeatureList(v []types.RouteLegAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteMatchingOptions(v *types.RouteMatchingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NameHint != nil {
		ok := object.Key("NameHint")
		ok.String(*v.NameHint)
	}

	if v.OnRoadThreshold != 0 {
		ok := object.Key("OnRoadThreshold")
		ok.Long(v.OnRoadThreshold)
	}

	if v.Radius != 0 {
		ok := object.Key("Radius")
		ok.Long(v.Radius)
	}

	if len(v.Strategy) > 0 {
		ok := object.Key("Strategy")
		ok.String(string(v.Strategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAllowOptions(v *types.RouteMatrixAllowOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hot != nil {
		ok := object.Key("Hot")
		ok.Boolean(*v.Hot)
	}

	if v.Hov != nil {
		ok := object.Key("Hov")
		ok.Boolean(*v.Hov)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAutoCircle(v *types.RouteMatrixAutoCircle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Margin != 0 {
		ok := object.Key("Margin")
		ok.Long(v.Margin)
	}

	if v.MaxRadius != 0 {
		ok := object.Key("MaxRadius")
		ok.Long(v.MaxRadius)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAvoidanceArea(v *types.RouteMatrixAvoidanceArea, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentRouteMatrixAvoidanceAreaGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAvoidanceAreaGeometry(v *types.RouteMatrixAvoidanceAreaGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Polygon, ok); err != nil {
			return err
		}
	}

	if v.PolylinePolygon != nil {
		ok := object.Key("PolylinePolygon")
		if err := awsRestjson1_serializeDocumentPolylineRingList(v.PolylinePolygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAvoidanceAreaList(v []types.RouteMatrixAvoidanceArea, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteMatrixAvoidanceArea(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAvoidanceOptions(v *types.RouteMatrixAvoidanceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Areas != nil {
		ok := object.Key("Areas")
		if err := awsRestjson1_serializeDocumentRouteMatrixAvoidanceAreaList(v.Areas, ok); err != nil {
			return err
		}
	}

	if v.CarShuttleTrains != nil {
		ok := object.Key("CarShuttleTrains")
		ok.Boolean(*v.CarShuttleTrains)
	}

	if v.ControlledAccessHighways != nil {
		ok := object.Key("ControlledAccessHighways")
		ok.Boolean(*v.ControlledAccessHighways)
	}

	if v.DirtRoads != nil {
		ok := object.Key("DirtRoads")
		ok.Boolean(*v.DirtRoads)
	}

	if v.Ferries != nil {
		ok := object.Key("Ferries")
		ok.Boolean(*v.Ferries)
	}

	if v.TollRoads != nil {
		ok := object.Key("TollRoads")
		ok.Boolean(*v.TollRoads)
	}

	if v.TollTransponders != nil {
		ok := object.Key("TollTransponders")
		ok.Boolean(*v.TollTransponders)
	}

	if v.TruckRoadTypes != nil {
		ok := object.Key("TruckRoadTypes")
		if err := awsRestjson1_serializeDocumentTruckRoadTypeList(v.TruckRoadTypes, ok); err != nil {
			return err
		}
	}

	if v.Tunnels != nil {
		ok := object.Key("Tunnels")
		ok.Boolean(*v.Tunnels)
	}

	if v.UTurns != nil {
		ok := object.Key("UTurns")
		ok.Boolean(*v.UTurns)
	}

	if v.ZoneCategories != nil {
		ok := object.Key("ZoneCategories")
		if err := awsRestjson1_serializeDocumentRouteMatrixAvoidanceZoneCategoryList(v.ZoneCategories, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAvoidanceZoneCategory(v *types.RouteMatrixAvoidanceZoneCategory, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("Category")
		ok.String(string(v.Category))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixAvoidanceZoneCategoryList(v []types.RouteMatrixAvoidanceZoneCategory, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteMatrixAvoidanceZoneCategory(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixBoundary(v *types.RouteMatrixBoundary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentRouteMatrixBoundaryGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	if v.Unbounded != nil {
		ok := object.Key("Unbounded")
		ok.Boolean(*v.Unbounded)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixBoundaryGeometry(v *types.RouteMatrixBoundaryGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoCircle != nil {
		ok := object.Key("AutoCircle")
		if err := awsRestjson1_serializeDocumentRouteMatrixAutoCircle(v.AutoCircle, ok); err != nil {
			return err
		}
	}

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Circle != nil {
		ok := object.Key("Circle")
		if err := awsRestjson1_serializeDocumentCircle(v.Circle, ok); err != nil {
			return err
		}
	}

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Polygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixCarOptions(v *types.RouteMatrixCarOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentRouteMatrixVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixDestination(v *types.RouteMatrixDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentRouteMatrixDestinationOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixDestinationList(v []types.RouteMatrixDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteMatrixDestination(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixDestinationOptions(v *types.RouteMatrixDestinationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentRouteMatrixMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentRouteMatrixSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixExclusionOptions(v *types.RouteMatrixExclusionOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Countries != nil {
		ok := object.Key("Countries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.Countries, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixHazardousCargoTypeList(v []types.RouteMatrixHazardousCargoType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixMatchingOptions(v *types.RouteMatrixMatchingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NameHint != nil {
		ok := object.Key("NameHint")
		ok.String(*v.NameHint)
	}

	if v.OnRoadThreshold != 0 {
		ok := object.Key("OnRoadThreshold")
		ok.Long(v.OnRoadThreshold)
	}

	if v.Radius != 0 {
		ok := object.Key("Radius")
		ok.Long(v.Radius)
	}

	if len(v.Strategy) > 0 {
		ok := object.Key("Strategy")
		ok.String(string(v.Strategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixOrigin(v *types.RouteMatrixOrigin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentRouteMatrixOriginOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixOriginList(v []types.RouteMatrixOrigin, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteMatrixOrigin(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixOriginOptions(v *types.RouteMatrixOriginOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentRouteMatrixMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentRouteMatrixSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixScooterOptions(v *types.RouteMatrixScooterOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentRouteMatrixVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixSideOfStreetOptions(v *types.RouteMatrixSideOfStreetOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if len(v.UseWith) > 0 {
		ok := object.Key("UseWith")
		ok.String(string(v.UseWith))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixTrafficOptions(v *types.RouteMatrixTrafficOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowEventThresholdOverride != 0 {
		ok := object.Key("FlowEventThresholdOverride")
		ok.Long(v.FlowEventThresholdOverride)
	}

	if len(v.Usage) > 0 {
		ok := object.Key("Usage")
		ok.String(string(v.Usage))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixTrailerOptions(v *types.RouteMatrixTrailerOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TrailerCount != nil {
		ok := object.Key("TrailerCount")
		ok.Integer(*v.TrailerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixTravelModeOptions(v *types.RouteMatrixTravelModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Car != nil {
		ok := object.Key("Car")
		if err := awsRestjson1_serializeDocumentRouteMatrixCarOptions(v.Car, ok); err != nil {
			return err
		}
	}

	if v.Scooter != nil {
		ok := object.Key("Scooter")
		if err := awsRestjson1_serializeDocumentRouteMatrixScooterOptions(v.Scooter, ok); err != nil {
			return err
		}
	}

	if v.Truck != nil {
		ok := object.Key("Truck")
		if err := awsRestjson1_serializeDocumentRouteMatrixTruckOptions(v.Truck, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixTruckOptions(v *types.RouteMatrixTruckOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxleCount != nil {
		ok := object.Key("AxleCount")
		ok.Integer(*v.AxleCount)
	}

	if v.GrossWeight != 0 {
		ok := object.Key("GrossWeight")
		ok.Long(v.GrossWeight)
	}

	if v.HazardousCargos != nil {
		ok := object.Key("HazardousCargos")
		if err := awsRestjson1_serializeDocumentRouteMatrixHazardousCargoTypeList(v.HazardousCargos, ok); err != nil {
			return err
		}
	}

	if v.Height != 0 {
		ok := object.Key("Height")
		ok.Long(v.Height)
	}

	if v.KpraLength != 0 {
		ok := object.Key("KpraLength")
		ok.Long(v.KpraLength)
	}

	if v.Length != 0 {
		ok := object.Key("Length")
		ok.Long(v.Length)
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentRouteMatrixVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	if v.PayloadCapacity != 0 {
		ok := object.Key("PayloadCapacity")
		ok.Long(v.PayloadCapacity)
	}

	if v.Trailer != nil {
		ok := object.Key("Trailer")
		if err := awsRestjson1_serializeDocumentRouteMatrixTrailerOptions(v.Trailer, ok); err != nil {
			return err
		}
	}

	if len(v.TruckType) > 0 {
		ok := object.Key("TruckType")
		ok.String(string(v.TruckType))
	}

	if v.TunnelRestrictionCode != nil {
		ok := object.Key("TunnelRestrictionCode")
		ok.String(*v.TunnelRestrictionCode)
	}

	if v.WeightPerAxle != 0 {
		ok := object.Key("WeightPerAxle")
		ok.Long(v.WeightPerAxle)
	}

	if v.WeightPerAxleGroup != nil {
		ok := object.Key("WeightPerAxleGroup")
		if err := awsRestjson1_serializeDocumentWeightPerAxleGroup(v.WeightPerAxleGroup, ok); err != nil {
			return err
		}
	}

	if v.Width != 0 {
		ok := object.Key("Width")
		ok.Long(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteMatrixVehicleLicensePlate(v *types.RouteMatrixVehicleLicensePlate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LastCharacter != nil {
		ok := object.Key("LastCharacter")
		ok.String(*v.LastCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteOriginOptions(v *types.RouteOriginOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.AvoidUTurns != nil {
		ok := object.Key("AvoidUTurns")
		ok.Boolean(*v.AvoidUTurns)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentRouteMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentRouteSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRoutePedestrianOptions(v *types.RoutePedestrianOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Speed != nil {
		ok := object.Key("Speed")
		switch {
		case math.IsNaN(*v.Speed):
			ok.String("NaN")

		case math.IsInf(*v.Speed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Speed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Speed)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteScooterOptions(v *types.RouteScooterOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EngineType) > 0 {
		ok := object.Key("EngineType")
		ok.String(string(v.EngineType))
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentRouteVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteSideOfStreetOptions(v *types.RouteSideOfStreetOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if len(v.UseWith) > 0 {
		ok := object.Key("UseWith")
		ok.String(string(v.UseWith))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteSpanAdditionalFeatureList(v []types.RouteSpanAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteTollOptions(v *types.RouteTollOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllTransponders != nil {
		ok := object.Key("AllTransponders")
		ok.Boolean(*v.AllTransponders)
	}

	if v.AllVignettes != nil {
		ok := object.Key("AllVignettes")
		ok.Boolean(*v.AllVignettes)
	}

	if v.Currency != nil {
		ok := object.Key("Currency")
		ok.String(*v.Currency)
	}

	if v.EmissionType != nil {
		ok := object.Key("EmissionType")
		if err := awsRestjson1_serializeDocumentRouteEmissionType(v.EmissionType, ok); err != nil {
			return err
		}
	}

	if len(v.VehicleCategory) > 0 {
		ok := object.Key("VehicleCategory")
		ok.String(string(v.VehicleCategory))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteTrafficOptions(v *types.RouteTrafficOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowEventThresholdOverride != 0 {
		ok := object.Key("FlowEventThresholdOverride")
		ok.Long(v.FlowEventThresholdOverride)
	}

	if len(v.Usage) > 0 {
		ok := object.Key("Usage")
		ok.String(string(v.Usage))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteTrailerOptions(v *types.RouteTrailerOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxleCount != nil {
		ok := object.Key("AxleCount")
		ok.Integer(*v.AxleCount)
	}

	if v.TrailerCount != nil {
		ok := object.Key("TrailerCount")
		ok.Integer(*v.TrailerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteTravelModeOptions(v *types.RouteTravelModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Car != nil {
		ok := object.Key("Car")
		if err := awsRestjson1_serializeDocumentRouteCarOptions(v.Car, ok); err != nil {
			return err
		}
	}

	if v.Pedestrian != nil {
		ok := object.Key("Pedestrian")
		if err := awsRestjson1_serializeDocumentRoutePedestrianOptions(v.Pedestrian, ok); err != nil {
			return err
		}
	}

	if v.Scooter != nil {
		ok := object.Key("Scooter")
		if err := awsRestjson1_serializeDocumentRouteScooterOptions(v.Scooter, ok); err != nil {
			return err
		}
	}

	if v.Truck != nil {
		ok := object.Key("Truck")
		if err := awsRestjson1_serializeDocumentRouteTruckOptions(v.Truck, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteTruckOptions(v *types.RouteTruckOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxleCount != nil {
		ok := object.Key("AxleCount")
		ok.Integer(*v.AxleCount)
	}

	if len(v.EngineType) > 0 {
		ok := object.Key("EngineType")
		ok.String(string(v.EngineType))
	}

	if v.GrossWeight != 0 {
		ok := object.Key("GrossWeight")
		ok.Long(v.GrossWeight)
	}

	if v.HazardousCargos != nil {
		ok := object.Key("HazardousCargos")
		if err := awsRestjson1_serializeDocumentRouteHazardousCargoTypeList(v.HazardousCargos, ok); err != nil {
			return err
		}
	}

	if v.Height != 0 {
		ok := object.Key("Height")
		ok.Long(v.Height)
	}

	if v.HeightAboveFirstAxle != 0 {
		ok := object.Key("HeightAboveFirstAxle")
		ok.Long(v.HeightAboveFirstAxle)
	}

	if v.KpraLength != 0 {
		ok := object.Key("KpraLength")
		ok.Long(v.KpraLength)
	}

	if v.Length != 0 {
		ok := object.Key("Length")
		ok.Long(v.Length)
	}

	if v.LicensePlate != nil {
		ok := object.Key("LicensePlate")
		if err := awsRestjson1_serializeDocumentRouteVehicleLicensePlate(v.LicensePlate, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeed != nil {
		ok := object.Key("MaxSpeed")
		switch {
		case math.IsNaN(*v.MaxSpeed):
			ok.String("NaN")

		case math.IsInf(*v.MaxSpeed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxSpeed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxSpeed)

		}
	}

	if v.Occupancy != nil {
		ok := object.Key("Occupancy")
		ok.Integer(*v.Occupancy)
	}

	if v.PayloadCapacity != 0 {
		ok := object.Key("PayloadCapacity")
		ok.Long(v.PayloadCapacity)
	}

	if v.TireCount != nil {
		ok := object.Key("TireCount")
		ok.Integer(*v.TireCount)
	}

	if v.Trailer != nil {
		ok := object.Key("Trailer")
		if err := awsRestjson1_serializeDocumentRouteTrailerOptions(v.Trailer, ok); err != nil {
			return err
		}
	}

	if len(v.TruckType) > 0 {
		ok := object.Key("TruckType")
		ok.String(string(v.TruckType))
	}

	if v.TunnelRestrictionCode != nil {
		ok := object.Key("TunnelRestrictionCode")
		ok.String(*v.TunnelRestrictionCode)
	}

	if v.WeightPerAxle != 0 {
		ok := object.Key("WeightPerAxle")
		ok.Long(v.WeightPerAxle)
	}

	if v.WeightPerAxleGroup != nil {
		ok := object.Key("WeightPerAxleGroup")
		if err := awsRestjson1_serializeDocumentWeightPerAxleGroup(v.WeightPerAxleGroup, ok); err != nil {
			return err
		}
	}

	if v.Width != 0 {
		ok := object.Key("Width")
		ok.Long(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteVehicleLicensePlate(v *types.RouteVehicleLicensePlate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LastCharacter != nil {
		ok := object.Key("LastCharacter")
		ok.String(*v.LastCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteWaypoint(v *types.RouteWaypoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidActionsForDistance != 0 {
		ok := object.Key("AvoidActionsForDistance")
		ok.Long(v.AvoidActionsForDistance)
	}

	if v.AvoidUTurns != nil {
		ok := object.Key("AvoidUTurns")
		ok.Boolean(*v.AvoidUTurns)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentRouteMatchingOptions(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.PassThrough != nil {
		ok := object.Key("PassThrough")
		ok.Boolean(*v.PassThrough)
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentRouteSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	if v.StopDuration != 0 {
		ok := object.Key("StopDuration")
		ok.Long(v.StopDuration)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteWaypointList(v []types.RouteWaypoint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRouteWaypoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTimeThresholdList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTruckRoadTypeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationAccessHours(v *types.WaypointOptimizationAccessHours, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.From != nil {
		ok := object.Key("From")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAccessHoursEntry(v.From, ok); err != nil {
			return err
		}
	}

	if v.To != nil {
		ok := object.Key("To")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAccessHoursEntry(v.To, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationAccessHoursEntry(v *types.WaypointOptimizationAccessHoursEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DayOfWeek) > 0 {
		ok := object.Key("DayOfWeek")
		ok.String(string(v.DayOfWeek))
	}

	if v.TimeOfDay != nil {
		ok := object.Key("TimeOfDay")
		ok.String(*v.TimeOfDay)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceArea(v *types.WaypointOptimizationAvoidanceArea, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceAreaGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceAreaGeometry(v *types.WaypointOptimizationAvoidanceAreaGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceAreaList(v []types.WaypointOptimizationAvoidanceArea, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceArea(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceOptions(v *types.WaypointOptimizationAvoidanceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Areas != nil {
		ok := object.Key("Areas")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAvoidanceAreaList(v.Areas, ok); err != nil {
			return err
		}
	}

	if v.CarShuttleTrains != nil {
		ok := object.Key("CarShuttleTrains")
		ok.Boolean(*v.CarShuttleTrains)
	}

	if v.ControlledAccessHighways != nil {
		ok := object.Key("ControlledAccessHighways")
		ok.Boolean(*v.ControlledAccessHighways)
	}

	if v.DirtRoads != nil {
		ok := object.Key("DirtRoads")
		ok.Boolean(*v.DirtRoads)
	}

	if v.Ferries != nil {
		ok := object.Key("Ferries")
		ok.Boolean(*v.Ferries)
	}

	if v.TollRoads != nil {
		ok := object.Key("TollRoads")
		ok.Boolean(*v.TollRoads)
	}

	if v.Tunnels != nil {
		ok := object.Key("Tunnels")
		ok.Boolean(*v.Tunnels)
	}

	if v.UTurns != nil {
		ok := object.Key("UTurns")
		ok.Boolean(*v.UTurns)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationClusteringOptions(v *types.WaypointOptimizationClusteringOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("Algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.DrivingDistanceOptions != nil {
		ok := object.Key("DrivingDistanceOptions")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationDrivingDistanceOptions(v.DrivingDistanceOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationDestinationOptions(v *types.WaypointOptimizationDestinationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessHours != nil {
		ok := object.Key("AccessHours")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAccessHours(v.AccessHours, ok); err != nil {
			return err
		}
	}

	if v.AppointmentTime != nil {
		ok := object.Key("AppointmentTime")
		ok.String(*v.AppointmentTime)
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.ServiceDuration != 0 {
		ok := object.Key("ServiceDuration")
		ok.Long(v.ServiceDuration)
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationDriverOptions(v *types.WaypointOptimizationDriverOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RestCycles != nil {
		ok := object.Key("RestCycles")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationRestCycles(v.RestCycles, ok); err != nil {
			return err
		}
	}

	if v.RestProfile != nil {
		ok := object.Key("RestProfile")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationRestProfile(v.RestProfile, ok); err != nil {
			return err
		}
	}

	if len(v.TreatServiceTimeAs) > 0 {
		ok := object.Key("TreatServiceTimeAs")
		ok.String(string(v.TreatServiceTimeAs))
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationDrivingDistanceOptions(v *types.WaypointOptimizationDrivingDistanceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("DrivingDistance")
		ok.Long(v.DrivingDistance)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationExclusionOptions(v *types.WaypointOptimizationExclusionOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Countries != nil {
		ok := object.Key("Countries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.Countries, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationHazardousCargoTypeList(v []types.WaypointOptimizationHazardousCargoType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationOriginOptions(v *types.WaypointOptimizationOriginOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationPedestrianOptions(v *types.WaypointOptimizationPedestrianOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Speed != nil {
		ok := object.Key("Speed")
		switch {
		case math.IsNaN(*v.Speed):
			ok.String("NaN")

		case math.IsInf(*v.Speed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Speed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Speed)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationRestCycleDurations(v *types.WaypointOptimizationRestCycleDurations, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("RestDuration")
		ok.Long(v.RestDuration)
	}

	{
		ok := object.Key("WorkDuration")
		ok.Long(v.WorkDuration)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationRestCycles(v *types.WaypointOptimizationRestCycles, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LongCycle != nil {
		ok := object.Key("LongCycle")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationRestCycleDurations(v.LongCycle, ok); err != nil {
			return err
		}
	}

	if v.ShortCycle != nil {
		ok := object.Key("ShortCycle")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationRestCycleDurations(v.ShortCycle, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationRestProfile(v *types.WaypointOptimizationRestProfile, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Profile != nil {
		ok := object.Key("Profile")
		ok.String(*v.Profile)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationSideOfStreetOptions(v *types.WaypointOptimizationSideOfStreetOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if len(v.UseWith) > 0 {
		ok := object.Key("UseWith")
		ok.String(string(v.UseWith))
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationTrafficOptions(v *types.WaypointOptimizationTrafficOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Usage) > 0 {
		ok := object.Key("Usage")
		ok.String(string(v.Usage))
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationTrailerOptions(v *types.WaypointOptimizationTrailerOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TrailerCount != nil {
		ok := object.Key("TrailerCount")
		ok.Integer(*v.TrailerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationTravelModeOptions(v *types.WaypointOptimizationTravelModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pedestrian != nil {
		ok := object.Key("Pedestrian")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationPedestrianOptions(v.Pedestrian, ok); err != nil {
			return err
		}
	}

	if v.Truck != nil {
		ok := object.Key("Truck")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationTruckOptions(v.Truck, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationTruckOptions(v *types.WaypointOptimizationTruckOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrossWeight != 0 {
		ok := object.Key("GrossWeight")
		ok.Long(v.GrossWeight)
	}

	if v.HazardousCargos != nil {
		ok := object.Key("HazardousCargos")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationHazardousCargoTypeList(v.HazardousCargos, ok); err != nil {
			return err
		}
	}

	if v.Height != 0 {
		ok := object.Key("Height")
		ok.Long(v.Height)
	}

	if v.Length != 0 {
		ok := object.Key("Length")
		ok.Long(v.Length)
	}

	if v.Trailer != nil {
		ok := object.Key("Trailer")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationTrailerOptions(v.Trailer, ok); err != nil {
			return err
		}
	}

	if len(v.TruckType) > 0 {
		ok := object.Key("TruckType")
		ok.String(string(v.TruckType))
	}

	if v.TunnelRestrictionCode != nil {
		ok := object.Key("TunnelRestrictionCode")
		ok.String(*v.TunnelRestrictionCode)
	}

	if v.WeightPerAxle != 0 {
		ok := object.Key("WeightPerAxle")
		ok.Long(v.WeightPerAxle)
	}

	if v.Width != 0 {
		ok := object.Key("Width")
		ok.Long(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationWaypoint(v *types.WaypointOptimizationWaypoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessHours != nil {
		ok := object.Key("AccessHours")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationAccessHours(v.AccessHours, ok); err != nil {
			return err
		}
	}

	if v.AppointmentTime != nil {
		ok := object.Key("AppointmentTime")
		ok.String(*v.AppointmentTime)
	}

	if v.Before != nil {
		ok := object.Key("Before")
		if err := awsRestjson1_serializeDocumentBeforeWaypointsList(v.Before, ok); err != nil {
			return err
		}
	}

	if v.Heading != 0 {
		ok := object.Key("Heading")
		switch {
		case math.IsNaN(v.Heading):
			ok.String("NaN")

		case math.IsInf(v.Heading, 1):
			ok.String("Infinity")

		case math.IsInf(v.Heading, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Heading)

		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.ServiceDuration != 0 {
		ok := object.Key("ServiceDuration")
		ok.Long(v.ServiceDuration)
	}

	if v.SideOfStreet != nil {
		ok := object.Key("SideOfStreet")
		if err := awsRestjson1_serializeDocumentWaypointOptimizationSideOfStreetOptions(v.SideOfStreet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointOptimizationWaypointList(v []types.WaypointOptimizationWaypoint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWaypointOptimizationWaypoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWeightPerAxleGroup(v *types.WeightPerAxleGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Quad != 0 {
		ok := object.Key("Quad")
		ok.Long(v.Quad)
	}

	if v.Quint != 0 {
		ok := object.Key("Quint")
		ok.Long(v.Quint)
	}

	if v.Single != 0 {
		ok := object.Key("Single")
		ok.Long(v.Single)
	}

	if v.Tandem != 0 {
		ok := object.Key("Tandem")
		ok.Long(v.Tandem)
	}

	if v.Triple != 0 {
		ok := object.Key("Triple")
		ok.Long(v.Triple)
	}

	return nil
}
