// Code generated by smithy-go-codegen DO NOT EDIT.

package geomaps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// GetGlyphs returns the map's glyphs.
func (c *Client) GetGlyphs(ctx context.Context, params *GetGlyphsInput, optFns ...func(*Options)) (*GetGlyphsOutput, error) {
	if params == nil {
		params = &GetGlyphsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetGlyphs", params, optFns, c.addOperationGetGlyphsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetGlyphsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetGlyphsInput struct {

	// Name of the FontStack to retrieve.
	//
	// Example: Amazon Ember Bold,Noto Sans Bold .
	//
	// The supported font stacks are as follows:
	//
	//   - Amazon Ember Bold
	//
	//   - Amazon Ember Bold Italic
	//
	//   - Amazon Ember Bold,Noto Sans Bold
	//
	//   - Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold
	//
	//   - Amazon Ember Condensed RC BdItalic
	//
	//   - Amazon Ember Condensed RC Bold
	//
	//   - Amazon Ember Condensed RC Bold Italic
	//
	//   - Amazon Ember Condensed RC Bold,Noto Sans Bold
	//
	//   - Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed
	//   Bold
	//
	//   - Amazon Ember Condensed RC Light
	//
	//   - Amazon Ember Condensed RC Light Italic
	//
	//   - Amazon Ember Condensed RC LtItalic
	//
	//   - Amazon Ember Condensed RC Regular
	//
	//   - Amazon Ember Condensed RC Regular Italic
	//
	//   - Amazon Ember Condensed RC Regular,Noto Sans Regular
	//
	//   - Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic
	//   Condensed Regular
	//
	//   - Amazon Ember Condensed RC RgItalic
	//
	//   - Amazon Ember Condensed RC ThItalic
	//
	//   - Amazon Ember Condensed RC Thin
	//
	//   - Amazon Ember Condensed RC Thin Italic
	//
	//   - Amazon Ember Heavy
	//
	//   - Amazon Ember Heavy Italic
	//
	//   - Amazon Ember Light
	//
	//   - Amazon Ember Light Italic
	//
	//   - Amazon Ember Medium
	//
	//   - Amazon Ember Medium Italic
	//
	//   - Amazon Ember Medium,Noto Sans Medium
	//
	//   - Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium
	//
	//   - Amazon Ember Regular
	//
	//   - Amazon Ember Regular Italic
	//
	//   - Amazon Ember Regular Italic,Noto Sans Italic
	//
	//   - Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular
	//
	//   - Amazon Ember Regular,Noto Sans Regular
	//
	//   - Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular
	//
	//   - Amazon Ember Thin
	//
	//   - Amazon Ember Thin Italic
	//
	//   - AmazonEmberCdRC_Bd
	//
	//   - AmazonEmberCdRC_BdIt
	//
	//   - AmazonEmberCdRC_Lt
	//
	//   - AmazonEmberCdRC_LtIt
	//
	//   - AmazonEmberCdRC_Rg
	//
	//   - AmazonEmberCdRC_RgIt
	//
	//   - AmazonEmberCdRC_Th
	//
	//   - AmazonEmberCdRC_ThIt
	//
	//   - AmazonEmber_Bd
	//
	//   - AmazonEmber_BdIt
	//
	//   - AmazonEmber_He
	//
	//   - AmazonEmber_HeIt
	//
	//   - AmazonEmber_Lt
	//
	//   - AmazonEmber_LtIt
	//
	//   - AmazonEmber_Md
	//
	//   - AmazonEmber_MdIt
	//
	//   - AmazonEmber_Rg
	//
	//   - AmazonEmber_RgIt
	//
	//   - AmazonEmber_Th
	//
	//   - AmazonEmber_ThIt
	//
	//   - Noto Sans Black
	//
	//   - Noto Sans Black Italic
	//
	//   - Noto Sans Bold
	//
	//   - Noto Sans Bold Italic
	//
	//   - Noto Sans Extra Bold
	//
	//   - Noto Sans Extra Bold Italic
	//
	//   - Noto Sans Extra Light
	//
	//   - Noto Sans Extra Light Italic
	//
	//   - Noto Sans Italic
	//
	//   - Noto Sans Light
	//
	//   - Noto Sans Light Italic
	//
	//   - Noto Sans Medium
	//
	//   - Noto Sans Medium Italic
	//
	//   - Noto Sans Regular
	//
	//   - Noto Sans Semi Bold
	//
	//   - Noto Sans Semi Bold Italic
	//
	//   - Noto Sans Thin
	//
	//   - Noto Sans Thin Italic
	//
	//   - NotoSans-Bold
	//
	//   - NotoSans-Italic
	//
	//   - NotoSans-Medium
	//
	//   - NotoSans-Regular
	//
	//   - Open Sans Regular,Arial Unicode MS Regular
	//
	// This member is required.
	FontStack *string

	// A Unicode range of characters to download glyphs for. This must be aligned to
	// multiples of 256.
	//
	// Example: 0-255.pdf
	//
	// This member is required.
	FontUnicodeRange *string

	noSmithyDocumentSerde
}

type GetGlyphsOutput struct {

	// The Glyph, as a binary blob.
	Blob []byte

	// Header that instructs caching configuration for the client.
	CacheControl *string

	// Header that represents the format of the response. The response returns the
	// following as the HTTP body.
	ContentType *string

	// The glyph's Etag.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetGlyphsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetGlyphs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetGlyphs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetGlyphs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetGlyphsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetGlyphs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetGlyphs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetGlyphs",
	}
}
