// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Add locations that can host stream sessions. You configure locations and their
//
// corresponding capacity for each stream group. Creating a stream group in a
// location that's nearest to your end users can help minimize latency and improve
// quality.
//
// This operation provisions stream capacity at the specified locations. By
// default, all locations have 1 or 2 capacity, depending on the stream class
// option: 2 for 'High' and 1 for 'Ultra' and 'Win2022'. This operation also copies
// the content files of all associated applications to an internal S3 bucket at
// each location. This allows Amazon GameLift Streams to host performant stream
// sessions.
func (c *Client) AddStreamGroupLocations(ctx context.Context, params *AddStreamGroupLocationsInput, optFns ...func(*Options)) (*AddStreamGroupLocationsOutput, error) {
	if params == nil {
		params = &AddStreamGroupLocationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AddStreamGroupLocations", params, optFns, c.addOperationAddStreamGroupLocationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AddStreamGroupLocationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AddStreamGroupLocationsInput struct {

	//  A stream group to add the specified locations to.
	//
	// This value is an [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource.
	// Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	//  A set of one or more locations and the streaming capacity for each location.
	//
	// This member is required.
	LocationConfigurations []types.LocationConfiguration

	noSmithyDocumentSerde
}

type AddStreamGroupLocationsOutput struct {

	// This value is an [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource.
	// Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	// This value is set of locations, including their name, current status, and
	// capacities.
	//
	// A location can be in one of the following states:
	//
	//   - ACTIVATING : Amazon GameLift Streams is preparing the location. You cannot
	//   stream from, scale the capacity of, or remove this location yet.
	//
	//   - ACTIVE : The location is provisioned with initial capacity. You can now
	//   stream from, scale the capacity of, or remove this location.
	//
	//   - ERROR : Amazon GameLift Streams failed to set up this location. The
	//   StatusReason field describes the error. You can remove this location and try
	//   to add it again.
	//
	//   - REMOVING : Amazon GameLift Streams is working to remove this location. This
	//   will release all provisioned capacity for this location in this stream group.
	//
	// This member is required.
	Locations []types.LocationState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAddStreamGroupLocationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAddStreamGroupLocations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAddStreamGroupLocations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AddStreamGroupLocations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAddStreamGroupLocationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAddStreamGroupLocations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAddStreamGroupLocations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AddStreamGroupLocations",
	}
}
