// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a placement queue that processes requests for new game sessions. A
// queue uses FleetIQ algorithms to locate the best available placement locations
// for a new game session, and then prompts the game server process to start a new
// game session.
//
// A game session queue is configured with a set of destinations (Amazon GameLift
// Servers fleets or aliases) that determine where the queue can place new game
// sessions. These destinations can span multiple Amazon Web Services Regions, can
// use different instance types, and can include both Spot and On-Demand fleets. If
// the queue includes multi-location fleets, the queue can place game sessions in
// any of a fleet's remote locations.
//
// You can configure a queue to determine how it selects the best available
// placement for a new game session. Queues can prioritize placement decisions
// based on a combination of location, hosting cost, and player latency. You can
// set up the queue to use the default prioritization or provide alternate
// instructions using PriorityConfiguration .
//
// # Request options
//
// Use this operation to make these common types of requests.
//
//   - Create a queue with the minimum required parameters.
//
//   - Name
//
//   - Destinations (This parameter isn't required, but a queue can't make
//     placements without at least one destination.)
//
//   - Create a queue with placement notification. Queues that have high placement
//     activity must use a notification system, such as with Amazon Simple Notification
//     Service (Amazon SNS) or Amazon CloudWatch.
//
//   - Required parameters Name and Destinations
//
//   - NotificationTarget
//
//   - Create a queue with custom prioritization settings. These custom settings
//     replace the default prioritization configuration for a queue.
//
//   - Required parameters Name and Destinations
//
//   - PriorityConfiguration
//
//   - Create a queue with special rules for processing player latency data.
//
//   - Required parameters Name and Destinations
//
//   - PlayerLatencyPolicies
//
// # Results
//
// If successful, this operation returns a new GameSessionQueue object with an
// assigned queue ARN. Use the queue's name or ARN when submitting new game session
// requests with [StartGameSessionPlacement]or [StartMatchmaking].
//
// # Learn more
//
// [Design a game session queue]
//
// [Create a game session queue]
//
// # Related actions
//
// [CreateGameSessionQueue]| [DescribeGameSessionQueues] | [UpdateGameSessionQueue] | [DeleteGameSessionQueue] | [All APIs by task]
//
// [StartMatchmaking]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html
// [DescribeGameSessionQueues]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html
// [StartGameSessionPlacement]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html
// [Create a game session queue]: https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html
// [CreateGameSessionQueue]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html
// [UpdateGameSessionQueue]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html
// [Design a game session queue]: https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html
// [DeleteGameSessionQueue]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html
// [All APIs by task]: https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets
func (c *Client) CreateGameSessionQueue(ctx context.Context, params *CreateGameSessionQueueInput, optFns ...func(*Options)) (*CreateGameSessionQueueOutput, error) {
	if params == nil {
		params = &CreateGameSessionQueueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGameSessionQueue", params, optFns, c.addOperationCreateGameSessionQueueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGameSessionQueueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGameSessionQueueInput struct {

	// A descriptive label that is associated with game session queue. Queue names
	// must be unique within each Region.
	//
	// This member is required.
	Name *string

	// Information to be added to all events that are related to this game session
	// queue.
	CustomEventData *string

	// A list of fleets and/or fleet aliases that can be used to fulfill game session
	// placement requests in the queue. Destinations are identified by either a fleet
	// ARN or a fleet alias ARN, and are listed in order of placement preference.
	Destinations []types.GameSessionQueueDestination

	// A list of locations where a queue is allowed to place new game sessions.
	// Locations are specified in the form of Amazon Web Services Region codes, such as
	// us-west-2 . If this parameter is not set, game sessions can be placed in any
	// queue location.
	FilterConfiguration *types.FilterConfiguration

	// An SNS topic ARN that is set up to receive game session placement
	// notifications. See [Setting up notifications for game session placement].
	//
	// [Setting up notifications for game session placement]: https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html
	NotificationTarget *string

	// A set of policies that enforce a sliding cap on player latency when processing
	// game sessions placement requests. Use multiple policies to gradually relax the
	// cap over time if Amazon GameLift Servers can't make a placement. Policies are
	// evaluated in order starting with the lowest maximum latency value.
	PlayerLatencyPolicies []types.PlayerLatencyPolicy

	// Custom settings to use when prioritizing destinations and locations for game
	// session placements. This configuration replaces the FleetIQ default
	// prioritization process. Priority types that are not explicitly named will be
	// automatically applied at the end of the prioritization process.
	PriorityConfiguration *types.PriorityConfiguration

	// A list of labels to assign to the new game session queue resource. Tags are
	// developer-defined key-value pairs. Tagging Amazon Web Services resources are
	// useful for resource management, access management and cost allocation. For more
	// information, see [Tagging Amazon Web Services Resources]in the Amazon Web Services General Reference.
	//
	// [Tagging Amazon Web Services Resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []types.Tag

	// The maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status. If you don't specify a request timeout, the
	// queue uses a default value.
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

type CreateGameSessionQueueOutput struct {

	// An object that describes the newly created game session queue.
	GameSessionQueue *types.GameSessionQueue

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGameSessionQueueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateGameSessionQueue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateGameSessionQueue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGameSessionQueue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGameSessionQueueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGameSessionQueue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateGameSessionQueue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGameSessionQueue",
	}
}
