// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more S3 access points attached to Amazon FSx volumes.
//
// The requester requires the following permission to perform this action:
//
//   - fsx:DescribeS3AccessPointAttachments
func (c *Client) DescribeS3AccessPointAttachments(ctx context.Context, params *DescribeS3AccessPointAttachmentsInput, optFns ...func(*Options)) (*DescribeS3AccessPointAttachmentsOutput, error) {
	if params == nil {
		params = &DescribeS3AccessPointAttachmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeS3AccessPointAttachments", params, optFns, c.addOperationDescribeS3AccessPointAttachmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeS3AccessPointAttachmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeS3AccessPointAttachmentsInput struct {

	// Enter a filter Name and Values pair to view a select set of S3 access point
	// attachments.
	Filters []types.S3AccessPointAttachmentsFilter

	// The maximum number of resources to return in the response. This value must be
	// an integer greater than zero.
	MaxResults *int32

	// The names of the S3 access point attachments whose descriptions you want to
	// retrieve.
	Names []string

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing the
	// request, where the previous NextToken value left off.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeS3AccessPointAttachmentsOutput struct {

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing the
	// request, where the previous NextToken value left off.
	NextToken *string

	// Array of S3 access point attachments returned after a successful
	// DescribeS3AccessPointAttachments operation.
	S3AccessPointAttachments []types.S3AccessPointAttachment

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeS3AccessPointAttachmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeS3AccessPointAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeS3AccessPointAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeS3AccessPointAttachments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeS3AccessPointAttachments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeS3AccessPointAttachmentsPaginatorOptions is the paginator options for
// DescribeS3AccessPointAttachments
type DescribeS3AccessPointAttachmentsPaginatorOptions struct {
	// The maximum number of resources to return in the response. This value must be
	// an integer greater than zero.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeS3AccessPointAttachmentsPaginator is a paginator for
// DescribeS3AccessPointAttachments
type DescribeS3AccessPointAttachmentsPaginator struct {
	options   DescribeS3AccessPointAttachmentsPaginatorOptions
	client    DescribeS3AccessPointAttachmentsAPIClient
	params    *DescribeS3AccessPointAttachmentsInput
	nextToken *string
	firstPage bool
}

// NewDescribeS3AccessPointAttachmentsPaginator returns a new
// DescribeS3AccessPointAttachmentsPaginator
func NewDescribeS3AccessPointAttachmentsPaginator(client DescribeS3AccessPointAttachmentsAPIClient, params *DescribeS3AccessPointAttachmentsInput, optFns ...func(*DescribeS3AccessPointAttachmentsPaginatorOptions)) *DescribeS3AccessPointAttachmentsPaginator {
	if params == nil {
		params = &DescribeS3AccessPointAttachmentsInput{}
	}

	options := DescribeS3AccessPointAttachmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeS3AccessPointAttachmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeS3AccessPointAttachmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeS3AccessPointAttachments page.
func (p *DescribeS3AccessPointAttachmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeS3AccessPointAttachmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeS3AccessPointAttachments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeS3AccessPointAttachmentsAPIClient is a client that implements the
// DescribeS3AccessPointAttachments operation.
type DescribeS3AccessPointAttachmentsAPIClient interface {
	DescribeS3AccessPointAttachments(context.Context, *DescribeS3AccessPointAttachmentsInput, ...func(*Options)) (*DescribeS3AccessPointAttachmentsOutput, error)
}

var _ DescribeS3AccessPointAttachmentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeS3AccessPointAttachments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeS3AccessPointAttachments",
	}
}
