// Code generated by smithy-go-codegen DO NOT EDIT.

package eks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a EKS Pod Identity association. In an update, you can change the IAM
// role, the target IAM role, or disableSessionTags . You must change at least one
// of these in an update. An association can't be moved between clusters,
// namespaces, or service accounts. If you need to edit the namespace or service
// account, you need to delete the association and then create a new association
// with your desired settings.
//
// Similar to Amazon Web Services IAM behavior, EKS Pod Identity associations are
// eventually consistent, and may take several seconds to be effective after the
// initial API call returns successfully. You must design your applications to
// account for these potential delays. We recommend that you don’t include
// association create/updates in the critical, high-availability code paths of your
// application. Instead, make changes in a separate initialization or setup routine
// that you run less frequently.
//
// You can set a target IAM role in the same or a different account for advanced
// scenarios. With a target role, EKS Pod Identity automatically performs two role
// assumptions in sequence: first assuming the role in the association that is in
// this account, then using those credentials to assume the target IAM role. This
// process provides your Pod with temporary credentials that have the permissions
// defined in the target role, allowing secure access to resources in another
// Amazon Web Services account.
func (c *Client) UpdatePodIdentityAssociation(ctx context.Context, params *UpdatePodIdentityAssociationInput, optFns ...func(*Options)) (*UpdatePodIdentityAssociationOutput, error) {
	if params == nil {
		params = &UpdatePodIdentityAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePodIdentityAssociation", params, optFns, c.addOperationUpdatePodIdentityAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePodIdentityAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePodIdentityAssociationInput struct {

	// The ID of the association to be updated.
	//
	// This member is required.
	AssociationId *string

	// The name of the cluster that you want to update the association in.
	//
	// This member is required.
	ClusterName *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string

	// Disable the automatic sessions tags that are appended by EKS Pod Identity.
	//
	// EKS Pod Identity adds a pre-defined set of session tags when it assumes the
	// role. You can use these tags to author a single role that can work across
	// resources by allowing access to Amazon Web Services resources based on matching
	// tags. By default, EKS Pod Identity attaches six tags, including tags for cluster
	// name, namespace, and service account name. For the list of tags added by EKS Pod
	// Identity, see [List of session tags added by EKS Pod Identity]in the Amazon EKS User Guide.
	//
	// Amazon Web Services compresses inline session policies, managed policy ARNs,
	// and session tags into a packed binary format that has a separate limit. If you
	// receive a PackedPolicyTooLarge error indicating the packed binary format has
	// exceeded the size limit, you can attempt to reduce the size by disabling the
	// session tags added by EKS Pod Identity.
	//
	// [List of session tags added by EKS Pod Identity]: https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags
	DisableSessionTags *bool

	// The new IAM role to change in the association.
	RoleArn *string

	// The Amazon Resource Name (ARN) of the target IAM role to associate with the
	// service account. This role is assumed by using the EKS Pod Identity association
	// role, then the credentials for this role are injected into the Pod.
	//
	// When you run applications on Amazon EKS, your application might need to access
	// Amazon Web Services resources from a different role that exists in the same or
	// different Amazon Web Services account. For example, your application running in
	// “Account A” might need to access resources, such as buckets in “Account B” or
	// within “Account A” itself. You can create a association to access Amazon Web
	// Services resources in “Account B” by creating two IAM roles: a role in “Account
	// A” and a role in “Account B” (which can be the same or different account), each
	// with the necessary trust and permission policies. After you provide these roles
	// in the IAM role and Target IAM role fields, EKS will perform role chaining to
	// ensure your application gets the required permissions. This means Role A will
	// assume Role B, allowing your Pods to securely access resources like S3 buckets
	// in the target account.
	TargetRoleArn *string

	noSmithyDocumentSerde
}

type UpdatePodIdentityAssociationOutput struct {

	// The full description of the association that was updated.
	Association *types.PodIdentityAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePodIdentityAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePodIdentityAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePodIdentityAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePodIdentityAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdatePodIdentityAssociationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePodIdentityAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePodIdentityAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdatePodIdentityAssociation struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdatePodIdentityAssociation) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdatePodIdentityAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdatePodIdentityAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdatePodIdentityAssociationInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdatePodIdentityAssociationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdatePodIdentityAssociation{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdatePodIdentityAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePodIdentityAssociation",
	}
}
