// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns Amazon Aurora and RDS database recommendations.
//
// Compute Optimizer generates recommendations for Amazon Aurora and RDS databases
// that meet a specific set of requirements. For more information, see the [Supported resources and requirements]in the
// Compute Optimizer User Guide.
//
// [Supported resources and requirements]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html
func (c *Client) GetRDSDatabaseRecommendations(ctx context.Context, params *GetRDSDatabaseRecommendationsInput, optFns ...func(*Options)) (*GetRDSDatabaseRecommendationsOutput, error) {
	if params == nil {
		params = &GetRDSDatabaseRecommendationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRDSDatabaseRecommendations", params, optFns, c.addOperationGetRDSDatabaseRecommendationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRDSDatabaseRecommendationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRDSDatabaseRecommendationsInput struct {

	//  Return the Amazon Aurora and RDS database recommendations to the specified
	// Amazon Web Services account IDs.
	//
	// If your account is the management account or the delegated administrator of an
	// organization, use this parameter to return the Amazon Aurora and RDS database
	// recommendations to specific member accounts.
	//
	// You can only specify one account ID per request.
	AccountIds []string

	//  An array of objects to specify a filter that returns a more specific list of
	// Amazon Aurora and RDS database recommendations.
	Filters []types.RDSDBRecommendationFilter

	// The maximum number of Amazon Aurora and RDS database recommendations to return
	// with a single request.
	//
	// To retrieve the remaining results, make another request with the returned
	// nextToken value.
	MaxResults *int32

	//  The token to advance to the next page of Amazon Aurora and RDS database
	// recommendations.
	NextToken *string

	// Describes the recommendation preferences to return in the response of a GetAutoScalingGroupRecommendations, GetEC2InstanceRecommendations, GetEC2RecommendationProjectedMetrics, GetRDSDatabaseRecommendations,
	// and GetRDSDatabaseRecommendationProjectedMetricsrequest.
	RecommendationPreferences *types.RecommendationPreferences

	//  The ARN that identifies the Amazon Aurora or RDS database.
	//
	// The following is the format of the ARN:
	//
	//     arn:aws:rds:{region}:{accountId}:db:{resourceName}
	//
	// The following is the format of a DB Cluster ARN:
	//
	//     arn:aws:rds:{region}:{accountId}:cluster:{resourceName}
	ResourceArns []string

	noSmithyDocumentSerde
}

type GetRDSDatabaseRecommendationsOutput struct {

	//  An array of objects that describe errors of the request.
	Errors []types.GetRecommendationError

	//  The token to advance to the next page of Amazon Aurora and RDS database
	// recommendations.
	NextToken *string

	//  An array of objects that describe the Amazon Aurora and RDS database
	// recommendations.
	RdsDBRecommendations []types.RDSDBRecommendation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRDSDatabaseRecommendationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetRDSDatabaseRecommendations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetRDSDatabaseRecommendations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRDSDatabaseRecommendations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRDSDatabaseRecommendations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRDSDatabaseRecommendations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRDSDatabaseRecommendations",
	}
}
