// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithysync "github.com/aws/smithy-go/sync"
	"sync"
)

// Queries a knowledge base and generates responses based on the retrieved
// results, with output in streaming format.
//
// The CLI doesn't support streaming operations in Amazon Bedrock, including
// InvokeModelWithResponseStream .
//
// This operation requires permission for the  bedrock:RetrieveAndGenerate action.
func (c *Client) RetrieveAndGenerateStream(ctx context.Context, params *RetrieveAndGenerateStreamInput, optFns ...func(*Options)) (*RetrieveAndGenerateStreamOutput, error) {
	if params == nil {
		params = &RetrieveAndGenerateStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RetrieveAndGenerateStream", params, optFns, c.addOperationRetrieveAndGenerateStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RetrieveAndGenerateStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RetrieveAndGenerateStreamInput struct {

	// Contains the query to be made to the knowledge base.
	//
	// This member is required.
	Input *types.RetrieveAndGenerateInput

	// Contains configurations for the knowledge base query and retrieval process. For
	// more information, see [Query configurations].
	//
	// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	RetrieveAndGenerateConfiguration *types.RetrieveAndGenerateConfiguration

	// Contains details about the session with the knowledge base.
	SessionConfiguration *types.RetrieveAndGenerateSessionConfiguration

	// The unique identifier of the session. When you first make a RetrieveAndGenerate
	// request, Amazon Bedrock automatically generates this value. You must reuse this
	// value for all subsequent requests in the same conversational session. This value
	// allows Amazon Bedrock to maintain context and knowledge from previous
	// interactions. You can't explicitly set the sessionId yourself.
	SessionId *string

	noSmithyDocumentSerde
}

type RetrieveAndGenerateStreamOutput struct {

	// The session ID.
	//
	// This member is required.
	SessionId *string

	eventStream *RetrieveAndGenerateStreamEventStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

// GetStream returns the type to interact with the event stream.
func (o *RetrieveAndGenerateStreamOutput) GetStream() *RetrieveAndGenerateStreamEventStream {
	return o.eventStream
}

func (c *Client) addOperationRetrieveAndGenerateStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRetrieveAndGenerateStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRetrieveAndGenerateStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RetrieveAndGenerateStream"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addEventStreamRetrieveAndGenerateStreamMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRetrieveAndGenerateStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRetrieveAndGenerateStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRetrieveAndGenerateStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RetrieveAndGenerateStream",
	}
}

// RetrieveAndGenerateStreamEventStream provides the event stream handling for the RetrieveAndGenerateStream operation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewRetrieveAndGenerateStreamEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type RetrieveAndGenerateStreamEventStream struct {
	// RetrieveAndGenerateStreamResponseOutputReader is the EventStream reader for the
	// RetrieveAndGenerateStreamResponseOutput events. This value is automatically set
	// by the SDK when the API call is made Use this member when unit testing your code
	// with the SDK to mock out the EventStream Reader.
	//
	// Must not be nil.
	Reader RetrieveAndGenerateStreamResponseOutputReader

	done      chan struct{}
	closeOnce sync.Once
	err       *smithysync.OnceErr
}

// NewRetrieveAndGenerateStreamEventStream initializes an RetrieveAndGenerateStreamEventStream.
// This function should only be used for testing and mocking the RetrieveAndGenerateStreamEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
func NewRetrieveAndGenerateStreamEventStream(optFns ...func(*RetrieveAndGenerateStreamEventStream)) *RetrieveAndGenerateStreamEventStream {
	es := &RetrieveAndGenerateStreamEventStream{
		done: make(chan struct{}),
		err:  smithysync.NewOnceErr(),
	}
	for _, fn := range optFns {
		fn(es)
	}
	return es
}

// Events returns a channel to read events from.
func (es *RetrieveAndGenerateStreamEventStream) Events() <-chan types.RetrieveAndGenerateStreamResponseOutput {
	return es.Reader.Events()
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer and reader, and no more events can be
// sent or received.
func (es *RetrieveAndGenerateStreamEventStream) Close() error {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *RetrieveAndGenerateStreamEventStream) safeClose() {
	close(es.done)

	es.Reader.Close()
}

// Err returns any error that occurred while reading or writing EventStream Events
// from the service API's response. Returns nil if there were no errors.
func (es *RetrieveAndGenerateStreamEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}

	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

func (es *RetrieveAndGenerateStreamEventStream) waitStreamClose() {
	type errorSet interface {
		ErrorSet() <-chan struct{}
	}

	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(errorSet); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()

	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()

	}
}
