// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Automated Reasoning policies in your account, with optional filtering
// by policy ARN. This helps you manage and discover existing policies.
func (c *Client) ListAutomatedReasoningPolicies(ctx context.Context, params *ListAutomatedReasoningPoliciesInput, optFns ...func(*Options)) (*ListAutomatedReasoningPoliciesOutput, error) {
	if params == nil {
		params = &ListAutomatedReasoningPoliciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomatedReasoningPolicies", params, optFns, c.addOperationListAutomatedReasoningPoliciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomatedReasoningPoliciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomatedReasoningPoliciesInput struct {

	// The maximum number of policies to return in a single call.
	MaxResults *int32

	// The pagination token from a previous request to retrieve the next page of
	// results.
	NextToken *string

	// Optional filter to list only the policy versions with the specified Amazon
	// Resource Name (ARN). If not provided, the DRAFT versions for all policies are
	// listed.
	PolicyArn *string

	noSmithyDocumentSerde
}

type ListAutomatedReasoningPoliciesOutput struct {

	// A list of Automated Reasoning policy summaries.
	//
	// This member is required.
	AutomatedReasoningPolicySummaries []types.AutomatedReasoningPolicySummary

	// The pagination token to use in a subsequent request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomatedReasoningPoliciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAutomatedReasoningPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAutomatedReasoningPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomatedReasoningPolicies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomatedReasoningPolicies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAutomatedReasoningPoliciesPaginatorOptions is the paginator options for
// ListAutomatedReasoningPolicies
type ListAutomatedReasoningPoliciesPaginatorOptions struct {
	// The maximum number of policies to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomatedReasoningPoliciesPaginator is a paginator for
// ListAutomatedReasoningPolicies
type ListAutomatedReasoningPoliciesPaginator struct {
	options   ListAutomatedReasoningPoliciesPaginatorOptions
	client    ListAutomatedReasoningPoliciesAPIClient
	params    *ListAutomatedReasoningPoliciesInput
	nextToken *string
	firstPage bool
}

// NewListAutomatedReasoningPoliciesPaginator returns a new
// ListAutomatedReasoningPoliciesPaginator
func NewListAutomatedReasoningPoliciesPaginator(client ListAutomatedReasoningPoliciesAPIClient, params *ListAutomatedReasoningPoliciesInput, optFns ...func(*ListAutomatedReasoningPoliciesPaginatorOptions)) *ListAutomatedReasoningPoliciesPaginator {
	if params == nil {
		params = &ListAutomatedReasoningPoliciesInput{}
	}

	options := ListAutomatedReasoningPoliciesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomatedReasoningPoliciesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomatedReasoningPoliciesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomatedReasoningPolicies page.
func (p *ListAutomatedReasoningPoliciesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomatedReasoningPoliciesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomatedReasoningPolicies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomatedReasoningPoliciesAPIClient is a client that implements the
// ListAutomatedReasoningPolicies operation.
type ListAutomatedReasoningPoliciesAPIClient interface {
	ListAutomatedReasoningPolicies(context.Context, *ListAutomatedReasoningPoliciesInput, ...func(*Options)) (*ListAutomatedReasoningPoliciesOutput, error)
}

var _ ListAutomatedReasoningPoliciesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomatedReasoningPolicies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomatedReasoningPolicies",
	}
}
