// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of restore access backup vaults associated with a specified
// backup vault.
func (c *Client) ListRestoreAccessBackupVaults(ctx context.Context, params *ListRestoreAccessBackupVaultsInput, optFns ...func(*Options)) (*ListRestoreAccessBackupVaultsOutput, error) {
	if params == nil {
		params = &ListRestoreAccessBackupVaultsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRestoreAccessBackupVaults", params, optFns, c.addOperationListRestoreAccessBackupVaultsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRestoreAccessBackupVaultsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRestoreAccessBackupVaultsInput struct {

	// The name of the backup vault for which to list associated restore access backup
	// vaults.
	//
	// This member is required.
	BackupVaultName *string

	// The maximum number of items to return in the response.
	MaxResults *int32

	// The pagination token from a previous request to retrieve the next set of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRestoreAccessBackupVaultsOutput struct {

	// The pagination token to use in a subsequent request to retrieve the next set of
	// results.
	NextToken *string

	// A list of restore access backup vaults associated with the specified backup
	// vault.
	RestoreAccessBackupVaults []types.RestoreAccessBackupVaultListMember

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRestoreAccessBackupVaultsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRestoreAccessBackupVaults{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRestoreAccessBackupVaults{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRestoreAccessBackupVaults"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRestoreAccessBackupVaultsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRestoreAccessBackupVaults(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListRestoreAccessBackupVaultsPaginatorOptions is the paginator options for
// ListRestoreAccessBackupVaults
type ListRestoreAccessBackupVaultsPaginatorOptions struct {
	// The maximum number of items to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRestoreAccessBackupVaultsPaginator is a paginator for
// ListRestoreAccessBackupVaults
type ListRestoreAccessBackupVaultsPaginator struct {
	options   ListRestoreAccessBackupVaultsPaginatorOptions
	client    ListRestoreAccessBackupVaultsAPIClient
	params    *ListRestoreAccessBackupVaultsInput
	nextToken *string
	firstPage bool
}

// NewListRestoreAccessBackupVaultsPaginator returns a new
// ListRestoreAccessBackupVaultsPaginator
func NewListRestoreAccessBackupVaultsPaginator(client ListRestoreAccessBackupVaultsAPIClient, params *ListRestoreAccessBackupVaultsInput, optFns ...func(*ListRestoreAccessBackupVaultsPaginatorOptions)) *ListRestoreAccessBackupVaultsPaginator {
	if params == nil {
		params = &ListRestoreAccessBackupVaultsInput{}
	}

	options := ListRestoreAccessBackupVaultsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRestoreAccessBackupVaultsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRestoreAccessBackupVaultsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRestoreAccessBackupVaults page.
func (p *ListRestoreAccessBackupVaultsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRestoreAccessBackupVaultsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRestoreAccessBackupVaults(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRestoreAccessBackupVaultsAPIClient is a client that implements the
// ListRestoreAccessBackupVaults operation.
type ListRestoreAccessBackupVaultsAPIClient interface {
	ListRestoreAccessBackupVaults(context.Context, *ListRestoreAccessBackupVaultsInput, ...func(*Options)) (*ListRestoreAccessBackupVaultsOutput, error)
}

var _ ListRestoreAccessBackupVaultsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRestoreAccessBackupVaults(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRestoreAccessBackupVaults",
	}
}
