# gereal

**gereal** is a serial terminal management tool around **GNU screen** and
**systemd generators**. It is designed to manage long-running serial console
sessions (for routers, switches, embedded devices, and similar hardware) in a
robust, reproducible, and comfortable way.

gereal is inspired by, and intended as a functional successor to, the
**cereal** tool by Daniel Kahn Gillmor. The name is a game on words, combining
cereal and generator.

## Overview

gereal provides:

* Declarative configuration of serial console sessions via YAML
* Automatic generation of systemd service units using a systemd generator
* Persistent background screen sessions per serial device
* Multiple attachment modes for users:
  * direct screen attachment
  * screen multiuser attachment
  * sudo-mediated attachment
* Optional per-session screen configuration
* Automatic start of serial sessions via systemd

The core idea is that **systemd owns the lifecycle**, while **screen owns the
terminal multiplexing**.

## Architecture

gereal consists of two main components:

1. **gereal generator**

   * A systemd generator
   * Reads the configuration file at boot or daemon-reload time
   * Generates one systemd service per configured serial session
   * Optionally enables sessions automatically via `multi-user.target`

2. **gerealctl control utility (`gerealctl`)**

   * User-facing command-line tool
   * Lists sessions
   * Attaches to running screen sessions using one of the
     available methods.
   * optionally Starts/stops/restarts sessions via systemd

No daemon process is kept running by gereal itself.

## Requirements

* Linux system with **systemd**
* **GNU screen**
* Python 3
* PyYAML
* (Optional) `sudo` for sudo-based attachment

## Configuration

gereal is configured via a YAML file, typically:

```
/etc/gereal/gereal.conf
```

### Structure

The configuration consists of two sections:

* `defaults`: default values applied to all sessions
* `sessions`: a list of serial session definitions

### Example

```yaml
defaults:
  baudrate: 115200
  user: _gereal
  group: dialout
  screenrc: /etc/gereal/screenrc

sessions:
  - name: ttyUSB0_115200
    device: /dev/ttyUSB0
    baudrate: 115200

  - name: ttyUSB0_9600
    device: /dev/ttyUSB0
    baudrate: 9600
```

### Session fields

Each session supports the following keys:

| Key        | Required | Description                         |
| ---------- | -------- | ----------------------------------- |
| `name`     | yes      | Logical session name                |
| `device`   | yes      | Serial device path                  |
| `baudrate` | yes      | Baud rate passed to screen          |
| `user`     | yes      | User the systemd service runs as    |
| `group`    | yes      | Group the systemd service runs as   |
| `screenrc` | no       | Path to screen configuration file   |
| `enable`   | no       | If true, session is enabled at boot |

Screen supports setting bit number, parity, stop bits and other parameters of
the serial connection, but configuring this is not well supported yet. Patches
appreciated.

### Per-session screenrc

If a file named:

```
/etc/gereal/screenrc-<session-name>
```

exists, it will automatically be used for that session instead of the global
`/etc/gereal/screenrc`. This is especially important when the screen multiuser
feature is used and session-specific ACLs are needed. Since screenrc does not
support includes, you need to copy the generic gereal screenrc to your
session-specific file. If you're not happy with the
`/etc/gereal/screenrc-<session-name>` name, you can define your own `screenrc`
path with the respective configuration option.

## Generated systemd units

For each session, the generator creates a service unit named

```
gereal-<session>.service
```

Each service:

* Runs `screen` detached
* Creates a named screen session: `gereal:<session>`
* Restarts automatically if it exits
* Runs under the configured user and group

Systemd controls startup, shutdown, restart, and status reporting.

## Logging

* screen logging is enabled via `-L`
* Output is written to screen’s default log location
* Session lifecycle events are logged via `logger` to syslog/journal

gereal itself does not currently provide cereal-style structured logging. To
improve this, patches are appreciated.

## Status

gereal is functional but still evolving. Interfaces and configuration formats
may change and expand.

Contributions, bug reports, and design feedback are welcome.

## Contributing

Bugs should be reported against the `gereal` package using the Debian BTS.

Development and source code are hosted at:

```
https://salsa.debian.org/debian/gereal
```


## License

Gereal itself is licensed under the GNU GPL Version 2 or later; while the
screenrc that was taken from cereal is licensed under GNU GPL Version 3 or
later.


