"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inPlaceRotateArray = void 0;
function reverseArr(arr, left, right) {
    while (left < right) {
        var temp = arr[left];
        arr[left] = arr[right];
        arr[right] = temp;
        left++;
        right--;
    }
    return arr;
}
function inPlaceRotateArray(arr, k) {
    const l = arr.length;
    if (!l)
        return;
    k = ((k % l) + l) % l;
    arr = reverseArr(arr, 0, l - 1);
    arr = reverseArr(arr, 0, k - 1);
    arr = reverseArr(arr, k, l - 1);
    return arr;
}
exports.inPlaceRotateArray = inPlaceRotateArray;
