"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffReadIndex = void 0;
const index_count_1 = require("../structs/index.count");
const off_size_1 = require("../structs/off-size");
const offset_1 = require("../structs/offset");
class CffReadIndex {
    constructor(readItem) {
        this.readItem = readItem;
    }
    read(view, context) {
        const count = view.next(index_count_1.CffIndexCount, context.version);
        const offSize = view.next(off_size_1.CffOffSize);
        const offsets = view.array(count + 1, offset_1.CffOffset, offSize);
        const vwData = view.liftRelative(0);
        const items = [];
        for (const [v, index] of vwData.repeat(count)) {
            const vwItem = vwData.lift(offsets[index]);
            items[index] = vwItem.next(this.readItem, context, offsets[index + 1] - offsets[index], index);
        }
        view.bytes(offsets[count]);
        return items;
    }
}
exports.CffReadIndex = CffReadIndex;
//# sourceMappingURL=read.js.map