import { IVec2 } from "../point/interface";
export interface Derivable<T> {
    eval(t: number): T;
    derivative(t: number): T;
}
export type Arc = Derivable<IVec2>;
export type DerivableFunction = Derivable<number>;
export interface ShapeTransform {
    x(x: number, y: number): number;
    y(x: number, y: number): number;
    dxx(x: number, y: number): number;
    dxy(x: number, y: number): number;
    dyx(x: number, y: number): number;
    dyy(x: number, y: number): number;
}
export type Contour = Arc[];
export type Shape = Arc[][];
