"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MathKernInfo = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const ImpLib = require("@ot-builder/common-impl");
const ot_layout_1 = require("@ot-builder/ot-layout");
const math_value_record_1 = require("../shared/math-value-record");
const MathKern = {
    read(bv) {
        const heightCount = bv.uint16();
        const correctionHeight = bv.array(heightCount, math_value_record_1.MathValueRecord);
        const kernValues = bv.array(heightCount + 1, math_value_record_1.MathValueRecord);
        return new ot_layout_1.Math.Kern(kernValues[heightCount], Array.from(ImpLib.Iterators.Zip(correctionHeight, kernValues.slice(0, heightCount))));
    },
    write(fr, x) {
        const correctionHeight = [];
        const kernValues = [];
        for (const [h, v] of x.corrections)
            correctionHeight.push(h), kernValues.push(v);
        kernValues.push(x.kernValue);
        fr.uint16(correctionHeight.length);
        fr.arrayN(math_value_record_1.MathValueRecord, correctionHeight.length, correctionHeight);
        fr.arrayN(math_value_record_1.MathValueRecord, correctionHeight.length + 1, kernValues);
    }
};
const Ptr16MathKernNullable = (0, bin_composite_types_1.NullablePtr16)(MathKern);
exports.MathKernInfo = {
    read(bv) {
        const topRight = bv.next(Ptr16MathKernNullable);
        const topLeft = bv.next(Ptr16MathKernNullable);
        const bottomRight = bv.next(Ptr16MathKernNullable);
        const bottomLeft = bv.next(Ptr16MathKernNullable);
        return new ot_layout_1.Math.KernInfo(topRight, topLeft, bottomRight, bottomLeft);
    },
    write(fr, ki) {
        fr.push(Ptr16MathKernNullable, ki.topRight);
        fr.push(Ptr16MathKernNullable, ki.topLeft);
        fr.push(Ptr16MathKernNullable, ki.bottomRight);
        fr.push(Ptr16MathKernNullable, ki.bottomLeft);
    }
};
//# sourceMappingURL=kern.js.map