/// <reference types="node" />
import { Data } from "@ot-builder/prelude";
import { Sized } from "./binary-view";
export interface Write<T, A extends unknown[] = []> {
    write(target: Frag, t: T, ...args: A): void;
}
export interface WriteOpt<T, A extends unknown[] = []> {
    writeOpt(t: T, ...args: A): Data.Maybe<Frag>;
}
export declare function Write<T, A extends unknown[] = []>(proc: (frag: Frag, t: T, ...args: A) => void): Write<T, A>;
export declare function WriteOpt<T, A extends unknown[] = []>(proc: (t: T, ...args: A) => Data.Maybe<Frag>): WriteOpt<T, A>;
export interface FragHole<T, A extends unknown[] = []> {
    fill(p: T, ...args: A): void;
}
export interface FragPointerEmbedding {
    readonly id: string;
    getOffset(enclosure: number, embed: number, to: number): number;
}
export declare namespace FragPointerEmbedding {
    const Absolute: FragPointerEmbedding;
    const Relative: FragPointerEmbedding;
    const EmbedRelative: FragPointerEmbedding;
}
interface FragPointerRecord {
    to: null | Frag;
    targetOffset: number;
    size: number;
    offset: number;
    createdOffset: number;
    embedding: FragPointerEmbedding;
}
export declare class Frag {
    private bw;
    pointers: FragPointerRecord[];
    get size(): number;
    push<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, obj: TW, ...args: AW): this;
    array<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, objects: readonly TW[], ...args: AW): this;
    arrayN<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, count: number, objects: readonly TW[], ...args: AW): this;
    arrayNF<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, count: number, objects: readonly (TW | undefined)[], fallback: TW, ...args: AW): this;
    reserve<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A> & Sized): FragHole<T, A>;
    bytes(buf: Buffer): this;
    uint8(x: number): this;
    uint16(x: number): this;
    uint32(x: number): this;
    int8(x: number): this;
    int16(x: number): this;
    int32(x: number): this;
    ptr16(to: null | Frag, embedding?: FragPointerEmbedding, targetOffset?: number): this;
    ptr32(to: null | Frag, embedding?: FragPointerEmbedding, targetOffset?: number): this;
    ptr16New(embedding?: FragPointerEmbedding): Frag;
    ptr32New(embedding?: FragPointerEmbedding): Frag;
    embed(frag: Frag): this;
    clone(): Frag;
    deepClone(): Frag;
    getDataBuffer(): Buffer;
    static pack(root: Frag): Buffer;
    static packMany(roots: ReadonlyArray<Frag>): {
        buffer: Buffer;
        rootOffsets: number[];
    };
    /** In-place consolidation */
    static consolidate(root: Frag): Frag;
    static from<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, t: TW, ...a: AW): Frag;
    static packFrom<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, t: TW, ...a: AW): Buffer;
    static solidFrom<T, A extends unknown[], TW extends T, AW extends A>(builder: Write<T, A>, t: TW, ...a: AW): Frag;
    static uint8(x: number): Frag;
    static uint16(x: number): Frag;
    static uint32(x: number): Frag;
    static int8(x: number): Frag;
    static int16(x: number): Frag;
    static int32(x: number): Frag;
    static ptr16(x: Frag, embedding?: FragPointerEmbedding): Frag;
    static ptr32(x: Frag, embedding?: FragPointerEmbedding): Frag;
}
export {};
//# sourceMappingURL=fragment.d.ts.map