/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/ErrorDialog.ui")]
class ErrorDialog : Adw.Dialog
{
  public string heading {get; construct;}
  public string details {get; construct;}

  public static void create(Gtk.Widget parent, string? msg1, string? msg2 = null)
  {
    if (msg2 == null)
      new ErrorDialog(null, msg1).present(parent);
    else
      new ErrorDialog(msg1, msg2).present(parent);
  }

  public ErrorDialog(string? heading, string? details = null)
  {
    Object(heading: heading, details: details);
  }

  [GtkChild]
  unowned Gtk.Label heading_label;
  [GtkChild]
  unowned Gtk.ScrolledWindow body_scroll;

  construct {
    heading_label.visible = heading != null;
    body_scroll.visible = details != null;
  }

  ~ErrorDialog()
  {
    debug("Finalizing ErrorDialog\n");
  }

  [GtkCallback]
  void on_close_clicked()
  {
    close();
  }
}
