# jsbook.perl by Masao Takaku <masao@ulis.ac.jp>
# copied from:
# jreport.perl by Kenshi Muto <kmuto@debian.org>
# report.perl by Ross Moore <ross@mpce.mq.edu.au>  09-14-97
#
# Extension to LaTeX2HTML V97.1 to support the "report" document class
# and standard LaTeX2e class options.
#
# Change Log:
# ===========

package main;


# Suppress option-warning messages:
sub do_jsbook_a4paper{}
sub do_jsbook_a5paper{}
sub do_jsbook_a6paper{}
sub do_jsbook_b4paper{}
sub do_jsbook_b5paper{}
sub do_jsbook_a4j{}
sub do_jsbook_a5j{}
sub do_jsbook_b4j{}
sub do_jsbook_b5j{}
sub do_jsbook_b5var{}
sub do_jsbook_letterpaper{}
sub do_jsbook_legalpaper{}
sub do_jsbook_executivepaper{}
sub do_jsbook_landscape{}
sub do_jsbook_tombo{}
sub do_jsbook_mentuke{}
sub do_jsbook_oneside{}
sub do_jsbook_twoside{}
sub do_jsbook_onecolumn{}
sub do_jsbook_twocolumn{}
sub do_jsbook_notitlepage{}
sub do_jsbook_titlepage{}
sub do_jsbook_openright{}
sub do_jsbook_openany{}
sub do_jsbook_final{}
sub do_jsbook_draft{}
sub do_jsbook_disablejfam{}
sub do_jsbook_mingoth{}
sub do_jsbook_papersize{}
sub do_jsbook_openbib{}

sub do_jsbook_9pt{ $LATEX_FONT_SIZE = '9pt' unless $LATEX_FONT_SIZE; }
sub do_jsbook_10pt{ $LATEX_FONT_SIZE = '10pt' unless $LATEX_FONT_SIZE; }
sub do_jsbook_11pt{ $LATEX_FONT_SIZE = '11pt' unless $LATEX_FONT_SIZE; }
sub do_jsbook_12pt{ $LATEX_FONT_SIZE = '12pt' unless $LATEX_FONT_SIZE; }
sub do_jsbook_14pt{ $LATEX_FONT_SIZE = '14pt' unless $LATEX_FONT_SIZE; }
sub do_jsbook_17pt{ $LATEX_FONT_SIZE = '17pt' unless $LATEX_FONT_SIZE; }
sub do_jsbook_21pt{ $LATEX_FONT_SIZE = '21pt' unless $LATEX_FONT_SIZE; }

sub do_jsbook_leqno{ $EQN_TAGS = 'L'; }
sub do_jsbook_reqno{ $EQN_TAGS = 'R'; }
sub do_jsbook_fleqn{ $FLUSH_EQN = 1; }

sub do_cmd_thepart {
    join('', &do_cmd_Roman("${O}0${C}part${O}0$C"), ".", @_[0]) }

sub do_cmd_thechapter {
    join('', &do_cmd_arabic("${O}0${C}chapter${O}0$C"), ".", @_[0]) }

sub do_cmd_thesection {
    join('',&translate_commands("\\thechapter")
	, &do_cmd_arabic("${O}0${C}section${O}0$C"), @_[0]) }

sub do_cmd_thesubsection {
    join('',&translate_commands("\\thesection")
	,"." , &do_cmd_arabic("${O}0${C}subsection${O}0$C"), @_[0]) }

sub do_cmd_thesubsubsection {
    join('',&translate_commands("\\thesubsection")
	,"." , &do_cmd_arabic("${O}0${C}subsubsection${O}0$C"), @_[0]) }

sub do_cmd_theparagraph {
    join('',&translate_commands("\\thesubsubsection")
	,"." , &do_cmd_arabic("${O}0${C}paragraph${O}0$C"), @_[0]) }

sub do_cmd_thesubparagraph {
    join('',&translate_commands("\\theparagraph")
	,"." , &do_cmd_arabic("${O}0${C}subparagraph${O}0$C"), @_[0]) }

&addto_dependents('chapter','equation');
&addto_dependents('chapter','footnote');
&addto_dependents('chapter','figure');
&addto_dependents('chapter','table');

sub do_cmd_theequation {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}equation${O}0$C"), @_[0]) }

sub do_cmd_thefootnote {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}footnote${O}0$C"), @_[0]) }

sub do_cmd_thefigure {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}figure${O}0$C"), @_[0]) }

sub do_cmd_thetable {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}table${O}0$C"), @_[0]) }

1;	# Must be last line
