!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_ad_galerkin_DD_test2d
!
!      ӥաݥ顼ˡ
!      ξüǥꥯ춭ѥ⥸塼ƥȥץ(2)
!          f(:,x=xmin)=f(:,x=xmax)=0
!
!      1 : f(x) = sin(pi*x),    0<x<1
!      2 : f(x) = sin(2*pi*x),  0<x<1
!
!  2005/12/30  ݹ  
!      2006/01/23  ݹ  ⥸塼̾ѹȼ
!
program at_ad_galerkin_DD_test2d

  use at_ad_galerkin_DD
  use at_module

  implicit none

  integer, parameter :: jm=2                   ! 1 ܳʻ
  integer, parameter :: im=32                  ! ʻ              
  integer, parameter :: km=32                  ! ӥȿ  
  integer, parameter :: ks=2                   ! 顼㼡
  real(8), parameter :: xmin=0.0, xmax=1.0     ! ׻ΰ

  real(8) :: ag_data(jm,0:im)
  real(8) :: ag_data_orig(jm,0:im)

  real(8) :: ad_data(jm,ks:km)

  real(8) :: pi

  pi = atan(1.0D0)*4.0D0

  call at_Initial(im,km,xmin,xmax)
  call at_ad_galerkin_DD_Initial(im,km)           !--- ξüǥꥯ ---

  ag_data(1,:) = sin(pi*g_X)
  ag_data(2,:) = sin(2*pi*g_X)
  ag_data_orig = ag_data

  ad_data = ad_ag(ag_data)
  ag_data = ag_ad(ad_data)

  write(6,*) 
  write(6,*) '*** Max. Error of Grid -> Galerkin -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'sin (pi*X)   :', maxval(abs(ag_data_orig(1,:)-ag_data(1,:)))
  write(6,*) 'sin (2*pi*X) :', maxval(abs(ag_data_orig(2,:)-ag_data(2,:)))

!  
!  ag_data = ag_ad(ad_Dx_ad(ad_Dx_ad(ad_data)))

!  褤 : ʬͤϥӥշݻ٤
  ad_data = ad_at(at_Dx_at(at_Dx_at(at_ad(ad_data))))
  ag_data = ag_ad(ad_data)

  write(6,*) 
  write(6,*) '*** Max. Error of of Grid -> Galerkin -> (Dx)^2 -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'sin (pi*X)   :', &
       maxval(abs(-pi**2 * ag_data_orig(1,:)-ag_data(1,:)))
  write(6,*) 'sin (2*pi*X) :', &
       maxval(abs(-4*pi**2*ag_data_orig(2,:)-ag_data(2,:)))

end program at_ad_galerkin_DD_test2d
