!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_aq_galerkin_RR_test1d
!
!      ӥաݥ顼ˡƥȥץ(2)
!      󰵽ήΤήؿήݥƥ󥷥, ξüǴ
!      (ξüͤ 1 ʬ 0)
!
!        f(:,i=0)=f(:,i=im)=f'(:,i=0)=f'(:,i=im)=0 
!        [ f(:,x=xmax)=f(:,x=xmin)=f'(:,x=xmax)=0=f'(:,x=xmin)=0 ]
!
!       : f(x) = cosh(alpha)*cos(lambda*t) - cos(lambda)*cosh(alpha*t)
!              t=(xmax+xmin)/2 + (xmax-xmin)/2 * t
!              lambda * tan(lambda) = -alpha * tanh(alpha)
!
!  2006/01/05  ݹ  
!      2006/01/24  ݹ  ⥸塼ѹȼ
!
program at_aq_galerkin_RR_test2d

  use at_aq_galerkin_RRSS
  use at_module
  use dc_message

  implicit none

  integer, parameter :: jm=5                   ! 1 ܳʻ
  integer, parameter :: im=32                  ! ʻ              
  integer, parameter :: km=32                  ! ӥȿ  
  integer, parameter :: ks=4                   ! 顼㼡
  real(8), parameter :: xmin=0.0, xmax=1.0     ! ׻ΰ

  real(8), parameter :: nu=2.0D0            ! ﷸ

  real(8) :: ag_data(jm,0:im)
  real(8) :: ag_data_orig(jm,0:im)

  real(8) :: aq_data(jm,ks:km)

  real(8) :: g_Tau(0:im)

  real(8) :: lambda(jm)                          ! ϲ򷸿
  integer :: j

  lambda = InvXtanX(-nu*tanh(nu),jm)
!!$  write(6,*) lambda

  call at_Initial(im,km,xmin,xmax)
  call at_aq_galerkin_RRSS_Initial(im,km,'RR')   ! --- ξüǴ ---

  g_Tau = 2.0D0/(xmax-xmin)*(g_X-(xmax+xmin)/2.0D0)
  do j=1,jm
     ag_data(j,:) = cosh(nu)*cos(lambda(j)*g_Tau) &
                   - cos(lambda(j))*cosh(nu*g_Tau)
  enddo
  ag_data_orig = ag_data

  aq_data = aq_ag(ag_data)
  ag_data = ag_aq(aq_data)

  write(6,*) 
  write(6,*) '*** Max. Error of Grid -> Galerkin -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'j, error of cos (lambda(j)*t) -cosh(alhpa*t) :'
  do j=1,jm
     write(6,*) j, maxval(abs(ag_data_orig(j,:)-ag_data(j,:)))
  enddo

contains
  !
  ! x*tan(x)=val β
  !
  function InvXtanX(val,n)
    real(8), intent(IN) :: val                ! x*tan(x)=val < 0
    integer, intent(IN) :: n                  ! θĿ
    real(8)             :: InvXtanX(n)
    real(8), parameter  :: eps = 1.0D-14     ! 

    real(8) :: PI
    integer :: i
    real(8) :: xs, xl, xm
    real(8) :: ValS, ValL, ValM

    PI = atan(1.0D0)*4.0D0

    do i=1,n
       xs=-PI/2.0D0  + i*PI + eps
       xl=i*PI

       ValS = xs*tan(xs)-val ; ValL = xl*tan(xl)-val
!!$       write(6,*) 'vals, vall',vals, vall
       if ( ValS * ValL .GT. 0.0D0 ) &
            call MessageNotify('E','InvXtanX',&
            'Initial values of ValS and ValL are the same sign.')
1000   xm = (xs + xl)/2.0
       ValM = xm*tan(xm) - val

       if ( ValS * ValM .GT. 0.0D0 ) then
          xs = xm ; ValS=xs*tan(xs)-val
       else
          xl = xm ; ValL=xl*tan(xl)-val
       endif

       if ( abs(xl-xs) .lt. eps ) then
          InvXtanX(i) = xm
          goto 99
       endif

       goto 1000

99  end do
  end function InvXtanX

end program at_aq_galerkin_RR_test2d
