--- src/cgelss.f	Thu Dec  5 20:18:06 2002
+++ debian/updates/src/cgelss.f	Wed Dec  4 15:23:42 2002
@@ -4,7 +4,7 @@
 *  -- LAPACK driver routine (version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     April 25, 2001 
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -87,10 +87,9 @@
 *          LWORK >=  2*min(M,N) + max(M,N,NRHS)
 *          For good performance, LWORK should generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  RWORK   (workspace) REAL array, dimension (5*min(M,N))
 *
@@ -164,7 +163,7 @@
 *       immediately following subroutine, as returned by ILAENV.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = 0
          MM = M
          IF( M.GE.N .AND. M.GE.MNTHR ) THEN
@@ -235,19 +234,18 @@
          MINWRK = MAX( MINWRK, 1 )
          MAXWRK = MAX( MINWRK, MAXWRK )
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY )
+     $      INFO = -12
       END IF
 *
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY )
-     $   INFO = -12
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'CGELSS', -INFO )
          RETURN
       ELSE IF( LQUERY ) THEN
          RETURN
       END IF
-*
-*     Quick return if possible
-*
       IF( M.EQ.0 .OR. N.EQ.0 ) THEN
          RANK = 0
          RETURN
@@ -512,8 +510,8 @@
             DO 40 I = 1, NRHS, CHUNK
                BL = MIN( NRHS-I+1, CHUNK )
                CALL CGEMM( 'C', 'N', M, BL, M, CONE, WORK( IL ), LDWORK,
-     $                     B( 1, I ), LDB, CZERO, WORK( IWORK ), N )
-               CALL CLACPY( 'G', M, BL, WORK( IWORK ), N, B( 1, I ),
+     $                     B( 1, I ), LDB, CZERO, WORK( IWORK ), M )
+               CALL CLACPY( 'G', M, BL, WORK( IWORK ), M, B( 1, I ),
      $                      LDB )
    40       CONTINUE
          ELSE
