--- src/cgees.f	Thu Dec  5 20:18:05 2002
+++ debian/updates/src/cgees.f	Wed Dec  4 15:23:42 2002
@@ -5,6 +5,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVS, SORT
@@ -89,10 +90,9 @@
 *          The dimension of the array WORK.  LWORK >= max(1,2*N).
 *          For good performance, LWORK must generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  RWORK   (workspace) REAL array, dimension (N)
 *
@@ -120,11 +120,13 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       REAL               ZERO, ONE
       PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
 *     ..
 *     .. Local Scalars ..
-      LOGICAL            LQUERY, SCALEA, WANTST, WANTVS
+      LOGICAL            SCALEA, WANTST, WANTVS
       INTEGER            HSWORK, I, IBAL, ICOND, IERR, IEVAL, IHI, ILO,
      $                   ITAU, IWRK, K, MAXB, MAXWRK, MINWRK
       REAL               ANRM, BIGNUM, CSCALE, EPS, S, SEP, SMLNUM
@@ -150,7 +152,6 @@
 *     Test the input arguments
 *
       INFO = 0
-      LQUERY = ( LWORK.EQ.-1 )
       WANTVS = LSAME( JOBVS, 'V' )
       WANTST = LSAME( SORT, 'S' )
       IF( ( .NOT.WANTVS ) .AND. ( .NOT.LSAME( JOBVS, 'N' ) ) ) THEN
@@ -177,7 +178,7 @@
 *       the worst case.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = N + N*ILAENV( 1, 'CGEHRD', ' ', N, 1, N, 0 )
          MINWRK = MAX( 1, 2*N )
          IF( .NOT.WANTVS ) THEN
@@ -196,19 +197,17 @@
             MAXWRK = MAX( MAXWRK, HSWORK, 1 )
          END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -12
       END IF
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY ) THEN
-         INFO = -12
-      END IF
+*
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'CGEES ', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
