!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
! histcopy.f90 - Sample program for gt4_history/gt4f90io.
!                Test Program for "HistoryCopyVariable".
!
! History
!   2004/08/02 Morikawa Yasuhiro     create

program histcopy
    use gt4f90io
    use dc_trace, only: SetDebug
    use gt4_history
implicit none
    integer            :: i,j,k,l                        ! ѿ
    integer, parameter :: nx=10, ny=20, nz=30            ! åɿ
    real,    parameter :: x(nx)=(/(1.0*(i-1),i=1,nx)/)   ! xɸѿ
    real(8), parameter :: y(ny)=(/(10.0*(i-1),i=1,ny)/)  ! yɸѿ
    real(8), parameter :: z(nz)=(/(100.0*(i-1),i=1,nz)/) ! zɸѿ

    real               :: u           ! ̵ѿ
    real(8)            :: v(nx)       !  1 ѿ
    real               :: w(nx,ny)    !  2 ѿ
    real(8)            :: q(nx,ny,nz) !  3 ѿ

continue

    call SetDebug

    !-----------------------------------------------------------------
    ! ޤϥԡȤʤե
    !-----------------------------------------------------------------
    call HistoryCreate(file='xhistcopy/xhistcopy1.nc', &
        & title='gt4_history HistoryCopyVariable test 1', &
        & source='gt4f90io/Fortran library test kit', &
        & institution='GFD Dennou Club', &
        & dims=(/'x','y','z','t'/), &
        & dimsizes=(/10,20,30,0/), &
        & longnames=(/'X-coordinate','Y-coordinate', &
                   &  'Z-coordinate','time        '/), &
        & units=(/'m','m','m','s'/), &
        & origin=0.0, interval=0.2, &
        & xtypes=(/'real  ','double','double','real  '/))

    call HistoryPut('x',x)   ! ѿ
    call HistoryPut('y',y)   ! ѿ
    call HistoryPut('z',z)   ! ѿ

    !----- ѿ -----
    call HistoryAddVariable('u', dims=(/'t'/), &
        & longname='Non Dimensional any quantity', &
        & units='non-dimensional')
    call HistoryAddVariable('v', dims=(/'x','t'/), &
        & longname='1 Dimensional any quantity', &
        & units='1-dimensional any unit', xtype='double')
    call HistoryAddVariable('w', dims=(/'x','y','t'/), &
        & longname='2 Dimensional any quantity', &
        & units='2-dimensional any unit')
    call HistoryAddVariable('q', dims=(/'x','y','z','t'/), &
        & longname='3 Dimensional any quantity', &
        & units='3-dimensional any unit', xtype='double')

    !----- ѿ°ղ -----
    ! ѿؤ°ղ
    call HistoryAddAttr('u', 'scale_factor',  100.0)
    call HistoryAddAttr('v', 'add_offset',    1000.0)
    call HistoryAddAttr('w', 'missing_value', -2.0e20)
    call HistoryAddAttr('q', 'valid_range', (/-1.0e30, 1.0e30/))

    !-----  -----
    do, l = 1, 24
       u = real(l)*0.01
        do i = 1, 10
           v(i) = dble(l)*0.01d0+dble(i)*1.0d0
           do j = 1, 20
              w(i,j) = real(l)*0.01+real(i)*1.0+real(j)*100.0
              do k = 1, 30
                 q(i,j,k) = dble(l)*0.01d0 + dble(i)*1.0d0 &
                            & + dble(j)*100.0d0+dble(k)*10000.0d0
              enddo
           enddo
        enddo
        ! ֤ŪͿ
        call HistoryPut('t', real(l)*0.2)
        call HistoryPut('u', u)
        call HistoryPut('v', v)
        call HistoryPut('w', w)
        call HistoryPut('q', q)
    enddo
    call HistoryClose

    !-----------------------------------------------------------------
    !  ǧƥ
    !    1) HistoryCreate ϴŪ˾Ʊ
    !    2) ѹϰʲ2
    !       a) ֤μѿ "t"  "time" 
    !       b) ľɸμѿ "z"  "Z" 
    !    κۤϡHistoryCopyVariable Ǥ̵뤵ͤ
    !    ʤäƤ롣
    !-----------------------------------------------------------------

    call HistoryCreate(file='xhistcopy/xhistcopy2.nc', &
        & title='gt4_history HistoryCopyVariable test 1', &
        & source='gt4f90io/Fortran library test kit', &
        & institution='GFD Dennou Club', &
        & dims=(/'x   ','y   ','Z   ','time'/), & ! 虜 t  time ѹ
        & dimsizes=(/10,20,30,0/), &
        & longnames=(/'X-coordinate','Y-coordinate', &
                   &  'Z-coordinate','time        '/), &
        & units=(/'m','m','m','s'/), &
        & origin=0.0, interval=0.2, &
        & xtypes=(/'real  ','double','double','real  '/))

    call HistoryPut('x',x)   ! ѿ
    call HistoryPut('y',y)   ! ѿ
    call HistoryPut('Z',z)   ! ѿ

    !----- ѿԡ -----
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'u')
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'v')
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'w')
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'q')

    !----- եλƱͤʷ׻롼 -----
    do, l = 1, 24
       u = real(l)*0.01
        do i = 1, 10
           v(i) = dble(l)*0.01d0+dble(i)*1.0d0
           do j = 1, 20
              w(i,j) = real(l)*0.01+real(i)*1.0+real(j)*100.0
              do k = 1, 30
                 q(i,j,k) = dble(l)*0.01d0 + dble(i)*1.0d0 &
                            & + dble(j)*100.0d0+dble(k)*10000.0d0
              enddo
           enddo
        enddo
        ! ֤ŪͿ
        call HistoryPut('time', real(l)*0.2)
        call HistoryPut('u', u)
        call HistoryPut('v', v)
        call HistoryPut('w', w)
        call HistoryPut('q', q)
    enddo

    call HistoryClose

    !-----------------------------------------------------------------
    !  μưƥ
    !    1) HistoryCreate ǻꤹ뼡ϻ֤Τߡ
    !       ּͤ HistoryCopyVariable 
    !       ѿ˱ƹԤʤ롣
    !    2) ּΤ HistoryPut ϹԤʤʤ
    !       HistoryCopyVariable ǼưŪ˥ԡ롣
    !    3) ּΤ HistoryPut ϹԤʤʤ
    !       ѿ HistoryPut ˱ƼưŪ˺롣
    !-----------------------------------------------------------------

    call HistoryCreate(file='xhistcopy/xhistcopy3.nc', &
        & title='gt4_history HistoryCopyVariable test 1', &
        & source='gt4f90io/Fortran library test kit', &
        & institution='GFD Dennou Club', &
        & dims=(/'t'/), &
        & dimsizes=(/0/), &
        & longnames=(/'time'/), &
        & units=(/'s'/), &
        & origin=0.0, interval=0.2, &
        & xtypes=(/'real'/))

    !----- ѿԡ -----
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'u')
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'v')
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'w')
    call HistoryCopyVariable('xhistcopy/xhistcopy1.nc', 'q')

    !----- եλƱͤʷ׻롼 -----
    do, l = 1, 24
       u = real(l)*0.01
        do i = 1, 10
           v(i) = dble(l)*0.01d0+dble(i)*1.0d0
           do j = 1, 20
              w(i,j) = real(l)*0.01+real(i)*1.0+real(j)*100.0
              do k = 1, 30
                 q(i,j,k) = dble(l)*0.01d0 + dble(i)*1.0d0 &
                            & + dble(j)*100.0d0+dble(k)*10000.0d0
              enddo
           enddo
        enddo
        ! ֤ŪˤͿʤ
        !   HistoryCreate  origin  interval ˰¸
        call HistoryPut('u', u)
        call HistoryPut('v', v)
        call HistoryPut('w', w)
        call HistoryPut('q', q)
    enddo

    call HistoryClose

end program histcopy
