! Sample program for gt4_history/gt4f90io              2001/02/27 S.Takehiro
! 
! Solving diffusion equation 
!     du/dt = kappa d^2 u/dx^2
! for giving values of u at x=0 and 1. 
!
program diffusion

  integer, parameter              :: nx=30                   ! åɿ
  integer, parameter              :: nt=200                  ! ֥ƥå׿
  integer, parameter              :: ndisp=10                ! ϴֳ
  double precision, parameter     :: dx=1.0/(nx-1)           ! åɴֳ
  double precision, parameter     :: dt=0.0005               ! ֳִ
  double precision, dimension(nx) :: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  double precision, dimension(nx) :: temp                    ! 
  double precision, parameter     :: kappa=1.0               ! ǮȻ

  temp = exp(-((x-0.5)/0.1)**2)                              ! 

  do it=1,nt
     temp(2:nx-1) = temp(2:nx-1) &                           ! ʬ
          +kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

     if ( mod(nt,ndisp) .eq. 0 ) then
        write(6,*)it*dt                                      ! ѿ
        write(6,*)temp                                       ! ѿ
     endif
  enddo

  stop
end program diffusion
