#!/usr/bin/env ruby
#
#== Recursive sed for netCDF file
#
#Authors::   Yasuhiro MORIKAWA
#Version::   $Id: nc_rsed.rb,v 1.1 2006/01/15 19:25:03 morikawa Exp $
#Tag Name::  $Name: gt4f90io-20060818 $
#Copyright:: Copyright (C) GFD Dennou Club, 2005. All rights reserved.
#License::   See link:../COPYRIGHT
#
#ʣ netCDF եФ sed 򤫤٤ Ruby ץȤǤ.
#
#ñ ncdump  sed  ncgen ȤʪǤ.
#
#== USAGE
USAGE = "
      nc_rsed.rb оʸ ѹʸ  nc_files [nc_file...]"

#
#
############################################################
## config part

NCDUMP = "/usr/bin/env ncdump"
NCGEN  = "/usr/bin/env ncgen"

## config part end
############################################################

## required libraries

require 'kconv'
require "optparse"

## options are parsed

opt = OptionParser.new
OPTS = {}
ARGV.options{|opt|

  opt.summary_width = 23
  opt.summary_indent = ' '*6

  opt.on('-n', '--dry-run',
                             "ºݤˤִԤ鷺ִʸ
                              ɽޤ.\n"
         ){|v| OPTS[:dryrun] = v}

  opt.on_tail('-h', '-H', '--help', 
                             "ܺ٤ʥإפϤޤ.\n"
              ){|v| OPTS[:help] = v}

  opt.parse!
}

## main part

if ARGV.size < 3 || OPTS[:help] then
  print <<-"EOF"

  nc_rsed.rb:

    USAGE: #{USAGE}

    OPTION: \n#{opt.to_a[1..-1].join("")}
    VERSION: 
      Version: $Id: nc_rsed.rb,v 1.1 2006/01/15 19:25:03 morikawa Exp $

  EOF
  exit 1
end

# 1 ܤǤѥȤƼФ
#   - ɤ߹ʸϤȤꤢ euc Ѵ
from = /#{Kconv::toeuc(ARGV.shift)}/e

# 2 ܤǤϤΤޤʸȤƼФ
to   = Kconv::toeuc(ARGV.shift)

# ޥɤΥå
if !system(NCDUMP)
  raise ArgumentError, "\n\n  Error : \"#{NCDUMP}\" is not found.\n\n"
end

ncgen_test_input = <<-'EOF'
netcdf foo {  // an example netCDF specification in CDL

dimensions:
     lat = 10, lon = 5, time = unlimited ;

variables:
     long    lat(lat), lon(lon), time(time);
     float   Z(time,lat,lon), t(time,lat,lon);
     double  p(time,lat,lon);
     long    rh(time,lat,lon);

     // variable attributes
     lat:long_name = "latitude";
     lat:units = "degrees_north";
     lon:long_name = "longitude";
     lon:units = "degrees_east";
     time:units = "seconds since 1992-1-1 00:00:00";
     Z:units = "geopotential meters";
     Z:valid_range = 0., 5000.;
     p:_FillValue = -9999.;
     rh:_FillValue = -1;

data:
     lat   = 0, 10, 20, 30, 40, 50, 60, 70, 80, 90;
     lon   = -140, -118, -96, -84, -52;
}
EOF

ncgen_check = "echo '" + ncgen_test_input + "' | " + NCGEN + " - "

if !system(ncgen_check)
  raise ArgumentError, "\n\n  Error : \"#{NCGEN}\" is not found.\n\n"
end

# Ĥΰϥե̾Ȥƽե뤬¸ߤ
#  netCDF ե뤫å롣
ARGV.each{|file|
  if !File.exist?(file)
    raise ArgumentError, "\n\n  Error : \"#{file}\" is not found.\n\n"
  end
  ncfile_check = NCDUMP + " #{file} &> /dev/null"
  if !system(ncfile_check)
    raise ArgumentError, "\n\n  Error : \"#{file}\" is not a netCDF file.\n\n"
  end
}

# ƥե˴ؤ sed 򤫤. ncdump  cdl ե,
# ΥեȤ sed , Ƥ ncgen Ǹ᤹.
ARGV.each{|file|
  ncdump_cmd = "#{NCDUMP} #{file}"
  cdl_string = IO.popen(ncdump_cmd).read
  modified_flag = false
  line_num = 0
  print file
  print "\n"
  print " +===========+\n"
  cdl_lines = cdl_string.split("\n")
  cdl_lines.collect!{ |line|
    line_num += 1
    next line if line == line.gsub(from, to)
    modified_flag = true
    print " |", line_num, ": --- ", line, "\n"
    print " |", line_num, ": +++ ", line.gsub(from, to), "\n"
    line.gsub(from, to)
  }
  print " +------------------------------------------+\n"
  new_cdl_string = cdl_lines.join("\n")

  next if !modified_flag

  ncgen_cmd = "echo '" + new_cdl_string + "' | " + NCGEN + " - -o #{file}"

  system(ncgen_cmd) if !OPTS[:dryrun]
}
