#include "string_.h"
#include "ghost.h"
#include "alloc.h"
#include "dict.h"
#include "dstack.h"

/* ver 1.1  21-Aug-1993 by kura@nacsis.ac.jp (kura@mmp.cl.nec.co.jp) */

/* If you want to compile with ghostscript-2.4.1, #define gs241 */

private ref name_PAGESIZE;
private int initialized;

private char *gdev_ext_default_size = NULL;
int gdev_ext_paper_width = 0;
int gdev_ext_paper_height = 0;

struct paper_format {
	char	*name;
	int	width;	/* width * 10 */
	int	height;	/* height * 10 */
};

struct paper_format paper_formats[] = {
	{ "b4", 101, 143 },
	{ "a4", 82, 117 },
	{ "b5", 71, 101 },
	{ "a5", 58, 82 },
	{ "a6", 41, 58 },
};

#define paper_format_num	(sizeof(paper_formats)/sizeof(*paper_formats))

char*
gdev_ext_default_paper_size()
{
	ref *pPAGESIZE;
	int i;
	char *psize;
	int plen;

	if (initialized)
		return gdev_ext_default_size;

	initialized = 1;
	name_enter("PAGESIZE", &name_PAGESIZE);

#ifdef gs241
	if (dict_find(&systemdict, &name_PAGESIZE, &pPAGESIZE) <= 0)
#else
	if (dict_find(systemdict, &name_PAGESIZE, &pPAGESIZE) <= 0)
#endif
		return NULL;
	if (!r_has_type(pPAGESIZE, t_string))
		return NULL;
	psize = (char*) pPAGESIZE->value.bytes;
	plen = r_size(pPAGESIZE);
	for (i = 0; i < paper_format_num; i ++) {
		if (strlen(paper_formats[i].name) == plen
		 && !strncmp(paper_formats[i].name, psize, plen)) {
			gdev_ext_paper_height = paper_formats[i].height;
			gdev_ext_paper_width = paper_formats[i].width;
			return gdev_ext_default_size = paper_formats[i].name;
		}
	}
	return NULL;
}

char*
gdev_ext_paper_size()
{
	ref *pPAGESIZE;
	int i;
	char *psize;
	int plen;

	gdev_ext_default_paper_size();

#ifdef gs241
	if (dict_find(&userdict, &name_PAGESIZE, &pPAGESIZE) <= 0)
#else
	if (dict_find(userdict, &name_PAGESIZE, &pPAGESIZE) <= 0)
#endif
		return NULL;
	if (!r_has_type(pPAGESIZE, t_string))
		return NULL;
	psize = (char*) pPAGESIZE->value.bytes;
	plen = r_size(pPAGESIZE);
	for (i = 0; i < paper_format_num; i ++) {
		if (strlen(paper_formats[i].name) == plen
		 && !strncmp(paper_formats[i].name, psize, plen)) {
			gdev_ext_paper_height = paper_formats[i].height;
			gdev_ext_paper_width = paper_formats[i].width;
			return paper_formats[i].name;
		}
	}
	return NULL;
}
