/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AutowireUtils {
    AutowireUtils() {
    }

    public static void sortConstructors(Constructor[] constructors) {
        Arrays.sort(constructors, new Comparator<Constructor>(){

            @Override
            public int compare(Constructor c1, Constructor c2) {
                boolean p2;
                boolean p1 = Modifier.isPublic(c1.getModifiers());
                if (p1 != (p2 = Modifier.isPublic(c2.getModifiers()))) {
                    return p1 ? -1 : 1;
                }
                int c1pl = c1.getParameterTypes().length;
                int c2pl = c2.getParameterTypes().length;
                return new Integer(c1pl).compareTo(c2pl) * -1;
            }
        });
    }

    public static void sortFactoryMethods(Method[] factoryMethods) {
        Arrays.sort(factoryMethods, new Comparator<Method>(){

            @Override
            public int compare(Method fm1, Method fm2) {
                boolean p2;
                boolean p1 = Modifier.isPublic(fm1.getModifiers());
                if (p1 != (p2 = Modifier.isPublic(fm2.getModifiers()))) {
                    return p1 ? -1 : 1;
                }
                int c1pl = fm1.getParameterTypes().length;
                int c2pl = fm2.getParameterTypes().length;
                return new Integer(c1pl).compareTo(c2pl) * -1;
            }
        });
    }

    public static boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        Method wm = pd.getWriteMethod();
        if (wm == null) {
            return false;
        }
        if (!wm.getDeclaringClass().getName().contains("$$")) {
            return false;
        }
        Class<?> superclass = wm.getDeclaringClass().getSuperclass();
        return !ClassUtils.hasMethod(superclass, (String)wm.getName(), (Class[])wm.getParameterTypes());
    }

    public static boolean isSetterDefinedInInterface(PropertyDescriptor pd, Set<Class> interfaces) {
        Method setter = pd.getWriteMethod();
        if (setter != null) {
            Class<?> targetClass = setter.getDeclaringClass();
            for (Class ifc : interfaces) {
                if (!ifc.isAssignableFrom(targetClass) || !ClassUtils.hasMethod((Class)ifc, (String)setter.getName(), (Class[])setter.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public static Object resolveAutowiringValue(Object autowiringValue, Class requiredType) {
        if (autowiringValue instanceof ObjectFactory && !requiredType.isInstance(autowiringValue)) {
            ObjectFactory factory = (ObjectFactory)autowiringValue;
            if (autowiringValue instanceof Serializable && requiredType.isInterface()) {
                autowiringValue = Proxy.newProxyInstance(requiredType.getClassLoader(), new Class[]{requiredType}, (InvocationHandler)new ObjectFactoryDelegatingInvocationHandler(factory));
            } else {
                return factory.getObject();
            }
        }
        return autowiringValue;
    }

    private static class ObjectFactoryDelegatingInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final ObjectFactory objectFactory;

        public ObjectFactoryDelegatingInvocationHandler(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return this.objectFactory.toString();
            }
            try {
                return method.invoke(this.objectFactory.getObject(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

