/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.AttributeNameMangler;
import java.util.Map;

public class AttributeNameManglerImpl
implements AttributeNameMangler {
    private final Map<String, String> mOverrides;
    private final boolean mCapitalizeFirstLetter;

    public AttributeNameManglerImpl(boolean capitalizeFirstLetter, Map<String, String> overrides) {
        this.mCapitalizeFirstLetter = capitalizeFirstLetter;
        this.mOverrides = overrides;
    }

    private String convertOverride(String name) {
        String result = name;
        if (this.mOverrides != null && this.mOverrides.containsKey(name)) {
            result = this.mOverrides.get(name);
        }
        return result;
    }

    @Override
    public String mangleAttributeName(String attributeName) {
        String result = this.mangleIt(attributeName);
        return result;
    }

    private String toUpperCase(char c) {
        return ("" + c).toUpperCase();
    }

    private String mangleIt(String attributeName) {
        char[] chars = attributeName.toCharArray();
        StringBuffer buf = new StringBuffer();
        char firstChar = chars[0];
        if (Character.isJavaIdentifierPart(firstChar)) {
            buf.append(this.mCapitalizeFirstLetter ? this.toUpperCase(firstChar) : "" + firstChar);
        }
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (!Character.isJavaIdentifierPart(c)) {
                char nextChar;
                char c2 = nextChar = ++i < chars.length ? chars[i] : (char)'\u0000';
                if (nextChar >= 'a' && nextChar <= 'z') {
                    buf.append(this.toUpperCase(chars[i]));
                    continue;
                }
                if (nextChar >= 'A' && nextChar <= 'Z') {
                    buf.append("" + chars[i]);
                    continue;
                }
                --i;
                continue;
            }
            buf.append(c);
        }
        String before = buf.toString();
        String result = this.convertOverride(before);
        return result;
    }
}

