Minutes from 26th OpenVDB TSC meeting, August 29th, 2019, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M., *Peter* C.

Additional Attendees: Sean McDuffee

Agenda:

1) Quorum
2) Secretary
3) Round Robin
4) Release Schedule for 6.2.0
5) levelSetVolume
6) VDB Smooth doesn't densify
7) Bitscan/popcount
8) Deprecation
9) Combine SOP Performance
10) Tree Refactoring
11) Delayed Loading
12) Next Meeting

1) Quorum was confirmed.

2) Secretary was Jeff Lait

3) Round Robin

A quick round robin to identify what is being worked on and what may
make it for 6.2.

Ken: Working on velocity extension.  Read-Only grid may end up being internal
only.  Has found interesting results by making a write-only grid that allows
better multithreaded scaling than usual multiple grids + merge.

Nick: AX integration.  Feature branch is hoped to exist in a week or so.
As well, CMake as required.  Should anistropic rasterization be higher
priority?  In response to a later question, MPI will not be available with
current priorities.

Dan: Point partitioning improvements.  C++11 changes.  30-40% better performance
on some datasets.  Merging of grids is open questions.  Likewise, refactoring
tree hierarchy and improving combine SOP.

Jeff: Hopes to get VDB Activate moved to OpenVDB.  6.1 integration into
Houdini 18.0.

Peter: Principle axis extraction from volumes, moment of inertia.  Sharpen
filter.  Discussion on sharpen filter.  Does support non-level set, consensus
was it should be kept regardless of differences with Ken's version.

4) Release Schedule for 6.2.0

No one had any critical items to be done for 6.2.0.

5) levelSetVolume

VDB Clip in 6.X leaves different values in inactive voxels, causing volume
computation to change.  Consensus is that such half-open SDF don't have
a proper volume so this is acceptable.

Peter notes that there is an error computing volume of entirely empty
leaf nodes as empty bounding boxes are not detected by the volume
computation.

6) VDB Smooth doesn't densify

This is a known issue.  Jeff will submit a Jira ticket on it.

Committee differs on whether the right course of action is to add a densify
node to Houdini, or change all algorithms to support sparse tiles.

However, algorithms that don't support sparse volumes should be documented as
such, and the relevant help updated.

7) Bitscan/popcount

The TSC was unsure of the performance difference, so recommended asking
the submitter to verify a measurable difference.  POPCOUNT is the more
debatable as SSE 4.2 is more recent (Only with Houdini 17.0 did that become
a requirement).

We noted that this method does not belong in Utils, but belongs in Tree.
No objections to moving to Tree for 7.

8) Deprecation

Our deprecation policy was unclear in what happens if we release 7 before
the new year.  The intent with 7 is to support the 3 VFX platform years
2020, 2019, and 2018, but it might be read that if it is released in 2019
it must support 2019, 2018, and 2017.  No objections to allowing releases
to base on future VFX platforms.  Dan will submit a PR with a clarification.

9) Combine SOP Performance

Combining 300 VDBs with maximum ends up entirely single threaded.  While
the SOP interface allows a list to merge at once, not in the underlying
API.  May require re-ordering if mixed grid types.

10) Tree Refactoring

Clip is particularly problematic as it is in the File operations.

This is useful for CUDA/GPU and MRes because it would allow subclassing
the internal nodes without as much meaningless boilerplate.  But a main
motivation is that these are depth-first algorithms, so redoing as breadth
first would allow multithreading and performance.

Concerns were raised that this will break a lot of client code.  Proposal
is to provide free floating functions that perform the grid-dispatch
internally, to make it easier to transform grid->foo() into foo(grid).

Another concern is that this may open too much to the API.  Current
interface provides a nice abstraction to internal details.  The counter
argument is that these sort of operations should be possible by external
code, so this is a good way to find where the API falls short.

Is this a good chance to rethink the whole tree?  There seems to be
some cruft that could be removed as is for obsolete file formats.
General agreement that we should always be ready to re-think our structures.

11) Delayed Loading

This is still in a state of limbo between the File SOP and VDB.  One
sticking point has been Windows support.  Another is the difficulty
to pass options to the IO translator.

12) Next Meeting

Next planned meeting is:

September 12th 2019.  3pm-4pm EDT (GMT-4).
