# 7/30/2020

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Joseph Goldstone
* Kimball Thurston
* Larry Gritz
* Nick Porcino
* Owen Thompson
* Peter Hillman

### Discussion:

* Joseph proposed discussing the pros and cons of implementing the
  attributes in the ACES Container spec (SMPTE ST 2065-4) in the
  reference implementation. Putting them in the reference
  implementation will effectively make them more portable. OTOH any
  organization using unqualified names (not ‘legal’ according to the
  spec, but of course the reference implementation doesn’t stop you
  from doing it) in a nonstandard way potentially could see an impact.

  * Joseph: I have a laundry list of things I’d like to include. The
    ACES container has never been a subset of OpenEXR.  People who
    want to use the standard attributes have to implement them
    themselves.

  * If you have two different companies and they’re each implementing
    fstop, one does it as a string, one as a float.  If it’s in the
    reference implementation, it would force consistency.  You can
    read a raw file and find some things in exif fields, other things
    from somewhere else.  What happens if the two things have the same
    name?  What happens if the same thing is in two different places?

  * Has anyone added standard attributes recently? No one has done
    that in a very long time.  Gitlog says nothing has been added
    since 2014.

  * Joseph: Please look at the list of standard attributes and report
    which ones are used at your shop.

  * Larry: A lot of these correspond to things we see all the time.  A
    lot of these, because they correspond to XMP, etc, by convention,
    the OIIO does say “It’s supposed to be called blah.”

  * But there's a difference between standard attributes and required
    attributes. This list combines required and standard.

  * Nick: I propose to adopt the SMPTE names. Move forward with SMPTE standard.
  
  * Larry: we should really strongly recommend that if anybody does
    anything non-canonical, they should prefix it.

  * Peter: It’s not the file format’s job to interpret the
    attributes. But if we can provide guidance and helpers to
    applications.

  * What’s in the standard attributes file suggests what the type of
    an attribute is, but you don’t have to use it. You can insert any
    attribute with any type. The library doesn’t enforce the attribute
    usage.

* Update on Imath

  * Most significant contribution: restructuring of all the source files. It’s been pushed.

  * Installation of imath: tried to do external project. Kimball: we can follow up.

  * Nick: Can you add zlib, too?

  * Would be nice if it fails to download.

  * Nick: remember that OpenTimelineIO has a system that’s working with our CI.

  * What should the version number of the Imath release be? 1.0? That
    might conflict with the libImath from OpenEXR 1.0. It's probably
    best to start with "3.0", odd as that sounds. Then OpenEXR and
    Imath can diverge from there as necessary.

  * Nick: Radical suggestion: D&I initiative: rename it to main. Rebasing on master is gross. 
    Could change to "main", "dev".

  * Larry: This is being hotly debated. Let's wait for a consensus to
    emerge in the community about what everyone si going. Wait to jump
    on the bandwagon.

  * Owen't next step: Finish up the pull request, then get back to CUDA. 

  * Larry: two more things before the release:
  
    * Cuda decorators: make a define if you’re being compiled by the
      CUDA compiler, define host device. Then decorate all functions
      with that.

    * Change the individual component storage to a union, which provides performance improvements.

    * Owen: I'm planning to do both of these right away.

  * Should also replace std::isinf for half.

  * Maybe an option to put half in a namespace?


* We should aggregate all the “can’t find boost” issues into one,
  since they're all versions of the same problem. With the most recent
  boost release, cmake errors: "Boost is incorrectly configured.”
  Kitware and boost in a fist fight.

* Still getting permission issues on sonar scan stuff.

* Reviewed overview of slides for ASWF Open Source Day, scheduled for
  Wednesday, August 19, 4:30pm PT.

* https://github.com/AcademySoftwareFoundation/openexr/issues/636 weak
  namespace and include guards.

  The modern idiom is to use #pragma once.  Header guards prevent
  including twice, but also allows you to know whether they’ve been
  included. We should not take them out, they're still useful. You can
  get to the same file in two different ways.

* Other issues not discussed:

  * https://github.com/AcademySoftwareFoundation/openexr/issues/789
    Better stream interface for DeepScanlineInputFile

  * https://github.com/AcademySoftwareFoundation/openexr/issues/773
    PyIlmBase cmake is able to find Boost but not boost::python 

  * https://github.com/AcademySoftwareFoundation/openexr/pull/750
    Zero allocated memory to guarantee always identical output in DWAA compression

  * https://github.com/AcademySoftwareFoundation/openexr/issues/740
    Remove deprecated argument to getChunkOffsetTableSize

  * https://github.com/AcademySoftwareFoundation/openexr/issues/548
    mark half(float) constructor as explicit

  * https://github.com/AcademySoftwareFoundation/openexr/issues/485
    Remove _maxScanLineSize members

