/*
 * Adplug - Replayer for many OPL2/OPL3 audio file formats.
 * Copyright (C) 1999 - 2007 Simon Peter, <dn.tlp@gmx.net>, et al.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * hsc.h - HSC Player by Simon Peter <dn.tlp@gmx.net>
 */

#ifndef H_ADPLUG_HSCPLAYER
#define H_ADPLUG_HSCPLAYER

#include "player.h"

class ChscPlayer: public CPlayer
{
 public:
  static CPlayer *factory(Copl *newopl);

  ChscPlayer(Copl *newopl): CPlayer(newopl), mtkmode(0) {}

  bool load(const std::string &filename, const CFileProvider &fp) override;
  bool update() override;
  void rewind(int subsong) override;
  float getrefresh() override{ return 18.2f; };	// refresh rate is fixed at 18.2Hz

  std::string gettype() override { return std::string("HSC Adlib Composer / HSC-Tracker"); }
  unsigned int getpatterns() override;
  unsigned int getpattern() override { return song[songpos]; }
  unsigned int getorders() override;
  unsigned int getorder() override { return songpos; }
  unsigned int getrow() override { return pattpos; }
  unsigned int getrows() override { return 64; }
  unsigned int getnchans() override { return 9; }
  unsigned char getpattern(unsigned long ordr) override;

  void gettrackdata(unsigned char pattern, void (*callback)(void *arg, unsigned char row, unsigned char channel, unsigned char note, TrackedCmds command, unsigned char inst, unsigned char volume, unsigned char param), void *arg) override;

  unsigned int getspeed() override { return speed; }
  unsigned int getinstruments() override;

 protected:
  struct hscnote {
    unsigned char note, effect;
  };	// note type in HSC pattern

  struct hscchan {
    unsigned char inst;			// current instrument
    signed char slide;			// used for manual slide-effects
    unsigned short freq;		// actual replaying frequency
  };	// HSC channel data

  hscchan channel[9];			// player channel-info
  unsigned char instr[128][12];		// instrument data
  unsigned char song[0x80];		// song-arrangement (MPU-401 Trakker enhanced)
  hscnote patterns[50][64*9];		// pattern data
  unsigned char pattpos,songpos,	// various bytes & flags
    pattbreak,songend,mode6,bd,fadein;
  unsigned int speed,del;
  unsigned char adl_freq[9];		// adlib frequency registers
  int mtkmode;				// flag: MPU-401 Trakker mode on/off

 private:
  void setfreq(unsigned char chan, unsigned short freq);
  void setvolume(unsigned char chan, int volc, int volm);
  void setinstr(unsigned char chan, unsigned char insnr);
};

#endif
