---
id: fast-foundation.listbox
title: Listbox class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Listbox](./fast-foundation.listbox.md)

## Listbox class

A Listbox Custom HTML Element. Implements the [ARIA listbox](https://www.w3.org/TR/wai-aria-1.1/#listbox)<!-- -->.


- The default slot for the listbox options

<b>Signature:</b>

```typescript
export declare abstract class Listbox extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [disabled](./fast-foundation.listbox.disabled.md) |  | boolean | The disabled state of the listbox. |
|  [length](./fast-foundation.listbox.length.md) |  | number | The number of options. |
|  [options](./fast-foundation.listbox.options.md) |  | [ListboxOption](./fast-foundation.listboxoption.md)<!-- -->\[\] | The list of options. |
|  [selectedIndex](./fast-foundation.listbox.selectedindex.md) |  | number | The index of the selected option. |
|  [selectedOptions](./fast-foundation.listbox.selectedoptions.md) |  | [ListboxOption](./fast-foundation.listboxoption.md)<!-- -->\[\] | A collection of the selected options. |
|  [slottedOptionFilter](./fast-foundation.listbox.slottedoptionfilter.md) | <code>static</code> | (n: HTMLElement) =&gt; boolean | A static filter to include only selectable options. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [selectFirstOption()](./fast-foundation.listbox.selectfirstoption.md) |  | Moves focus to the first selectable option. |
|  [setSelectedOptions()](./fast-foundation.listbox.setselectedoptions.md) |  | Sets an option as selected and gives it focus. |
