#!/usr/bin/perl -w

#(c)2007-2009 Hurricane Labs
#Author: Billford
#License: See LICENSE file GPL v2
#Nagzilla Jabber Relay Client

use strict;
require Config::Simple;
require Data::Dumper;
use IO::Socket;
use IO::Socket::INET;
use Getopt::Long;
use Pod::Usage;

#bring in our configuration variables
my $CONFDIR = "/etc/nagzillac";

# DO NOT EDIT ANYTHING BEYOND THIS POINT!!

##################Begin Config Setup########################
our %Config;
Config::Simple->import_from('nagzillac.cfg', \%Config);
my $cfg = new Config::Simple("$CONFDIR/nagzillac.cfg");

#Nagzillac Nagzilla Server Settings

my $nagzillaserver = $cfg->param("NagzillaServer");
my $nagzillaport  = $cfg->param("NagzillaPort");

##################End Config Setup##########################

##################Get Some Options and set up pod2usage#####

my ($opt_type, $opt_room, $opt_mess, $opt_color, $opt_help, $opt_man);

GetOptions (

	't=s'	=> \$opt_type,
	'r=s'	=> \$opt_room,
	'm=s'	=> \$opt_mess,
	'c:s'	=> \$opt_color,
	'help|?'		=> \$opt_help,
	'man!'	=> \$opt_man

) or pod2usage(-verbose =>1) && exit; #End GetOptions

no warnings 'uninitialized'; 

pod2usage(-verbose => 1) && exit if defined $opt_help;
pod2usage(-verbose => 1) && exit if ($opt_type eq '' || $opt_room eq '' || $opt_mess eq '');
pod2usage(-verbose => 2) && exit if defined $opt_man;




##################End Options###############################

my $send2nagd;
if ($opt_color eq '') {	
$send2nagd = "$opt_type^$opt_room^$opt_mess";
} else {
	$send2nagd = "$opt_type^$opt_room^$opt_mess^$opt_color";
}

print "$send2nagd \n";


##################Make socket connection###############################

#Let's make us a socket connection
my $remote = IO::Socket::INET->new(
   Proto    => 'tcp',
   PeerAddr => "$nagzillaserver",
   PeerPort => "$nagzillaport",
   Reuse    => 1
) or die "$!";

$remote->autoflush(1);

print $remote $send2nagd;

close $remote;

##################End socket stuff###############################

=head1 NAME

 nagzillac2.pl

=head1 SYNOPSIS

 Nagzillac connects to and sends messages to nagzillad which relays them to Jabber

=head1 ARGUMENTS
 
 -t	Type: either groupchat or chat REQUIRED
 -r	Room: Either chatroom name or JID of an individual REQUIRED
 -m	Message: The messages you would like to send enclosed in quotes REQUIRED
 -c	Color: The color of your message (currently only red, yellow and green work) OPTIONAL
 -h	Prints this message

=head1 AUTHOR

 Billford@Hurricane Labs

=head1 CREDITS

 McMaster@Hurricane Labs - some code and sounding board
 Steve@Hurricane Labs - some stupid checking 

=cut
