/*
 *
 * Copyright (C) 2024, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhenyu Wang <wangzhenyu@kylinos.cn>
 *
 */

#include "../../kysdk-alm/src/singleapplication/localpeer.h"
#include "../../kysdk-alm/src/singleapplication/lockedfile.h"
#include "../../kysdk-alm/src/singleapplication/singleapplication.h"
#include <QObject>
#include <QtTest>

using namespace kdk;
using namespace QtLP_Private;

class AlmTest : public QObject
{
    Q_OBJECT

private slots:
    void localpeerTest();
    void lockedfileTest();
    void singleapplicationTest();
};

void AlmTest::localpeerTest()
{
    QtLocalPeer peer;
    //    QtLocalPeer peer1;
    peer.isClient();
    peer.sendMessage("message", 1000);
    peer.applicationId();

    emit peer.messageReceived("message 1");
}

void AlmTest::lockedfileTest()
{
    QtLockedFile file;
    file.open(QIODevice::OpenModeFlag::Text);
    file.lock(QtLockedFile::LockMode::NoLock);
    file.lock(QtLockedFile::LockMode::ReadLock);
    file.lock(QtLockedFile::LockMode::WriteLock);
    file.unlock();
    file.isLocked();
    file.lockMode();

    QtLockedFile file1("file");
    file1.open(QIODevice::Truncate);
    file1.lock(QtLockedFile::LockMode::NoLock, false);
    file1.lock(QtLockedFile::LockMode::ReadLock, false);
    file1.lock(QtLockedFile::LockMode::WriteLock, false);
}

void AlmTest::singleapplicationTest()
{
    int argc = 0;
    char *argv[] = {nullptr};
    QString uniqueAppId = "QtSingleApplicationTest_UniqueAppId";
    QtSingleApplication app(uniqueAppId, argc, argv);

    QVERIFY(app.id() == uniqueAppId);

    app.isRunning();
    app.id();

    //    QWidget widget;
    app.setActivationWindow(nullptr, true);
    app.setActivationWindow(nullptr, false);

    app.activationWindow();
    app.initialize(true);
    app.initialize(false);

    app.sendMessage("app message", 1000);
    app.activateWindow();

    //    QtSingleApplication app1(uniqueAppId, argc, argv);
}

QTEST_APPLESS_MAIN(AlmTest)
#include "almtest.moc"
