.TH libinput-debug-gui "1" "" "libinput @LIBINPUT_VERSION@" "libinput Manual"
.SH NAME
libinput\-debug\-gui \- visual debug helper for libinput
.SH SYNOPSIS
.B libinput debug\-gui \fI[options]\fB
.PP
.B libinput debug\-gui \fI[options]\fB \-\-udev \fI<seat>\fB
.PP
.B libinput debug\-gui \fI[options]\fB [\-\-device] \fI/dev/input/event0\fB
.SH DESCRIPTION
.PP
The
.B "libinput debug\-gui"
tool creates a libinput context and a full-screen GTK window to visualize
events processed by libinput. This tool exclusively grabs pointing devices
and stops them from interacting with the rest of the GUI.
.PP
.B Hit Esc to exit this tool.
.PP
This is a debugging tool only, its output or behavior may change at any
time. Do not rely on the output or the behavior.
.PP
This tool usually needs to be run as root to have access to the
/dev/input/eventX nodes.
.SH OPTIONS
.TP 8
.B \-\-device \fI/dev/input/event0\fR
Use the given device with the path backend. The \fB\-\-device\fR argument may be
omitted.
.TP 8
.B \-\-grab
Exclusively grab all opened devices. This will prevent events from being
delivered to the host system.
.TP 8
.B \-\-help
Print help
.TP 8
.B \-\-udev \fI<seat>\fR
Use the udev backend to listen for device notifications on the given seat.
The default behavior is equivalent to \-\-udev "seat0".
.TP 8
.B \-\-verbose
Use verbose output
.PP
For libinput configuration options, see libinput-debug-events(1)
.SH FEATURES
.PP
.TP 8
.B Cursor movement
The cursor is displayed as black triangle. Various markers are displayed in
light grey to help debug cusor positioning. The cursor movement is
the one as seen by libinput and may not match the cursor movement of the
display server.
.PP
The unaccelerated cusor motion is displayed as a grey upside-down triangle.
The movement of this cursor typically reflects the relative motion in device
units and can differ significantly to the normal cursor movement.
.PP
The unaccelerated cursor motion is also displayed as a yellow snake. This is
the connected set of recent deltas. Unlike the unaccelerated cursor, these
coordinates are not clipped to the window.
.TP 8
.B Button testing
Four oblongs are displayed at the bottom. The top three are left, middle,
right, the bottom one is for any other button and displays the button name
on press.
.TP 8
.B Scrolling
The green oblongs show the scrolling in continuous space, the smaller red
oblongs the scroll steps in discrete steps.
.TP 8
.B Gestures
A set of four horizontal black rings show swipe gestures, with the number of
detected fingers filled in. A set of two black rings show pinch gestures,
filled when events are detected.
.TP 8
.B Touch and absolute mouse events
Touch and absolute mouse events are displayed as red and blue circles,
respectively, at the touch point or absolute position.
.TP 8
.B Tablet tools
Events from tablet tools show a cyan square at the proximity-in and
proximity-out positions. The tool position is shown as circle and increases
in radius with increasing pressure or distance. Pressure and distance are
also shown in the vertical bar south-east of center. Where tilt is
available, the circle changes to an ellipsis to indicate the tilt angle.
Relative events from the tablet tool are displayed as a yellow snake, always
starting from the center of the window on proximity in. Button events are
displayed in the bottom-most button oblong, with the name of the button
displayed on press.
.TP 8
.B Tablet pads
Button events are displayed in the bottom-most button oblong, with the name
of the button displayed on press. Dials, ring and strip events are displayed in
the yellow 'IO' symbol, with the position of the ring or strip or the
delta of the dial filled in when events are available. The number of the dial,
ring or strip is displayed when an event is available.
.TP 8
.B Kernel events
Left of the center is a blue ring to debug kernel relative events (REL_X and
REL_Y). Each unit is displayed as one arrow in the respective direction.
Right of the center is a blue oblong representing the most recently-used
touch device. Touch events are displayed as they are read from the kernel.

.SH NOTES
.PP
Events shown by this tool may not correspond to the events seen by a
different user of libinput. This tool initializes a separate context.
.SH LIBINPUT
Part of the
.B libinput(1)
suite
