/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.math.BigInteger;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import org.apache.harmony.jndi.internal.SortResult;
import org.apache.harmony.jndi.internal.Util;
import org.apache.harmony.security.asn1.ASN1Enumerated;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;

public final class SortResponseControl
extends BasicControl {
    static ASN1Type ASN1_SORTRESPONSE = new ASN1Sequence(new ASN1Type[]{ASN1Enumerated.getInstance(), ASN1OctetString.getInstance()}){
        {
            this.setOptional(1);
        }

        public Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            int sortresult = new BigInteger((byte[])values[0]).intValue();
            String attrtype = null;
            try {
                attrtype = new String((byte[])values[1]);
            }
            catch (NullPointerException nullPointerException) {}
            return new SortResult(sortresult, attrtype);
        }
    };
    private static final long serialVersionUID = 5142939176006310877L;
    private int resultCode;
    private String badAttrId;
    private transient boolean sorted = false;
    public static final String OID = "1.2.840.113556.1.4.474";

    public SortResponseControl(String id, boolean criticality, byte[] value) throws IOException {
        super(OID, criticality, value);
        SortResult sr = (SortResult)ASN1_SORTRESPONSE.decode(value);
        this.resultCode = sr.getSortresult();
        this.badAttrId = sr.getAttributeType();
        this.sorted = this.getResultCode() == 0;
    }

    public String getAttributeID() {
        return this.badAttrId;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public NamingException getException() {
        return Util.getExceptionFromErrorCode(this.getResultCode());
    }
}

