<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

[![Linux](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-ubuntu.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-ubuntu.yml)
[![MacOS](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-macos.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-macos.yml)
<br/>
[![Windows (dll)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-windows.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-windows.yml)
[![Windows (static)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-windows-static.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-windows-static.yml)
[![MSYS2](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-msys2.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/log4cxx-msys2.yml)
<br/>
[![ABI stability](https://github.com/apache/logging-log4cxx/actions/workflows/abi-compatibility.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/abi-compatibility.yml)
[![Quality gate](https://github.com/apache/logging-log4cxx/actions/workflows/sonarcloud.yml/badge.svg)](https://github.com/apache/logging-log4cxx/actions/workflows/sonarcloud.yml)
[![Fuzzing Status](https://oss-fuzz-build-logs.storage.googleapis.com/badges/apache-logging-log4cxx.svg)](https://bugs.chromium.org/p/oss-fuzz/issues/list?sort=-opened&can=1&q=proj:apache-logging-log4cxx)

Apache Log4cxx is a logging framework for C++.

For answers to such questions as "What is logging?",
"What should a logging framework do?" and
"How to do logging properly?"
refer to the [logging overview page](https://logging.apache.org/what-is-logging.html).

The [quick start guide](https://logging.apache.org/log4cxx/latest_stable/quick-start.html)
shows what code you write to use Log4cxx in your project.

For other information about Log4cxx
(e.g. [getting help](https://logging.apache.org/log4cxx/latest_stable/community.html),
[official release downloads](https://logging.apache.org/log4cxx/latest_stable/download.html),
[building Log4cxx](https://logging.apache.org/log4cxx/latest_stable/build.html)) use
[the Log4cxx project website](https://logging.apache.org/log4cxx/latest_stable).

Log4cxx is part of the [Apache Logging Services](https://logging.apache.org/) PMC.
