/* Copyright (C) 2025 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file
 * @brief GVM management layer: OCI Image Targets SQL.
 *
 * SQL OCI image targets code for the GVM management layer.
 */

#if ENABLE_CONTAINER_SCANNING

#ifndef _GVMD_MANAGE_SQL_OCI_IMAGE_TARGETS_H
#define _GVMD_MANAGE_SQL_OCI_IMAGE_TARGETS_H

#include "manage.h"
#include "manage_sql.h"

char*
oci_image_target_image_references (oci_image_target_t);

credential_t
oci_image_target_credential (oci_image_target_t);

#endif /* not _GVMD_MANAGE_SQL_OCI_IMAGE_TARGETS_H */

#endif /* ENABLE_CONTAINER_SCANNING */