/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.common.AntFsCommon;
import com.dsi.ant.plugins.antplus.common.FitFileCommon;
import com.dsi.ant.plugins.antplus.pcc.defines.AntFsRequestStatus;
import com.dsi.ant.plugins.antplus.pcc.defines.AntFsState;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Random;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusWeightScalePcc
extends AntPlusCommonPcc {
    private static final String TAG = AntPlusWeightScalePcc.class.getSimpleName();
    AntFsCommon.IAntFsProgressUpdateReceiver mAntFsProgressUpdateReceiver;
    FitFileCommon.IFitFileDownloadedReceiver mFitFileDownloadedReceiver;
    IDownloadAllHistoryFinishedReceiver mDownloadAllHistoryFinishedReceiver;
    IBasicMeasurementFinishedReceiver mBasicMeasurementFinishedReceiver;
    IAdvancedMeasurementFinishedReceiver mAdvancedMeasurementFinishedReceiver;
    ICapabilitiesRequestFinishedReceiver mCapabilitiesRequestFinishedReceiver;
    IBodyWeightBroadcastReceiver mBodyWeightBroadcastReceiver;
    Semaphore mCommandLock = new Semaphore(1);

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 0;
    }

    public static PccReleaseHandle<AntPlusWeightScalePcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusWeightScalePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusWeightScalePcc potentialRetObj = new AntPlusWeightScalePcc();
        return AntPlusWeightScalePcc.requestAccess_Helper_SearchActivity(userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusWeightScalePcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusWeightScalePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusWeightScalePcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusWeightScalePcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusWeightScalePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusWeightScalePcc potentialRetObj = new AntPlusWeightScalePcc();
        return AntPlusWeightScalePcc.requestAccess_Helper_AsyncSearchByDevNumber(bindToContext, antDeviceNumber, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static AsyncScanController<AntPlusWeightScalePcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AntPlusWeightScalePcc potentialRetObj = new AntPlusWeightScalePcc();
        return AntPlusWeightScalePcc.requestAccess_Helper_AsyncScanController(bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusWeightScalePcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.weightscale.WeightScaleService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Weight Scale";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mBasicMeasurementFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                WeightScaleRequestStatus statusCode = WeightScaleRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                BigDecimal bodyWeight = (BigDecimal)b.getSerializable("decimal_bodyWeight");
                this.mBasicMeasurementFinishedReceiver.onBasicMeasurementFinished(estTimestamp, eventFlags, statusCode, bodyWeight);
                break;
            }
            case 202: {
                if (this.mAdvancedMeasurementFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                WeightScaleRequestStatus statusCode = WeightScaleRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                AdvancedMeasurement m = (AdvancedMeasurement)b.getParcelable("parcelable_AdvancedMeasurement");
                this.mAdvancedMeasurementFinishedReceiver.onAdvancedMeasurementFinished(estTimestamp, eventFlags, statusCode, m);
                break;
            }
            case 203: {
                if (this.mCapabilitiesRequestFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                WeightScaleRequestStatus statusCode = WeightScaleRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                int userProfileID = b.getInt("int_userProfileID");
                boolean historySupport = b.getBoolean("bool_historySupport");
                boolean userProfileExchangeSupport = b.getBoolean("bool_userProfileExchangeSupport");
                boolean userProfileSelected = b.getBoolean("bool_userProfileSelected");
                this.mCapabilitiesRequestFinishedReceiver.onCapabilitiesRequestFinished(estTimestamp, eventFlags, statusCode, userProfileID, historySupport, userProfileExchangeSupport, userProfileSelected);
                break;
            }
            case 190: {
                if (this.mAntFsProgressUpdateReceiver == null) break;
                Bundle b = eventMsg.getData();
                AntFsState stateCode = AntFsState.getValueFromInt(b.getInt("int_stateCode"));
                long transferredBytes = b.getLong("long_transferredBytes");
                long totalBytes = b.getLong("long_totalBytes");
                this.mAntFsProgressUpdateReceiver.onNewAntFsProgressUpdate(stateCode, transferredBytes, totalBytes);
                break;
            }
            case 191: {
                if (this.mFitFileDownloadedReceiver == null) break;
                Bundle b = eventMsg.getData();
                byte[] fileBytes = b.getByteArray("arrayByte_rawFileBytes");
                this.mFitFileDownloadedReceiver.onNewFitFileDownloaded(new FitFileCommon.FitFile(fileBytes));
                break;
            }
            case 204: {
                if (this.mDownloadAllHistoryFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                AntFsRequestStatus statusCode = AntFsRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                this.mDownloadAllHistoryFinishedReceiver.onDownloadAllHistoryFinished(statusCode);
                break;
            }
            case 205: {
                if (this.mBodyWeightBroadcastReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int bodyWeightStatus = b.getInt("int_bodyWeightStatus");
                BigDecimal bodyWeight = (BigDecimal)b.getSerializable("decimal_bodyWeight");
                this.mBodyWeightBroadcastReceiver.onNewBodyWeightBroadcast(estTimestamp, eventFlags, BodyWeightStatus.getValueFromInt(bodyWeightStatus), bodyWeight);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public boolean requestBasicMeasurement(IBasicMeasurementFinishedReceiver basicMeasurementFinishedReceiver) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd requestBasicMeasurement failed to start because a local command is still processing.");
            return false;
        }
        this.mBasicMeasurementFinishedReceiver = basicMeasurementFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20001;
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestBasicMeasurement died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestBasicMeasurement failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestBasicMeasurement cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean requestAdvancedMeasurement(IAdvancedMeasurementFinishedReceiver advancedMeasurementFinishedReceiver, UserProfile userProfile) {
        if (this.reportedServiceVersion == 0) {
            advancedMeasurementFinishedReceiver.onAdvancedMeasurementFinished(0L, null, WeightScaleRequestStatus.FAIL_PLUGINS_SERVICE_VERSION, null);
            return false;
        }
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd requestAdvancedMeasurement failed to start because a local command is still processing.");
            return false;
        }
        this.mAdvancedMeasurementFinishedReceiver = advancedMeasurementFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20002;
        Bundle params = new Bundle();
        if (userProfile != null) {
            params.putParcelable("parcelable_UserProfile", (Parcelable)userProfile);
        }
        cmdMsg.setData(params);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestAdvancedMeasurement died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestAdvancedMeasurement failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestAdvancedMeasurement cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean requestCapabilities(ICapabilitiesRequestFinishedReceiver capabilitiesReceiver) {
        if (this.reportedServiceVersion == 0) {
            LogAnt.w(TAG, "requestCapabilities requires ANT+ Plugins Service >10000, installed: " + this.reportedServiceVersion);
            capabilitiesReceiver.onCapabilitiesRequestFinished(0L, null, WeightScaleRequestStatus.FAIL_PLUGINS_SERVICE_VERSION, -2, false, false, false);
            return false;
        }
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd requestCapabilities failed to start because a local command is still processing.");
            return false;
        }
        this.mCapabilitiesRequestFinishedReceiver = capabilitiesReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20003;
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestCapabilities died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestCapabilities failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestCapabilities cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean requestDownloadAllHistory(IDownloadAllHistoryFinishedReceiver downloadAllHistoryFinishedReceiver, FitFileCommon.IFitFileDownloadedReceiver fitFileDownloadedReceiver, AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier) {
        if (this.reportedServiceVersion == 0) {
            LogAnt.w(TAG, "requestDownloadAllHistory requires ANT+ Plugins Service >10000, installed: " + this.reportedServiceVersion);
            downloadAllHistoryFinishedReceiver.onDownloadAllHistoryFinished(AntFsRequestStatus.FAIL_PLUGINS_SERVICE_VERSION);
            return false;
        }
        if (!this.mCommandLock.tryAcquire()) {
            return false;
        }
        this.mAntFsProgressUpdateReceiver = antFsProgressUpdateRecevier;
        this.mFitFileDownloadedReceiver = fitFileDownloadedReceiver;
        this.mDownloadAllHistoryFinishedReceiver = downloadAllHistoryFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20004;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putBoolean("bool_UseAntFsProgressUpdates", antFsProgressUpdateRecevier != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestAllHistory died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestAllHistory failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestAllHistory cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public void subscribeBodyWeightBroadcastEvent(IBodyWeightBroadcastReceiver BodyWeightBroadcastReceiver) {
        this.mBodyWeightBroadcastReceiver = BodyWeightBroadcastReceiver;
        if (BodyWeightBroadcastReceiver != null) {
            this.subscribeToEvent(205);
        } else {
            this.unsubscribeFromEvent(205);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBodyWeightBroadcastReceiver {
        public void onNewBodyWeightBroadcast(long var1, EnumSet<EventFlag> var3, BodyWeightStatus var4, BigDecimal var5);
    }

    public static interface IDownloadAllHistoryFinishedReceiver {
        public void onDownloadAllHistoryFinished(AntFsRequestStatus var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICapabilitiesRequestFinishedReceiver {
        public void onCapabilitiesRequestFinished(long var1, EnumSet<EventFlag> var3, WeightScaleRequestStatus var4, int var5, boolean var6, boolean var7, boolean var8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IAdvancedMeasurementFinishedReceiver {
        public void onAdvancedMeasurementFinished(long var1, EnumSet<EventFlag> var3, WeightScaleRequestStatus var4, AdvancedMeasurement var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBasicMeasurementFinishedReceiver {
        public void onBasicMeasurementFinished(long var1, EnumSet<EventFlag> var3, WeightScaleRequestStatus var4, BigDecimal var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WeightScaleRequestStatus {
        SUCCESS(0),
        FAIL_CANCELLED(-2),
        UNRECOGNIZED(-3),
        FAIL_OTHER(-10),
        FAIL_ALREADY_BUSY_EXTERNAL(-20),
        FAIL_DEVICE_COMMUNICATION_FAILURE(-40),
        FAIL_DEVICE_TRANSMISSION_LOST(-41),
        FAIL_BAD_PARAMS(-50),
        FAIL_NO_PERMISSION(-60),
        FAIL_NOT_SUPPORTED(-61),
        FAIL_PLUGINS_SERVICE_VERSION(-62),
        FAIL_PROFILE_MISMATCH(-1000),
        FAIL_WEIGHT_VALUE_NOT_STABILIZED(-1001);

        private int intValue;

        private WeightScaleRequestStatus(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static WeightScaleRequestStatus getValueFromInt(int intValue) {
            for (WeightScaleRequestStatus status : WeightScaleRequestStatus.values()) {
                if (status.getIntValue() != intValue) continue;
                return status;
            }
            WeightScaleRequestStatus unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BodyWeightStatus {
        VALID(0),
        COMPUTING(-1),
        INVALID(-2),
        UNRECOGNIZED(-3);

        private int intValue;

        private BodyWeightStatus(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static BodyWeightStatus getValueFromInt(int intValue) {
            for (BodyWeightStatus ident : BodyWeightStatus.values()) {
                if (ident.getIntValue() != intValue) continue;
                return ident;
            }
            BodyWeightStatus unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Gender {
        FEMALE,
        MALE,
        UNASSIGNED;

        public static final int INTVALUE_FEMALE = 0;
        public static final int INTVALUE_MALE = 1;
        public static final int INTVALUE_UNASSIGNED = -1;

        public int getIntValue() {
            switch (this) {
                case FEMALE: {
                    return 0;
                }
                case MALE: {
                    return 1;
                }
                case UNASSIGNED: {
                    return -1;
                }
            }
            throw new IllegalArgumentException("Undefined gender value");
        }

        public static Gender getValueFromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return FEMALE;
                }
                case 1: {
                    return MALE;
                }
                case -1: {
                    return UNASSIGNED;
                }
            }
            throw new IllegalArgumentException("Undefined gender value");
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_WEIGHTSCALEPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_WEIGHTSCALEPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.weightscale.WeightScaleService";
        public static final int MSG_EVENT_WEIGHTSCALE_whatBASICMEASUREMENTFINISHED = 201;
        public static final String MSG_EVENT_WEIGHTSCALE_BASICMEASUREMENTFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final String MSG_EVENT_WEIGHTSCALE_BASICMEASUREMENTFINISHED_PARAM_decimalBODYWEIGHT = "decimal_bodyWeight";
        public static final int MSG_EVENT_WEIGHTSCALE_whatADVANCEDMEASUREMENTFINISHED = 202;
        public static final String MSG_EVENT_WEIGHTSCALE_ADVANCEDMEASUREMENTFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final int MSG_EVENT_WEIGHTSCALE_whatCAPABILITIESREQUESTFINISHED = 203;
        public static final String MSG_EVENT_WEIGHTSCALE_CAPABILITIESREQUESTFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final String MSG_EVENT_WEIGHTSCALE_CAPABILITIESREQUESTFINISHED_PARAM_intUSERPROFILEID = "int_userProfileID";
        public static final String MSG_EVENT_WEIGHTSCALE_CAPABILITIESREQUESTFINISHED_PARAM_boolHISTORYSUPPORT = "bool_historySupport";
        public static final String MSG_EVENT_WEIGHTSCALE_CAPABILITIESREQUESTFINISHED_PARAM_boolUSERPROFILEEXCHANGESUPPORT = "bool_userProfileExchangeSupport";
        public static final String MSG_EVENT_WEIGHTSCALE_CAPABILITIESREQUESTFINISHED_PARAM_boolUSERPROFILESELECTED = "bool_userProfileSelected";
        public static final int MSG_EVENT_WEIGHTSCALE_whatDOWNLOADALLHISTORYFINISHED = 204;
        public static final String MSG_EVENT_WEIGHTSCALE_DOWNLOADALLHISTORYFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final int MSG_EVENT_WEIGHTSCALE_whatBODYWEIGHTBROADCAST = 205;
        public static final String MSG_EVENT_WEIGHTSCALE_BODYWEIGHTBROADCAST_PARAM_intBODYWEIGHTSTATUS = "int_bodyWeightStatus";
        public static final String MSG_EVENT_WEIGHTSCALE_BODYWEIGHTBROADCAST_PARAM_decimalBODYWEIGHT = "decimal_bodyWeight";
        public static final int MSG_CMD_WEIGHTSCALE_whatREQUESTBASICMEASUREMENT = 20001;
        public static final int MSG_CMD_WEIGHTSCALE_whatREQUESTADVANCEDMEASUREMENT = 20002;
        public static final int MSG_CMD_WEIGHTSCALE_whatREQUESTCAPABILITIES = 20003;
        public static final int MSG_CMD_WEIGHTSCALE_whatREQUESTDOWNLOADALLHISTORY = 20004;
    }

    public static class UserProfile
    implements Parcelable {
        public static final String KEY_DEFAULT_USERPROFILEKEY = "parcelable_UserProfile";
        private final int ipcVersionNumber;
        private final int userProfileID;
        public Gender gender = Gender.UNASSIGNED;
        public int age = -1;
        public int height = -1;
        public int activityLevel = -1;
        public boolean lifetimeAthlete = false;
        public static final Parcelable.Creator<UserProfile> CREATOR = new Parcelable.Creator<UserProfile>(){

            public UserProfile createFromParcel(Parcel source) {
                return new UserProfile(source);
            }

            public UserProfile[] newArray(int size) {
                return new UserProfile[size];
            }
        };

        public int getUserProfileID() {
            return this.userProfileID;
        }

        public UserProfile() {
            this.ipcVersionNumber = 1;
            Random r = new Random();
            this.userProfileID = r.nextInt(65279) + 256;
        }

        public UserProfile(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " UserProfile parcel with version 1 parser.");
            }
            this.userProfileID = in.readInt();
            this.gender = Gender.getValueFromInt(in.readInt());
            this.age = in.readInt();
            this.height = in.readInt();
            this.activityLevel = in.readInt();
            this.lifetimeAthlete = in.readByte() != 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeInt(this.userProfileID);
            dest.writeInt(this.gender.getIntValue());
            dest.writeInt(this.age);
            dest.writeInt(this.height);
            dest.writeInt(this.activityLevel);
            dest.writeByte((byte)(this.lifetimeAthlete ? 1 : 0));
        }

        public int describeContents() {
            return 0;
        }
    }

    public static class AdvancedMeasurement
    implements Parcelable {
        public static final String KEY_DEFAULT_ADVANCEDMEASUREMENTKEY = "parcelable_AdvancedMeasurement";
        private final int ipcVersionNumber;
        public BigDecimal bodyWeight;
        public BigDecimal hydrationPercentage;
        public BigDecimal bodyFatPercentage;
        public BigDecimal muscleMass;
        public BigDecimal boneMass;
        public BigDecimal activeMetabolicRate;
        public BigDecimal basalMetabolicRate;
        public static final Parcelable.Creator<AdvancedMeasurement> CREATOR = new Parcelable.Creator<AdvancedMeasurement>(){

            public AdvancedMeasurement createFromParcel(Parcel source) {
                return new AdvancedMeasurement(source);
            }

            public AdvancedMeasurement[] newArray(int size) {
                return new AdvancedMeasurement[size];
            }
        };

        public AdvancedMeasurement() {
            this.ipcVersionNumber = 1;
        }

        public AdvancedMeasurement(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " AdvancedMeasurement parcel with version 1 parser.");
            }
            this.bodyWeight = new BigDecimal(in.readString());
            this.hydrationPercentage = new BigDecimal(in.readString());
            this.bodyFatPercentage = new BigDecimal(in.readString());
            this.muscleMass = new BigDecimal(in.readString());
            this.boneMass = new BigDecimal(in.readString());
            this.activeMetabolicRate = new BigDecimal(in.readString());
            this.basalMetabolicRate = new BigDecimal(in.readString());
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeString(this.bodyWeight.toString());
            dest.writeString(this.hydrationPercentage.toString());
            dest.writeString(this.bodyFatPercentage.toString());
            dest.writeString(this.muscleMass.toString());
            dest.writeString(this.boneMass.toString());
            dest.writeString(this.activeMetabolicRate.toString());
            dest.writeString(this.basalMetabolicRate.toString());
        }

        public int describeContents() {
            return 0;
        }
    }
}

