package incremental

import (
	"testing"
)

type someInt32Struct struct {
	i Int32
}

func TestInt32Ptr(t *testing.T) {
	i := &Int32{}
	num := i.Next()
	if num != 1 {
		t.Fatalf("expected 1, got %d", num)
	}
	num = i.Next()
	if num != 2 {
		t.Fatalf("expected 2, got %d", num)
	}
	num = i.Last()
	if num != 2 {
		t.Fatalf("expected last to be 2, got %d", num)
	}

	i.Set(42)
	num = i.Last()
	if num != 42 {
		t.Fatalf("expected last to be 42, got %d", num)
	}
	num = i.Next()
	if num != 43 {
		t.Fatalf("expected 43, got %d", num)
	}
}

func TestInt32AsField(t *testing.T) {
	s := someInt32Struct{}
	num := s.i.Next()
	if num != 1 {
		t.Fatalf("expected 1, got %d", num)
	}
	num = s.i.Next()
	if num != 2 {
		t.Fatalf("expected 2, got %d", num)
	}
	num = s.i.Last()
	if num != 2 {
		t.Fatalf("expected last to be 2, got %d", num)
	}

	useSomeInt32Struct(&s, t)

	num = s.i.Last()
	if num != 3 {
		t.Fatalf("expected last to be 3, got %d", num)
	}

	s.i.Set(42)
	num = s.i.Last()
	if num != 42 {
		t.Fatalf("expected last to be 42, got %d", num)
	}
	num = s.i.Next()
	if num != 43 {
		t.Fatalf("expected 43, got %d", num)
	}
}

func useSomeInt32Struct(s *someInt32Struct, t *testing.T) {
	num := s.i.Next()
	if num != 3 {
		t.Fatalf("expected 3, got %d", num)
	}
}
