// Code generated by smithy-go-codegen DO NOT EDIT.

package servicequotas

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/servicequotas/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the default values for the quotas for the specified AWS service. A default
// value does not reflect any quota increases.
func (c *Client) ListAWSDefaultServiceQuotas(ctx context.Context, params *ListAWSDefaultServiceQuotasInput, optFns ...func(*Options)) (*ListAWSDefaultServiceQuotasOutput, error) {
	if params == nil {
		params = &ListAWSDefaultServiceQuotasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAWSDefaultServiceQuotas", params, optFns, c.addOperationListAWSDefaultServiceQuotasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAWSDefaultServiceQuotasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAWSDefaultServiceQuotasInput struct {

	// The service identifier.
	//
	// This member is required.
	ServiceCode *string

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from this
	// call.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAWSDefaultServiceQuotasOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the quotas.
	Quotas []types.ServiceQuota

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAWSDefaultServiceQuotasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAWSDefaultServiceQuotas{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAWSDefaultServiceQuotas{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAWSDefaultServiceQuotasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAWSDefaultServiceQuotas(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAWSDefaultServiceQuotasAPIClient is a client that implements the
// ListAWSDefaultServiceQuotas operation.
type ListAWSDefaultServiceQuotasAPIClient interface {
	ListAWSDefaultServiceQuotas(context.Context, *ListAWSDefaultServiceQuotasInput, ...func(*Options)) (*ListAWSDefaultServiceQuotasOutput, error)
}

var _ ListAWSDefaultServiceQuotasAPIClient = (*Client)(nil)

// ListAWSDefaultServiceQuotasPaginatorOptions is the paginator options for
// ListAWSDefaultServiceQuotas
type ListAWSDefaultServiceQuotasPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from this
	// call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAWSDefaultServiceQuotasPaginator is a paginator for
// ListAWSDefaultServiceQuotas
type ListAWSDefaultServiceQuotasPaginator struct {
	options   ListAWSDefaultServiceQuotasPaginatorOptions
	client    ListAWSDefaultServiceQuotasAPIClient
	params    *ListAWSDefaultServiceQuotasInput
	nextToken *string
	firstPage bool
}

// NewListAWSDefaultServiceQuotasPaginator returns a new
// ListAWSDefaultServiceQuotasPaginator
func NewListAWSDefaultServiceQuotasPaginator(client ListAWSDefaultServiceQuotasAPIClient, params *ListAWSDefaultServiceQuotasInput, optFns ...func(*ListAWSDefaultServiceQuotasPaginatorOptions)) *ListAWSDefaultServiceQuotasPaginator {
	if params == nil {
		params = &ListAWSDefaultServiceQuotasInput{}
	}

	options := ListAWSDefaultServiceQuotasPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAWSDefaultServiceQuotasPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAWSDefaultServiceQuotasPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAWSDefaultServiceQuotas page.
func (p *ListAWSDefaultServiceQuotasPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAWSDefaultServiceQuotasOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAWSDefaultServiceQuotas(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAWSDefaultServiceQuotas(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "servicequotas",
		OperationName: "ListAWSDefaultServiceQuotas",
	}
}
